/* 
 * This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
 * Test ID: integrity/use_of_dll/cpp/01
 *
 * This software was developed at the National Institute of Standards and
 * Technology by employees of the Federal Government in the course of their
 * official duties. Pursuant to title 17 Section 105 of the United States
 * Code this software is not subject to copyright protection and is in the
 * public domain. NIST assumes no responsibility whatsoever for its use by
 * other parties, and makes no guarantees, expressed or implied, about its
 * quality, reliability, or any other characteristic.
 *
 */

#include <cstdlib>
#include <iostream>
#ifdef GNUCOMPILER
#include <dlfcn.h>
#endif

#ifdef CLCOMPILER
#include <windows.h>
#endif

#include "TestRunner.h"

TestRunner::TestRunner()
{
}

int TestRunner::run(int argc, char ** argv)
{
	#ifdef GNU_COMPILER
	void *linuxHandle;
	linuxHandle = dlopen ("libm.so", RTLD_LAZY);    /*bad*/
	if (!linuxHandle) 
	{
		fprintf (stderr, "%s\n", dlerror());
		return(1);
	}
#endif
	
#ifdef CL_COMPILER
	
	HINSTANCE windowsHandle;
	
	windowsHandle=LoadLibrary("testdll.dll"); /*bad*/
	if (windowsHandle==NULL){
		printf("handle=NULL\n");
		return(1);
	}
#endif
	
	exit(0);
}


