/* 
 * This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
 * Test ID: modularity_and_programming/no_formal_exception_handling/cpp/02
 *
 * This software was developed at the National Institute of Standards and
 * Technology by employees of the Federal Government in the course of their
 * official duties. Pursuant to title 17 Section 105 of the United States
 * Code this software is not subject to copyright protection and is in the
 * public domain. NIST assumes no responsibility whatsoever for its use by
 * other parties, and makes no guarantees, expressed or implied, about its
 * quality, reliability, or any other characteristic.
 *
 */
#include <cstdlib>
#include <malloc.h>
#include <iostream>
#include <exception>
#include "TestRunner.h"

using namespace std;

class MemoryException: public exception
{
	virtual const char* what()
	const throw()
	{
		return "Memory Exception, failed to allocate memory:";
	}
} memex;

class ReadWriteException: public exception
{
	virtual const char* what() const throw()
	{
		return "Read/Write Exception, failed to read or write properly to file";
	}
} readwriteex;

class IOException: public exception
{
	virtual const char* what() const throw()
	{
		return "IO Exception, file not opened:";
	}
} ioex;

TestRunner::TestRunner()
{
}

int TestRunner::run(int argc, char ** argv)
{
	char *memPtr;
	FILE *filePtr;
	int bytesRead;

	
	try {
		memPtr= (char *) malloc(2000); 
		if (memPtr == NULL)
		MemoryException memExcept;
		throw memex;
	}
	catch (exception& except) {
		printf("Exception: %s \n", except.what());
		exit (1);
	}
	try {
		filePtr=fopen("myfile.txt", "rb"); 
		if (filePtr == NULL)
		IOException ioExcept;
		throw ioex;
	}
	catch (exception& except) {
		printf("Exception: %s \n", except.what());
		exit (1);
	}
	try {
		bytesRead=fread(memPtr, sizeof(char), 13, filePtr); 
		if (bytesRead < 11)
		ReadWriteException readWriteExcept;
		throw readwriteex;
	}
	catch (exception& except) {
		printf("Exception: %s   \n", except.what());
		exit (1);
	}
	fclose(filePtr);
	free(memPtr);
	return(0);
}



