/*
This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
* Test ID: integrity/improper_pointer_addressing/cpp/04

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of their
official duties. Pursuant to title 17 Section 105 of the United States
Code this software is not subject to copyright protection and is in the
public domain. NIST assumes no responsibility whatsoever for its use by
other parties, and makes no guarantees, expressed or implied, about its
quality, reliability, or any other characteristic.
*/


#include "TestRunner.h"
#include <iostream>
#include <malloc.h>
#include <string.h>
#define MAXSIZE 20

TestRunner::TestRunner()
{
}


int TestRunner::run(char *str1, char *str2)
{
	char *buf=NULL, *p=NULL;
	int l=0, x=0;
	int str1len=strlen(str1);
	int str2len=strlen(str2);

	buf = (char *) malloc(MAXSIZE);
	if(!buf)
		return(1);
	p=buf;
	*buf='\0';

	l=MAXSIZE;

	strncat(buf, str1, l-1);
	*(buf+str1len)='\0';  //add null terminator to buffer
	x = strlen(buf);
	p += x;
	l -= x;
	/* there's no check on the buffer length here 
	so for a very large str2 (over 17 characters)
	you will overwrite the buffer */
	*p++ = ' ';					/* BAD */
	*p++ = '-';					/* BAD */
	*p++ = '\0';				/* BAD */
	l -= 3;						/* BAD.. computed buffer length
								could be negative, with 
								undefined results! */
	/* now length may be negative for concatenation */
	strncat(buf, str2, l);			/* BAD.. negative length could result
									in undefined behavior (overflow) */
	*(buf+str1len+2+str2len+1)='\0';  //add null terminator to buffer
	printf("result: %s\n", buf);
	free(buf);
	return(0);
}

