/*
This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
Test ID: integrity/improper_pointer_addressing/c/05

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of their
official duties. Pursuant to title 17 Section 105 of the United States
Code this software is not subject to copyright protection and is in the
public domain. NIST assumes no responsibility whatsoever for its use by
other parties, and makes no guarantees, expressed or implied, about its
quality, reliability, or any other characteristic.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	MAXSIZE		20
void
test(char *str1, char *str2)
{
	char *buf=NULL, *p=NULL;
	int l=0, x=0;
	int str1len=strlen(str1);
	int str2len=strlen(str2);

	buf = malloc(MAXSIZE);
	if(!buf)
		return;
	p=buf;
	*buf='\0';

	l=MAXSIZE;

	strncat(buf, str1, l-1);
	*(buf+str1len)='\0';  //add null terminator to buffer
	x = strlen(buf);
	p += x;
	l -= x;
	/* a guard check prevents overwriting the buffer */
	if (l > 2) {
	*p++ = ' ';					/* OK */
	*p++ = '-';					/* OK */
	*p++ = '\0';				/* OK */
	l -= 3;						/* OK */
	
	/* now remaining length (l) is 0 or more bytes */
	strncat(buf, str2, l);			/* concatenate as much of second string
									as possible in remaining buffer space */
	*(buf+str1len+3+l)='\0';  //add null terminator to buffer
	}
	printf("result: %s\n", buf);
	free(buf);
}

int
main(int argc, char **argv)
{
	char *userstr, *userstr2;

	if(argc > 2) {
		userstr = argv[1];
		userstr2 = argv[2];
		test(userstr, userstr2);
	}
	return 0;
}

