/*
This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
* Test ID: integrity/improper_dynamic_memory_management/cpp/04

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of their
official duties. Pursuant to title 17 Section 105 of the United States
Code this software is not subject to copyright protection and is in the
public domain. NIST assumes no responsibility whatsoever for its use by
other parties, and makes no guarantees, expressed or implied, about its
quality, reliability, or any other characteristic.
*/

#include <string.h>
#include "TestRunner.h"
#include <iostream>
#include <string.h>
#include <malloc.h>
#include <limits.h>

#define MAXSIZE 40

TestRunner::TestRunner()
{
}


int TestRunner::run(char *str)
{
	char *buf;

	buf = (char *)malloc(MAXSIZE);
	if(!buf)
		return(0);
	strcpy(buf, str);				/* OK */
	printf("result: %s\n", buf);
	free(buf);
	return (0);
}

char *
TestRunner::shortstr(char *p, int n, int targ)
{
	if(n > targ)
		return shortstr(p+1, n-1, targ);
	return p;
}
