/*
This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
Test ID: integrity/exceeding_array_string_boundaries/c/01

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of their
official duties. Pursuant to title 17 Section 105 of the United States
Code this software is not subject to copyright protection and is in the
public domain. NIST assumes no responsibility whatsoever for its use by
other parties, and makes no guarantees, expressed or implied, about its
quality, reliability, or any other characteristic.
*/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <wchar.h>
#include <stdlib.h>


#ifdef CLCOMPILER
#include <mbstring.h>
#include <windows.h>
#include <tchar.h>
#endif

#ifdef GNUCOMPILER
#include <alloca.h>
#endif


#define	MAXSIZE	5			/* to hold MAXSIZE-1 characters and the null terminator */
#define MAXINPUT 20		/* to hold user input, up to 19 characters plus null terminator */ 
#define MAXFUNCTION 30	    /* size of maximum funcation name, up to 19 
characters plus a null terminator */


int getinput(char * str)
{
	printf("Please enter a string, up to 19 characters\n\n");
	scanf("%19s",str);
	return 0;
}

int getmbsinput(unsigned char * mbsstr)
{
	printf("Please enter a string, up to 19 characters\n\n");
	scanf("%19s",mbsstr);
	return 0;
}

#ifdef CLCOMPILER
int getwinput(wchar_t * wstr)
{
	printf("Please enter a string, up to 19 characters\n\n");
	wscanf(L"%19s",wstr);
	return 0;
}
#endif

int getfunction(char * function)
{
	int i=0;
	char *p=function;	
	printf("\n\nThis program tests MS and GNU string functions that can potentialy result in\n");
	printf("buffer overflows.  It includes 'false positive' tests (that read input from a \n");
	printf("safe static string and 'true positive' tests where a user can suplly a long string \n");
	printf("to trigger a buffer overflow\n\n)");
	printf("To test the Microsoft functions,compile this pr0gram with the -DCLCOMPILER\n");
	printf("directive.  To test the GNU library functions, compile with -DGNUCOMPILER.\n");
	printf("A small portion of functions exist in both libraries, and are executable with either\n");
	printf("compiler directive.\n\n");
	printf("\n\nTo test a function, please enter a single function name from the list below:\n\n");

	printf("GNU and MS shared functions:\n\n");
	printf("strcpy, strncpy, strcat, strncat\n");
	printf("fscanf, scanf, sscanf\n");
	printf("sprintf, gets, memcpy\n\n");

	printf("GNU specific functions\n\n");
	printf("alloca, snprintf\n\n");

	printf("MICROSOFT-SPECIFIC string functions:\n\n");
	printf("wmemcpy, swprintf, swscanf, wscanf, fwscanf,wcsncat, wcscat,wcsncpy\n");
	printf("wcscpy, _alloca, lstrcpy, lstrcpyA, lstrcpyW, lstrcat, lstrcatA, lstrcatw\n");
	printf("_snprintf, _snwprintf, lstrcpynA, lstrcpynW, _itoa, _itow, _ltoa, _ltow, _i64toa\n");
	printf("_i64tow, _ui64toa, _ui64tow, _ultoa, _ultow, RtlCopyMemory, CopyMemory, _mbscpy\n");
	printf("_mbccpy, _mbscat, _mbsncpy, _mbsnbcpy, _mbsncat, _mbsncat\n\n");

	while((*p = getchar())!= '\n' && (i++ < MAXFUNCTION-1))  
		p++;																													
	*p = '\0'; /* add null terminator */
	return 0;
}

void print_true_positive_result_overflow_buf(char * buf)
{
	printf ("True positive test: buf[5] overflowed: is %d characters\n result:%s\n",strlen(buf), buf); 
}

void print_true_positive_result_overflow_wbuf(wchar_t * wbuf)
{
	wprintf (L"True positive test: wide char wbuf[5] overflowed: is %d characters\n result:%s\n",wcslen(wbuf),wbuf); 
}



void print_true_positive_result_ok_buf(char * buf)
{
	printf ("True positive test: buf[5] did NOT overflow (enter more input): is %d characters\n result:%s\n",strlen(buf), buf); 
}

void print_true_positive_result_ok_wbuf(wchar_t * wbuf)
{
	wprintf (L"True positive test: wide char wbuf[5] did NOT overflow (enter more input): is %d characters\n result:%s\n",wcslen(wbuf),wbuf); 
}



void print_false_positive_result_buf(char * buf)
{
	printf ("False positive test: buf[5] did NOT overflow: is %d characters\n result:%s\n",strlen(buf), buf); 
}

void print_false_positive_result_wbuf(wchar_t * wbuf)
{
	wprintf (L"False positive test: wide char wbuf[5] did NOT overflow: is %d characters\n result:%s\n",wcslen(wbuf),wbuf); 
}
#ifdef CLCOMPILER /* multibye function calls specifice to MS */

void print_false_positive_result_mbsbuf(unsigned char * mybs_buf)
{
	printf ("False positive test: wide char wbuf[5] did NOT overflow: is %d characters\n",_mbslen(mybs_buf)); 
}

void print_true_positive_result_overflow_mbsbuf(unsigned char * mbs_buf)
{
	printf ("True positive test: wide char wbuf[5] overflowed : is %d characters\n",_mbslen(mbs_buf)); 
}

void print_true_positive_result_ok_mbsbuf(unsigned char * mbs_buf)
{
	printf ("True positive test: wide char wbuf[5] did NOT overflow (enter more input): is %d characters\n",_mbslen(mbs_buf)); 
}

#endif

void print_error()
{
	printf("\n\nThe string function you typed is incorrect\n");
	printf("    or may need to compile Test.c with -DCLCOMPILER for Microsoft library functions\n");
	printf("    or may need to compile Test.c with -DGNUCOMPILER for GNU library functions\n\n");
	printf("    If all else fails, verify by consulting the file 'metadata.xml'\n");
	printf("    to verify that this test supports the function you are looking for\n\n\n");
	exit(1);
}

int exit_test()
{
	exit (0);
}

int test()
{
	char buf[MAXSIZE]={0};				 /* NULL out test buffer */
	wchar_t wbuf[MAXSIZE]={0};			 /* NULL out test wide char test buffer */
	unsigned char mbs_buf[MAXSIZE]={0};  /* NULL out multibyte test buffer */
	unsigned char *mymbs_buf = mbs_buf;
	char function[20]={0};
	char str[20]={0};
	unsigned char mbs_str[20]={0};
	wchar_t wstr[20]={0};
	int number=0;
	char *mystr={0};				/* single byte buffer for user input */	
	unsigned char *mymbs_str={0};	    /* multibyte buffer for user input */

	wchar_t *mywstr={0};			/* wide char buffer for user input */ 

	FILE *overflowstream;			/* file for 
									"true positive" FILE tests */

	FILE *ok_inputstream;			/* file for 
									"false positive" FILE tests */

	char * okstring="abcd";			 /* string constant for 
									 "false positive" tests */

	wchar_t * okwstring=L"abcd"; 	/*wide string constant for 
									"false positive" tests */

	unsigned  char *ok_mbsstr="abcd";/*multibyte string constant for 
									 "false positive" tests */

	/* strings used for "false positive" tests */
	int okint=9999;
	long int oklint=9999;
	unsigned long int okulint=9999;
	long int okllint=9999;
	unsigned long long int okullint=9999;


	// Generic functions used by Microsoft and GNU libraries

	getfunction(function);

	if (strcmp(function,"strcpy")==0)
	{
		getinput(str);	
		mystr = str;		
		strcpy(buf, okstring);	/* OK, "false positive" test */
		print_false_positive_result_buf(buf);  
		strcpy(buf, mystr);	/* BAD ..  stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)									 
			print_true_positive_result_overflow_buf(buf); 
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



	if (strcmp(function,"strncpy")==0)
	{
		getinput(str);
		mystr = str;          
		strncpy(buf, okstring, MAXSIZE-1);	/* OK, "false positive" test */
		print_false_positive_result_buf(buf);
		strncpy(buf, str, MAXINPUT-1);		/* BAD ..stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}


	if (strcmp(function,"strcat")==0)
	{
		getinput(str);
		mystr = str;      
		strcat(buf, okstring);		/* OK, "false positive" test */
		print_false_positive_result_buf(buf);
		strcat(buf, mystr);		/* BAD ..  stack may overflow */  
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



	if (strcmp(function,"strncat")==0)
	{
		getinput(str);
		mystr = str;                    
		strncat(buf, okstring, MAXSIZE-1);				/* OK, "false positive" test */
		print_false_positive_result_buf(buf);
		strncat(buf, mystr, MAXINPUT-1);				/* BAD ..  stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



	if (strcmp(function,"fscanf")==0)
	{	
		printf("Please enter an input string up to 19 characters\n");
		fscanf(stdin, "%s", buf);   /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



	if (strcmp(function,"scanf")==0)
	{	
		printf("Please enter an input string up to 19 characters\n");
		scanf("%s", buf);   /* BAD ..  stack may overflow */  
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



	if (strcmp(function,"sscanf")==0)
	{
		getinput(str);
		mystr = str;      
		sscanf(okstring, "%s", buf);				/* OK, "false positive" test */
		print_false_positive_result_buf(buf);
		sscanf(mystr, "%s", buf);               /* BAD ..  stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}


	if (strcmp(function,"sprintf")==0)
	{
		getinput(str);
		mystr = str;         
		sprintf(buf, "%s", okstring);				/* OK, "false positive" test */
		print_false_positive_result_buf(buf);
		sprintf(buf, "%s", mystr);				    /* BAD ..  stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



	if (strcmp(function,"gets")==0)
	{
		printf("please enter a string\n");
		gets(buf);                      /* BAD ..  stack may overflow */  
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"memcpy")==0)
	{
		getinput(str);
		mystr = str; 
		memcpy(buf, okstring, MAXSIZE-1);        /* OK, "false positive" test */   
		print_false_positive_result_buf(buf);
		memcpy(buf, mystr, MAXINPUT-1);           /* BAD..  stack may overflow */  
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}



#ifdef GNUCOMPILER
	if (strcmp(function,"alloca")==0)
	{
		printf("please enter a very large number, like 1000000000\n");
		scanf("%d", &number);      
		char * goodstackPter = (char *)alloca(100);  /* OK.. does not exceed
													 available stack space*/
		char * badstackPter = (char *)alloca(number);  /* BAD.. a large dynamic
													   allocation of stack 
													   memory may exceed 
													   stack limit */ 
	}
	if (strcmp(function,"snprintf")==0)
	{
		getinput(str);
		mystr = str; 
		snprintf(buf,MAXSIZE-1, "%s", okstring);			/* OK, "false positive" test */
		print_false_positive_result_buf(buf);
		snprintf(buf,MAXINPUT-1, "%s", mystr);			    /* BAD .. stack may overflow */  
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}
#endif



#ifdef CLCOMPILER
	if (strcmp(function,"wmemcpy")==0)
	{
		getwinput(wstr);
		mywstr = wstr; 
		wmemcpy(wbuf, okwstring, MAXSIZE-1);      /* OK, "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		wmemcpy(wbuf, mywstr, 19);         /* BAD..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf);  
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}


	if (strcmp(function,"swprintf")==0)
	{
		getwinput(wstr);
		mywstr = wstr;       
		swprintf(wbuf, MAXSIZE-1, L"%s", okwstring);	      /* OK .. "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		swprintf(wbuf, MAXINPUT-1, L"%s", mywstr);	          /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"swscanf")==0)
	{
		getwinput(wstr);
		mywstr = wstr;  
		swscanf(okwstring, L"%s", wbuf);             /* OK ..  "false positive"test */
		print_false_positive_result_wbuf(wbuf);
		swscanf(mywstr, L"%s", wbuf);                /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"wscanf")==0)
	{  
		printf("Please enter an input string up to 19 characters\n");
		wscanf(L"%19s",wbuf);			           /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"fwscanf")==0)
	{	
		printf("Please enter a string up to 19 characters\n");
		fwscanf(stdin, L"%s", wbuf); /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"wcsncat")==0)
	{
		getwinput(wstr);
		mywstr = wstr;  
		wcsncat(wbuf, okwstring, MAXSIZE-1);			/* OK .. "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		wcsncat(wbuf, mywstr, 19);				/* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"wcscat")==0)
	{
		getwinput(wstr);
		mywstr = wstr; 
		wcscat(wbuf, okwstring);				/* OK ..  "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		wcscat(wbuf, mywstr);				    /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"wcsncpy")==0)
	{
		getwinput(wstr);
		mywstr = wstr; 
		wcsncpy(wbuf, okwstring, MAXSIZE-1);			/* OK .. "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		wcsncpy(wbuf, mywstr, MAXINPUT-1);			    /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"wcscpy")==0)
	{
		getwinput(wstr);					
		mywstr = wstr;  
		wcscpy(wbuf, okwstring);			/* OK .. "false positive" test */ 
		print_false_positive_result_wbuf(wbuf);
		wcscpy(wbuf, mywstr);				/* BAD ..  stack may overflow */ 
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"_alloca")==0)
	{
		int number;
		void *stackPtr;
		char *goodstackPter = (char *)_alloca(100);  /* OK.. does not exceed
													 available stack space*/
		printf("please enter a very large number, like 1000000000\n");
		scanf("%d", &number);      
		stackPtr = _alloca(number);                   /* BAD.. a large 
													  dynamic allocation 
													  of stack memory can 
													  exceed stack limit */
	}

	if (strcmp(function,"lstrcpy")==0)
	{
		getinput(str);
		mystr = str; 
		lstrcpy(buf, okstring);		    /* OK ..  "false positive" test */
		print_false_positive_result_buf(buf);
		lstrcpy(buf, mystr);		    /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"lstrcpyA")==0)
	{
		getinput(str);
		mystr = str;  
		lstrcpyA(buf, okstring);		/* OK ..  "false positive" test */
		print_false_positive_result_buf(buf);
		lstrcpyA(buf, mystr);		    /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"lstrcpyW")==0)
	{
		getwinput(wstr);
		mywstr = wstr;  
		lstrcpyW(wbuf, okwstring);			/* OK ..  "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		lstrcpyW(wbuf, mywstr);			/* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"lstrcat")==0)
	{
		getinput(str);
		mystr = str; 
		lstrcat(buf, okstring);				     /* OK ..  "false positive" test */
		print_false_positive_result_buf(buf);
		lstrcat(buf, mystr);				     /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"lstrcatA")==0)
	{
		getinput(str);
		mystr = str;   
		lstrcatA(buf, okstring);				 /* OK ..  "false positive" test */
		print_false_positive_result_buf(buf);
		lstrcatA(buf, mystr);				     /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}
	if (strcmp(function,"lstrcatW")==0)
	{
		getwinput(wstr);
		mywstr = wstr;       
		lstrcatW(wbuf, okwstring);				 /* OK ..  "false positive" test */
		print_false_positive_result_wbuf(wbuf);
		lstrcatW(wbuf, mywstr);				     /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}
	if (strcmp(function,"_snprintf")==0)
	{
		getinput(str);
		mystr = str;   
		_snprintf(buf,MAXSIZE-1, "%s", okstring);	 /* OK ..  "false positive" test */
		print_false_positive_result_buf(buf);
		_snprintf(buf,MAXINPUT-1, "%s", mystr);		 /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"_snwprintf")==0)
	{
		getwinput(wstr);
		mywstr = wstr;     
		_snwprintf(wbuf,MAXSIZE-1, L"%s", okwstring);	 /* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		_snwprintf(wbuf,MAXINPUT-1, L"%s", mywstr);		 /* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"lstrcpynA")==0)
	{
		getinput(str);
		mystr = str;           
		lstrcpynA(buf, okstring, MAXSIZE-1);			/* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		lstrcpynA(buf, mystr, MAXINPUT-1);				/* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}
	if (strcmp(function,"lstrcpynW")==0)
	{
		getwinput(wstr);
		mywstr = wstr;  
		lstrcpynW(wbuf, okwstring, MAXSIZE-1);			/* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		lstrcpynW(wbuf, mywstr, MAXINPUT-1);				/* BAD ..  stack may overflow */
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"_itoa")==0)
	{
		int i;
		printf ("Enter a number over 4 characters between INT_MIN and INT_MAX\n");
		scanf ("%d",&i);
		_itoa (okint,buf,10);	/* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		_itoa (i,buf,MAXINPUT-1);		/* BAD.. stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();

	}

	if (strcmp(function,"_itow")==0)
	{
		int i;
		printf ("Enter a number over 4 characters between INT_MIN and INT_MAX\n");
		scanf ("%d",&i);
		_itow (okint,wbuf,10);  /* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		_itow (i,wbuf,10);      /* BAD.. stack may overflow */ 
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();

	}

	if (strcmp(function,"_ltoa")==0)
	{
		long i;
		printf ("Enter a number over 4 characters between LONG_MIN and LONG_MAX\n");
		scanf ("%d",&i);
		_ltoa (oklint,buf,10);	/* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		_ltoa (i,buf,10);		/* BAD.. stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"_ltow")==0)
	{
		long i;
		printf ("Enter a number over 4 characters between LONG_MIN and LONG_MAX\n");
		scanf ("%d",&i);
		_ltow (oklint,wbuf,10);		/* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		_ltow (i,wbuf,10);			/* BAD.. stack may overflow */ 
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}

	if (strcmp(function,"_i64toa")==0)
	{
		_int64 i;
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		scanf ("%I64d",&i);
		_i64toa (okllint,buf,10);	/* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		_i64toa (i,buf,10);			/* BAD.. stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"_i64tow")==0)
	{
		_int64 i;
		scanf ("%I64d",&i);
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		scanf ("%d",&i);
		_i64tow (okllint,wbuf,10);	/* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		_i64tow (i,wbuf,10);		/* BAD.. stack may overflow */ 
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}


	if (strcmp(function,"_ui64toa")==0)
	{
		unsigned _int64 i;
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		scanf ("%I64d",&i);
		_ui64toa (okullint,buf,10);	/* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		_ui64toa (i,buf,10);		/* BAD.. stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}


	if (strcmp(function,"_ui64tow")==0) /* problem with compiler interpretation of
										unsigned _int64, but test still demonstrates
										overflow possibility */
	{
		_int64 i;
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		scanf ("%d",&i);
		_ui64tow (okullint,wbuf,10);	/* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		_ui64tow (i,wbuf,10);			/* BAD.. stack may overflow */ 
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}


	if (strcmp(function,"_ultoa")==0)
	{
		unsigned long i;
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		scanf ("%d",&i);
		_ultoa (okulint,buf,10);	/* OK.. "false positive" test */
		print_false_positive_result_buf(buf);
		_ultoa (i,buf,10);			/* BAD.. stack may overflow */ 
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"_ultow")==0)
	{
		unsigned long i;
		printf ("Enter a number over 4 characters between INT64_MIN and INT64_MAX\n");
		scanf ("%d",&i);
		_ultow (okulint,wbuf,10);	/* OK .. "false positive test */
		print_false_positive_result_wbuf(wbuf);
		_ultow (i,wbuf,10);			/* BAD.. stack may overflow */ 
		if (wcslen(wbuf) > MAXSIZE-1)
			print_true_positive_result_overflow_wbuf(wbuf); 
		else
			print_true_positive_result_ok_wbuf(wbuf);
		exit_test();
	}


	if (strcmp(function,"RtlCopyMemory")==0)
	{
		getinput(str);
		mystr = str;   
		RtlCopyMemory(buf, okstring, MAXSIZE-1);	 /* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		RtlCopyMemory(buf, mystr, MAXINPUT-1);		 /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}

	if (strcmp(function,"CopyMemory")==0)
	{
		getinput(str);
		mystr = str;  
		CopyMemory(buf, okstring, MAXSIZE-1);	 /* OK .. "false positive test */
		print_false_positive_result_buf(buf);
		CopyMemory(buf, mystr, MAXINPUT-1);		 /* BAD ..  stack may overflow */
		if (strlen(buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_buf(buf);
		else
			print_true_positive_result_ok_buf(buf);
		exit_test();
	}
	/* These are multibyte functions */

	if (strcmp(function,"_mbscpy")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str;
		_mbscpy(mymbs_buf, ok_mbsstr);	        /* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbscpy(mymbs_buf,mymbs_str);	        /* BAD ..  stack may overflow */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf); 
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}

	if (strcmp(function,"_mbccpy")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str;
		_mbccpy(mymbs_buf, okstring);		/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbccpy(mbs_buf, mystr);			/* BAD ..  stack may overflow */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf);
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}

	if (strcmp(function,"_mbscat")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str; 
		_mbscat(mymbs_buf, okstring);		/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbscat(mymbs_buf, mymbs_str);			/* BAD ..  stack may overflow */
		if (_mbslen(mymbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf);
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}
	if (strcmp(function,"_mbsncpy")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str;  
		_mbsncpy(mymbs_buf, okstring, MAXSIZE-1);	/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbsncpy(mymbs_buf, mymbs_str, MAXINPUT-1);		/* BAD ..  stack may overflow */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf);
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}
	if (strcmp(function,"_mbsnbcpy")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str;
		_mbsnbcpy(mbs_buf, okstring, MAXSIZE-1);	/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbsnbcpy(mbs_buf, mymbs_str, MAXINPUT-1);		/* BAD ..  stack may overflow */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf);  
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}
	if (strcmp(function,"_mbsncat")==0)
	{	
		getmbsinput(mbs_str);
		mymbs_str=mbs_str; 
		_mbsncat(mbs_buf, okstring, MAXSIZE-1);		/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbsncat(mbs_buf, mymbs_str, MAXINPUT-1);		/* BAD ..  stack may overflow */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf); 
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}

	if (strcmp(function,"_mbsnbcat")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str;
		_mbsnbcat(mbs_buf, okstring, MAXSIZE-1);	/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbsnbcat(mbs_buf, mymbs_str, MAXINPUT-1);		/* BAD ..  stack may overflow */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf); 
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}
	if (strcmp(function,"_mbsncat")==0)
	{
		getmbsinput(mbs_str);
		mymbs_str=mbs_str;   
		_mbsncat(mbs_buf, okstring, MAXSIZE-1);		/* OK .. "false positive test */
		print_false_positive_result_mbsbuf(mbs_buf);
		_mbsncat(mbs_buf, mymbs_str, MAXINPUT-1);		/* BAD ..  stack may overflown */
		if (_mbslen(mbs_buf)> MAXSIZE-1)	
			print_true_positive_result_overflow_mbsbuf(mbs_buf); 
		else
			print_true_positive_result_ok_mbsbuf(mbs_buf);
		exit_test();
	}

#endif //  end if CL compiler

	print_error();
	return (1);
}

int main(int argc, char **argv)
{
	test();
	return 0;
}



