<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="Test">
	<xsl:apply-templates/>
</xsl:template>
	<xsl:template match="Description">
		<h2>Test Description:</h2>
				<blockquote>
		<xsl:value-of select="."/>
		</blockquote>
	</xsl:template>
		<xsl:template match="TestId">
		<hr/>
		<h2>Test ID:  </h2>
		<blockquote><xsl:value-of select="."/></blockquote>
	</xsl:template>
	<xsl:template match="RequirementId">
		<hr/>
		<h2>Requirement ID:  <xsl:value-of select="."/></h2>
	</xsl:template>
	<xsl:template match="ExpectedResult">
	<hr/>
		<h2>Expected Test Results:</h2>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
	</xsl:template>
	<xsl:template match="File">
		<b>File:</b>
		<xsl:if test="@path">
		<!--
path = <xsl:text disable-output-escaping="yes" >&lt;a href='./</xsl:text><xsl:value-of select="@path"/>'<xsl:text disable-output-escaping="yes" >&gt; </xsl:text><xsl:value-of select="@path"/> <xsl:text disable-output-escaping="yes" >&lt;/a&gt; </xsl:text>
-->
path = <xsl:value-of select="@path"/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="CodingConventionViolation">
	<p>
		<b>Coding Convention Violation:</b>
name = <xsl:value-of select="@name"/> , 
		<xsl:if test="@module">
function = <xsl:value-of select="@module"/>
		</xsl:if>
				<xsl:if test="@class">
module = <xsl:value-of select="@class"/>
		</xsl:if>
<xsl:if test="@line">
line = <xsl:value-of select="@line"/> 
</xsl:if>

		</p>
		<xsl:apply-templates/>
	</xsl:template>
	
		<xsl:template match="FalsePositive">
		<xsl:if test="@module">
function = <xsl:value-of select="@module"/>
		</xsl:if>
				<xsl:if test="@class">
module = <xsl:value-of select="@class"/>
		</xsl:if>
<xsl:if test="@line">
line = <xsl:value-of select="@line"/> 
</xsl:if>
<p>This is a <i>false positive</i> test.
		</p>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="ToolRecommendations">
		<hr/>
		<h2>Tool Recommendations:</h2>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
	</xsl:template>
	<xsl:template match="StyleChecker">
	<p>
		<h3><i>Style Checker</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	<xsl:template match="BugCheckerOrSecurityAnalyzer">
	<p>
		<h3><i>Bug Checker or Security Analyzer</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	
		<xsl:template match="BugChecker">
	<p>
		<h3><i>Bug Checker</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	
			<xsl:template match="SecurityAnalyzer">
	<p>
		<h3><i>Security Analyzer</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	
				<xsl:template match="StyleCheckerOrBugCheckerOrSecurityAnalyzer">
	<p>
		<h3><i>Style Checker, Bug Checker or Security Analyzer</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	<xsl:template match="Compiler">
	<p>
		<h3><i>Compiler</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	
		<xsl:template match="Human">
	<p>
		<h3><i>Human Analysis</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	
	<xsl:template match="CodeUnderstandingTool">
	<p>
		<h3><i>Code Understanding Tool</i></h3>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
		<xsl:template match="Configuration">
	<p>
		<b>Configuration:</b>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
			<xsl:template match="Extension">
	<p>
		<b>Extension:</b>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>

	<xsl:template match="Text">
	<p><xsl:value-of select="."/></p>
	</xsl:template>
		<xsl:template match="TestDesign">
		<hr/>
		<p>
		<h2>Test Design:</h2>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
			<xsl:template match="TestAnalysis">
			<hr/>
		<p>
		<h2>Test Analysis:</h2>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
				<xsl:template match="ToolNotes">
		<p>
		<b>Tool Notes:</b>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
	
				<xsl:template match="Analysis">
		<p>
		<b>Analysis:</b>
		<blockquote>
		<xsl:apply-templates/>
		</blockquote>
		</p>
	</xsl:template>
</xsl:stylesheet>
