/* 
 * This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
 * Test ID: other_coding_conventions/no_vote_count_overflow_controls/c/11
 *
 * This software was developed at the National Institute of Standards and
 * Technology by employees of the Federal Government in the course of their
 * official duties. Pursuant to title 17 Section 105 of the United States
 * Code this software is not subject to copyright protection and is in the
 * public domain. NIST assumes no responsibility whatsoever for its use by
 * other parties, and makes no guarantees, expressed or implied, about its
 * quality, reliability, or any other characteristic.
 *
 */

#include <stdio.h>
#include <limits.h>
#include <stdlib.h>
int divide (int,int);
int divideCheck(int,int);
int main(int argc, char **argv)
{
	if (argc == 3)
	{
		int arg1 = atoi(argv[1]);
		int arg2 = atoi(argv[2]);
		printf("result is %d\n",divide(arg1, arg2 ));
	}
	else
	{
		printf("\nneed two integers as input\n");
	}
	return (0);
}
int divide (int int1, int int2)
{
	int result;
	/* ok - check is performed before divide*/
	divideCheck (int1, int2);
	result = int1 / int2;
	return result;
}
int divideCheck (int int1, int int2)
{
	if ( (int2 == 0) || ( (int1 == INT_MIN) && (int2 == -1) ) ) {
		printf("integer overflow\n");
		exit (1);
	}
	else
	return 0;
}
