/* 
 * This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
 * Test ID: other_coding_conventions/no_uniform_calling_sequences/c/01
 *
 * This software was developed at the National Institute of Standards and
 * Technology by employees of the Federal Government in the course of their
 * official duties. Pursuant to title 17 Section 105 of the United States
 * Code this software is not subject to copyright protection and is in the
 * public domain. NIST assumes no responsibility whatsoever for its use by
 * other parties, and makes no guarantees, expressed or implied, about its
 * quality, reliability, or any other characteristic.
 *
 */
#include <stdio.h>
#include <limits.h>
#include <stdlib.h>

#define TOTALVOTES_MAX 1000000
#define PRECINCTVOTES_MAX 100000

int add (int,int);
int rangeCheck (int,int);

int main(int argc, char **argv)
{
	if (argc == 3)
	{
		int arg1 = atoi(argv[1]);
		int arg2 = atoi(argv[2]);
		printf("result is %d\n",add(arg1, arg2 ));
	}
	else
	{
		printf("\nneed two integers as input\n");
	}
	return (0);
}
int add ( int int1, int int2)
{
	int result;
	rangeCheck (int1, int2); /* ok */
	result = int1 + int2;
	return result;
}


int rangeCheck ( int precinctVotes, int totalVotes)
{
	if ( (precinctVotes<0) || (precinctVotes>PRECINCTVOTES_MAX) || (totalVotes<0) || (totalVotes>TOTALVOTES_MAX) )
	{
		printf("vote count error\n");
		exit (1);
	}
	else
	return 0;
}

