/* 
 * This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
 * Test ID: other_coding_conventions/does_not_return_zero_for_success/c/02
 *
 * This software was developed at the National Institute of Standards and
 * Technology by employees of the Federal Government in the course of their
 * official duties. Pursuant to title 17 Section 105 of the United States
 * Code this software is not subject to copyright protection and is in the
 * public domain. NIST assumes no responsibility whatsoever for its use by
 * other parties, and makes no guarantees, expressed or implied, about its
 * quality, reliability, or any other characteristic.
 *
 */
#include <stdio.h>
#include <string.h>

char result[8];
char *ptr = result;
char * func(void);

int main()
{
	ptr = func();					/* call a function.		*/
	printf("\nfunction returned %s\n", ptr);
	if (strcmp(ptr,"success")==0)
	{
	return 0;
	}
	else
	{
	return 1;
	}
}
/*F*****************************************************************
* NAME :            char runc(void)
*
* UNIT PURPOSE: 
*         To do something important
*
* INPUTS :
*       PARAMETERS:
*           nNone
*       GLOBALS :
*           None
* OUTPUTS :
*       PARAMETERS:
*           None
*       GLOBALS :
*           None
*       RETURN :
*           Type:   char *                   
*           Values: A pointer to a string value of either "success" or "failure" is used for this application 
*                   rather than the traditional "1" and "0" because of .... some valid reason
* CALLS :
*           None
* FILES :
*			None
*
* PROCESS :
*                   [1]  Do something important
*                   [2]  Return a value of "success" or "fail"
*
* CHANGES :
* REF NO    DATE    WHO     DETAIL
*           12Jan08 MK      Original Code
*                          
F*/
char * func(void)
{
	printf("Did something important here that should be verified!!!!\n");
	return ("success");
}
