#!/bin/sh 
################################################################################
# 
# This script is part of the NIST Source Code Analysis Tool Assessment Test Suite
# Test ID: modularity_and_programming/missing_header_comment/c/01
#
# This software was developed at the National Institute of Standards and
# Technology by employees of the Federal Government in the course of their
# official duties. Pursuant to title 17 Section 105 of the United States
# Code this software is not subject to copyright protection and is in the
# public domain. NIST assumes no responsibility whatsoever for its use by
# other parties, and makes no guarantees, expressed or implied, about its
# quality, reliability, or any other characteristic.
#
################################################################################
# This shell script is generic in design, and should work with any
# type of command-line source code analysis/build tool, such as compilers, 
# security analyzers and build utilities.  It is designed and makes assumptions
# on file locations based upon the directory structure of the NIST Source Code 
# Analyzer Test Suite.  It will not work on other directory structures without 
# modification. It MUST be run out of the tool_tests directory in order to work
# properly.
#
# Below are example commands to compile this test suite under
# different OS, test language and compiler scenarios.
# 
#
# To compile all the c tests using the gcc compiler:
# run-tool.sh -t gcc -o '-DDEBUG -DGNUCOMPILER -ldl' -l c
#
# To compile all the c++ tests using the gcc compiler:
# run-tool.sh -t g++ -o '-DDEBUG  -DGNUCOMPILER -ldl' -l cpp 
#
# To compile all the java tests using the Sun Microsystems javac compiler:
# run-tool.sh -t javac -o  -l java
#
# To compile all of the "integrity" tests only, using the gcc compiler:
# run-tool.sh -t gcc -o '-DDEBUG -DGNUCOMPILER -ldl' -l c -d integrity
#
# Although this shell script was built as a QA tool to verify that NIST 
# source code anlysis tool test code will compile, it can be used to run other 
# tools besides compilers. 
# 
# For example, to run a source analysis tool on the c language
# tests that requires a compiler name and defines the DEBUG macro:
# run-tool.sh -t my_analysis_tool -o 'gcc -DDEBUG -DGNUCOMPILER -ldl'  -l c
#
# To compile tests that use make, nmake, ant or other build utily, one could 
# compile them by including the -b flag when invoking this script (for c code tests):
# run-tool.sh -t make -o 'clean'  -l c -b true
#
################################################################################
#
# Function to print help
#
#
#Start main procedure

#
#if no arguments, print help
#

print_help_cmp()
{
echo "Usage: tool_test.sh -t tool_command -l language  [-o 'tool_options'] -d [directory_path] [-b true]"
echo "Where: "
echo "tool_command argument = gcc, or cl, or make, or ant ...etc... (this is a required field)"
echo "language =  c, cpp or java only  (this is a required field)"
echo "tool_options = any of the tool's option flags and arguments... e.g.  '-Wall -c -DDEBUG'  (enclosed in single quotes!!)"
echo "directory_path = starting directory path (optional field, default is current working directory)"
echo "true = build flag (indicates the tool is a command-line build tool.. like make, nmake or ant)"

echo "Some examples:"

echo "(compile all the c tests using the gcc compiler)"
echo "run-tool.sh -t gcc -o '-DDEBUG -DGNUCOMPILER -ldl' -l c"
echo "(compile all the c++ tests using the gcc compiler)"
echo "run-tool.sh -t g++ -o '-DDEBUG -DGNUCOMPILER -ldl' -l cpp "
echo "(compile all the java tests using the Sun Micosystems javac compiler)"
echo "run-tool.sh -t javac -o  -l java"
echo "(compile all the java tests for comment conventions)"
echo "run-tool.sh -t javac -o  -l java -d comment_conventions"
echo "(run a code analysis tool that needs a compiler name as an argument)"
echo "run-tool.sh -t my_analysis_tool -o 'gcc -DDEBUG -DGNUCOMPILER -ldl'  -l c"
echo "(compile all tests using make (for c code tests))"
echo "run-tool.sh -t make -o 'clean' -l c -b true"
return
}

if [ $# -lt 1 ]; then
  print_help_cmp
  exit
fi

while getopts d:t:o:l:b: opt
do
  case "$opt" in
    d) directory="$OPTARG";;
    t) tool="$OPTARG";;
    o) tool_opts="$OPTARG";;
    l) language="$OPTARG";;
    b) build="$OPTARG";;
    \?) print_help_cmp;;
  esac
done

#
# test for minimum require arguments
#
if (test "$tool" -a "$language") 
then
#
# set defaults if values not provided
#
if test "$directory" == ""
then
set directory = $PWD
fi

if test "$tool_opts" == ""
then
set tool_opts = " "
fi

if test "$build" == "true"
then
  echo "Start in directory: $directory, with tool: $tool, with options: $tool_opts, source language: $language, build: $build"
  find $directory -name $language -exec run-util.sh {}  $tool "$tool_opts" $language $build  \;
else
  echo "Start in directory: $directory, with tool: $tool, with options: $tool_opts, source language: $language"
  find $directory -name $language -exec run-util.sh {}  $tool "$tool_opts" $language  \;
fi
else
#
# print help if minimum input is not provided
#
print_help_cmp
fi
exit

