/* 
 * This test is part of the NIST Source Code Analysis Tool Assessment Test Suite
 * Test ID: other_coding_conventions/no_vote_count_overflow_controls/cpp/10
 *
 * This software was developed at the National Institute of Standards and
 * Technology by employees of the Federal Government in the course of their
 * official duties. Pursuant to title 17 Section 105 of the United States
 * Code this software is not subject to copyright protection and is in the
 * public domain. NIST assumes no responsibility whatsoever for its use by
 * other parties, and makes no guarantees, expressed or implied, about its
 * quality, reliability, or any other characteristic.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "Util.h"
#include <limits.h>

Util::Util ()
{
}

int Util::multiply(int int1, int int2)
{
	int result;
	/* ok - check is made before multiply*/
	multiplyCheck (int1, int2);
	result = int1 * int2;
	return result;
}

int Util::multiplyCheck (int int1, int int2)
{
	if (int1 > 0){  /* int1 is positive */
		if (int2 > 0) {  /* int1 and int2 are positive */
			if (int1 > (INT_MAX / int2)) {
				printf ("integer overflow\n");
				exit (1);
			}
			else
			return (0);
		} /* end if int1 and int2 are positive */
		else { /* int1 positive, int2 non-positive */
			if (int2 < (INT_MIN / int1)) {
				printf ("integer overflow\n");
				exit (1);
			}
		} /* int1 positive, int2 non-positive */
	} /* end if int1 is positive */
	else { /* int1 is non-positive */
		if (int2 > 0) { /* int1 is non-positive, int2 is positive */
			if (int1 < (INT_MIN / int2)) {
				printf ("integer overflow\n");
				exit (1);
			}
			else
			return (0);
		} /* end if int1 is non-positive, int2 is positive */
		else { /* int1 and int2 are non-positive */
			if ( (int1 != 0) && (int2 < (INT_MAX / int1))) {
				printf ("integer overflow\n");
				exit (1);
			}
			else
			return (0);
		} /* end if int1 and int2 are non-positive */
	} /* end if int1 is non-positive */
	return 0;
}
