/************************************************************/
/*         File Name: Xtrctcls.c                            */
/*         Package:   NIST CLS Extraction Utility           */
/*         Author:    Michael D. Garris                     */
/*         Date:      1/17/92                               */
/************************************************************/
#include <stdio.h>
#include <memory.h>
#include <ihead.h>
#include <mfs.h>

#define PRINT_HEX 0
#define PRINT_CHAR 1

/************************************************************/
/* Takes a NIST CLS file and extracts the class at the      */
/* postion defined by the parameter "index". If an option   */
/* of "-c" is specified, then the class value is printed    */
/* as an ASCII character. If an option of "-h" is specified,*/
/* then the class value is printed as a hex number.         */
/************************************************************/
main(argc,argv)
int argc;
char *argv[];
{
   char *mfsfile;
   MFS *mfs;
   int option, index, letter;

   procargs(argc, argv, &option, &mfsfile, &index);
   mfs = readmfsfile(mfsfile);
   if(index >= mfs->num)
      fatalerr("main", "Bad index", NULL);
   if(option == PRINT_HEX)
      fprintf(stdout, "%s\n", mfs->values[index]);
   else{
      sscanf(mfs->values[index], "%x", &letter);
      fprintf(stdout, "%c\n", letter);
   }
   freemfs(mfs);
}

procargs(argc, argv, option, mfsfile, index)
int argc, *option, *index;
char *argv[], **mfsfile;
{
  int c, h;

  if (argc != 4)
     fatalerr("Usage", argv[0], "-{c,h} <clsfile> <index>");
  c = strcmp(argv[1], "-c");
  h = strcmp(argv[1], "-h");
  if((c != 0) && (h != 0)){
     fprintf(stderr, "Invalid Option\n");
     fatalerr("Usage", argv[0], "-{c,h} <clsfile> <index>");
  }
  if(c == 0)
     *option = PRINT_CHAR;
  else
     *option = PRINT_HEX;
  *mfsfile = argv[2];
  sscanf(argv[3], "%d", index);
}
