/************************************************************/
/*         File Name: MFS.c                                 */
/*         Package:   NIST Multiple Feature Set Utilities   */
/*                                                          */
/*         Contents:  Freemfs()                             */
/*                    Readmfsfile()                         */
/************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include <mfs.h>

/************************************************************/
void freemfs(mfsptr)
MFS *mfsptr;
{
  int item;
  for (item=0;item<mfsptr->num;item++)
      free(mfsptr->values[item]);
  free((char *)mfsptr->values);
  free((char *)mfsptr);
}

/************************************************************/
MFS *readmfsfile(file)
char *file;
{
  MFS *mfsptr = NULL;
  FILE *mfs = NULL;
  int feature_number = 0;
  int ac;
  char line[MAXMFSLENGTH],**value;

  mfs = fopen(file,"r");
  if (mfs == NULL)
     syserr("readmfsfile","fopen",file);

  if (fgets(line,MAXMFSLENGTH-1,mfs) == (char *)NULL) 
     syserr("readmfsfile","fgets",NULL);
  if (sscanf(line,"%d",&ac) != 1)
     syserr("readmfsfile","sscanf","ac");
  if (ac <1)
     fatalerr("readmfsfile",file,"count less then 1");
  if ((value = (char **)malloc(sizeof(char *) * ac)) == NULL)
     syserr("readmfsfile","malloc","value");
  for (feature_number = 0;feature_number<ac; feature_number+=1)
      {
         if(fgets(line, sizeof(line),mfs) == NULL)
            fatalerr("readmfsfile",file,"EOF unexpected");
         line[strlen(line)-1] = '\0';
         value[feature_number] = strdup(line);
         if(value[feature_number] == NULL)
            syserr("readmisfile","strdup","value[]");
      }
  fclose(mfs);
  if ((mfsptr = (MFS *)malloc(sizeof(MFS))) == NULL)
     syserr("readmfsfile","malloc","mfsptr");
  mfsptr->alloc = ac;
  mfsptr->num = ac;
  mfsptr->values = value;
  return(mfsptr);
}
