HDIR = .
IDIR = $(HDIR)
INCLUDES = -I$(IDIR)

CFLAGS = -g $(INCLUDES)

LIBS= -lm

DEFS = $(IDIR)/mis.h \
	$(IDIR)/ihead.h \
	$(IDIR)/g4decomp.h

all: dumpihdr decomp fragmis htoc ihdr2sun sunalign xtrctcls xtrctmis

dumpihdr: dumpihdr.o ihead.o $(IDIR)/ihead.h
	cc -g -o dumpihdr dumpihdr.o ihead.o $(LIBS)

decomp: decomp.o loadihdr.o writihdr.o ihead.o g4decomp.o util.o \
	$(IDIR)/ihead.h $(IDIR)/g4decomp.h
	cc -g -o decomp decomp.o loadihdr.o writihdr.o ihead.o \
	g4decomp.o util.o $(LIBS)

fragmis: fragmis.o loadihdr.o writihdr.o mis.o ihead.o g4decomp.o \
	util.o $(DEFS)
	cc -g -o fragmis fragmis.o loadihdr.o writihdr.o mis.o ihead.o \
	g4decomp.o util.o $(LIBS)

htoc: htoc.o util.o
	cc -g -o htoc htoc.o util.o $(LIBS)

ihdr2sun: ihdr2sun.o loadihdr.o ihead.o g4decomp.o $(IDIR)/ihead.h \
	$(IDIR)/g4decomp.h
	cc -g -o ihdr2sun ihdr2sun.o loadihdr.o ihead.o g4decomp.o $(LIBS)

sunalign: sunalign.o util.o
	cc -g -o sunalign sunalign.o util.o $(LIBS)

xtrctcls: xtrctcls.o mfs.o util.o $(IDIR)/mfs.h
	cc -g -o xtrctcls xtrctcls.o mfs.o util.o $(LIBS)

xtrctmis: xtrctmis.o loadihdr.o writihdr.o mis.o ihead.o g4decomp.o \
	util.o $(DEFS)
	cc -g -o xtrctmis xtrctmis.o loadihdr.o writihdr.o mis.o ihead.o \
	g4decomp.o util.o $(LIBS)

dumpihdr.o: dumpihdr.c $(IDIR)/ihead.h
decomp.o: decomp.c $(IDIR)/ihead.h
fragmis.o: fragmis.c $(IDIR)/ihead.h $(IDIR)/mis.h
htoc.o: htoc.c
ihdr2sun.o: ihdr2sun.c $(DEFS)
sunalign.o: sunalign.c
xtrctcls.o: xtrctcls.c $(IDIR)/mfs.h
xtrctmis.o: xtrctmis.c $(IDIR)/ihead.h $(IDIR)/mis.h
g4decomp.o: g4decomp.c $(IDIR)/g4decomp.h
ihead.o: ihead.c $(IDIR)/ihead.h
loadihdr.o: loadihdr.c $(DEFS)
mfs.o: mfs.c $(IDIR)/mfs.h
mis.o: mis.c $(IDIR)/ihead.h $(IDIR)/mis.h
util.o: util.c
writihdr.o: writihdr.c $(IDIR)/ihead.h
