/************************************************************/
/*         File Name: Decomp.c                              */
/*         Package:   NIST Ihead Group 4 Decompression      */
/*         Author:    Michael D. Garris                     */
/*         Date:      1/17/92                               */
/************************************************************/
#include <stdio.h>
#include <ihead.h>

/************************************************************/
/* Decompresses Group 4 compressed NIST ihead image.        */
/************************************************************/
main(argc,argv)
int argc;
char *argv[];
{
   int width,height;
   char *filein, *fileout;
   unsigned char *data;
   IHEAD *ihead;

   procargs(argc,argv,&filein, &fileout);
   readihdrfile(filein,&ihead,&data,&width,&height);
   if(strlen(fileout) >= BUFSIZE)
      fatalerr("main", "Output file name overflow", fileout);
   strcpy(ihead->id, fileout);
   writeihdrfile(fileout, ihead, data);
   free(ihead);
   free(data);
}
 
procargs(argc,argv,filein, fileout)
int argc;
char *argv[],**filein, **fileout;
{
   if(argc < 3){
      fprintf(stderr,"Usage: decomp <IHead file in> <IHead file out>\n");
      exit(-1);
   }
  *filein = argv[1];
  *fileout = argv[2];
}
