<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <xsl:preserve-space elements="textoutput"/>
    <xsl:output cdata-section-elements="textoutput comments"/>
    <xsl:template match="/BugCollection">
        <xsl:text>
</xsl:text>
        <report>
            <xsl:attribute name="tool_name">FindBugs</xsl:attribute>
            <xsl:attribute name="tool_version">
                <xsl:value-of select="@version"/>
            </xsl:attribute>
            <xsl:attribute name="xsi:noNamespaceSchemaLocation"
                >file:/Users/pugh/Documents/eclipse/workspace/SATE/sate.xsd</xsl:attribute>

            <xsl:for-each select="BugInstance">
                <xsl:text>
</xsl:text>
                <xsl:variable name="bugCategory">
                    <xsl:value-of select="@category"/>
                </xsl:variable>
                <xsl:variable name="bugType">
                    <xsl:value-of select="@type"/>
                </xsl:variable>
                <xsl:variable name="bugPattern">
                    <xsl:value-of select="//BugPattern[@type=$bugType]"/>
                </xsl:variable>
                <xsl:variable name="bugKindAbbrev">
                    <xsl:value-of select="//BugPattern[@type=$bugType]/@abbrev"/>
                </xsl:variable>
                <xsl:variable name="bugKind">
                    <xsl:value-of select="//BugCode[@abbrev=$bugKindAbbrev]"/>
                </xsl:variable>


                <weakness>
                    <xsl:attribute name="id">
                        <xsl:value-of select="count(preceding-sibling::BugInstance) + 1"/>
                    </xsl:attribute>
                    <xsl:attribute name="tool_specific_id">fb-<xsl:value-of select="@instanceHash"
                            />-<xsl:value-of select="@instanceOccurrenceNum"/>-<xsl:value-of
                            select="@instanceOccurrenceMax"/>
                    </xsl:attribute>
                    <xsl:text>
                    </xsl:text>
                    <name>
                        <xsl:choose>
                            <xsl:when test="//BugPattern[@type=$bugType]/@cweid">
                                <xsl:attribute name="cweid">  <xsl:value-of select="//BugPattern[@type=$bugType]/@cweid"/>
                            </xsl:attribute></xsl:when>
                            <xsl:when test="//BugCode[@abbrev=$bugKindAbbrev]/@cweid">
                                <xsl:attribute name="cweid">  <xsl:value-of select="//BugCode[@abbrev=$bugKindAbbrev]/@cweid"/>
                                </xsl:attribute></xsl:when>
                            <xsl:otherwise></xsl:otherwise>
                        </xsl:choose>
                        <xsl:value-of select="@type"/>
                    </name>
                    <xsl:for-each select="SourceLine">
                        <xsl:text>
                        </xsl:text>
                        <location>
                            <xsl:attribute name="path">
                                <xsl:choose>
                                    <xsl:when test="@relSourcepath"> <xsl:value-of select="@relSourcepath"/></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="@sourcepath"/></xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                            <xsl:attribute name="line">
                                <xsl:value-of select="@start"/>
                            </xsl:attribute>
                        </location>
                    </xsl:for-each>
                    <xsl:text>
                    </xsl:text>
                    <xsl:choose>
                        <xsl:when test="$bugCategory =  'SECURITY'">
                            <grade>
                                <xsl:attribute name="severity">
                                    <xsl:value-of select="-1+2*@priority"/>
                                </xsl:attribute>
                                <xsl:attribute name="probability">0.8 </xsl:attribute>
                            </grade>
                        </xsl:when>
                        <xsl:when test="$bugCategory = 'CORRECTNESS'">
                            <grade>
                                <xsl:attribute name="severity">
                                    <xsl:value-of select="-1+2*@priority"/>
                                </xsl:attribute>
                                <xsl:attribute name="probability">0.7 </xsl:attribute>
                            </grade>
                        </xsl:when>
                        <xsl:when test="$bugCategory = 'MALICIOUS_CODE'">
                            <grade>
                                <xsl:attribute name="severity">
                                    <xsl:value-of select="-1+2*@priority"/>
                                </xsl:attribute>
                                <xsl:attribute name="probability">0.4</xsl:attribute>
                            </grade>
                        </xsl:when>
                        <xsl:when test="$bugCategory = 'MT_CORRECTNESS'">
                            <grade>
                                <xsl:attribute name="severity">
                                    <xsl:value-of select="-1+2*@priority"/>
                                </xsl:attribute>
                                <xsl:attribute name="probability">0.4</xsl:attribute>
                            </grade>
                        </xsl:when>
                        <xsl:otherwise>
                            <grade>
                                <xsl:attribute name="severity">
                                    <xsl:value-of select="2*@priority"/>
                                </xsl:attribute>
                                <xsl:attribute name="probability">0.3 </xsl:attribute>
                            </grade>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>
                    </xsl:text>
                    <output>
                        <xsl:attribute name="id">5</xsl:attribute>
                        <textoutput>
                            <xsl:value-of select="LongMessage"/>
                        </textoutput>
                        <xsl:for-each select="./*/Message[../@role]">
                            <xsl:text>
                            </xsl:text>
                            <textoutput>
                                <xsl:value-of select="text()"/>
                            </textoutput>
                        </xsl:for-each>
                        <xsl:text>
                    </xsl:text>
                        <htmloutput>
                            <div>
                            <p>
                                <xsl:value-of select="LongMessage"/>
                            </p>
                            <ul>
                                <xsl:for-each select="./*/Message[../@role]">
                                    <xsl:text>
                                </xsl:text>
                                    <li>
                                        <xsl:value-of select="text()"/>
                                    </li>
                                </xsl:for-each>
                            </ul>
                            </div>
                            <xsl:text>
                            </xsl:text>
                        </htmloutput>
                        <xsl:text>
                        </xsl:text>

                        <xmloutput>
                            <xsl:copy-of select="."/>
                        </xmloutput>

                    </output>
                    <xsl:text>
                    </xsl:text>
                    <xsl:if test="UserAnnotation">
                    <evaluation>
                        <xsl:choose>
                            <xsl:when test="UserAnnotation/@designaton = 'MUST_FIX'">  <xsl:attribute name="severity">1</xsl:attribute></xsl:when>
                            <xsl:when test="UserAnnotation/@designaton = 'SHOULD_FIX'">  <xsl:attribute name="severity">2</xsl:attribute></xsl:when>
                            <xsl:when test="UserAnnotation/@designaton = 'MOSTLY_HARMLESS'">  <xsl:attribute name="severity">3</xsl:attribute></xsl:when>
                            <xsl:otherwise> <xsl:attribute name="severity">5</xsl:attribute></xsl:otherwise>
                        </xsl:choose>
                        <comments>
                        <xsl:value-of select="UserAnnotation/text()"/>
                        </comments>
                    </evaluation>
                    </xsl:if>
                </weakness>
            </xsl:for-each>
            <xsl:text>
</xsl:text>
        </report>
    </xsl:template>
</xsl:stylesheet>
