/*
 * $Header: /cvsroot/mvnforum/myvietnam/src/net/myvietnam/mvncore/service/impl/EnvironmentServiceImplDefault.java,v 1.10 2007/10/11 04:45:26 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.10 $
 * $Date: 2007/10/11 04:45:26 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding MyVietnam and MyVietnam CoreLib
 * MUST remain intact in the scripts and source code.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Dung Bui
 */
package net.myvietnam.mvncore.service.impl;

import net.myvietnam.mvncore.service.EnvironmentService;

public class EnvironmentServiceImplDefault implements EnvironmentService {
    
    private boolean isEnterprise;
    private boolean isPortlet;
    private String customizeFor;
    private boolean shouldRun = true;
    private boolean enableMVNForum;
    private boolean enableMVNAd;
    private boolean enableMVNCMS;
    private String reason = "Normal System";
    
    public EnvironmentServiceImplDefault(boolean isEnterprise, boolean isPortlet, String customizeFor, 
                                         boolean enableMVNForum, boolean enableMVNCMS, boolean enableMVNAd) {
        this.isEnterprise = isEnterprise;
        this.isPortlet = isPortlet;
        this.customizeFor = customizeFor;
        this.enableMVNForum = enableMVNForum;
        this.enableMVNCMS = enableMVNCMS;
        this.enableMVNAd = enableMVNAd;
    }

    public boolean isPortlet() {
        return isPortlet;
    }    

    public String customizeFor() {
        return customizeFor;
    }

    public boolean isEnterprise() {
        return isEnterprise;
    }

    /**
     * This method could be use to stop run the forum in some condition.
     * Some use could be a page that immediately stop the forum for security.
     * Other usage is to check to run on some environment such as Servlet 2.3 or later
     *
     * @param shouldRun boolean the new shouldRun
     * @param reason String the reason of the action, this reason will
     *               be shown in the error page
     */
    public void setShouldRun(boolean shouldRun, String reason) {
        this.shouldRun = shouldRun;
        this.reason = reason;
    }
    
    public void setEnableMVNForum(boolean enable) {
        this.enableMVNForum = enable;
    }
    
    public void setEnableMVNCMS(boolean enable) {
        this.enableMVNCMS = enable;
    }

    public boolean isShouldRun() {
        return shouldRun;
    }    
    
    public boolean isMVNForum() {
        return enableMVNForum;
    }
    
    public boolean isMVNCMS() {
        return enableMVNCMS;
    }

    public boolean isMVNAd() {
        return enableMVNAd;
    }

    public String getReason() {
        return reason;
    }

    public void overloadEnvironment() {
    }

}
