/*
 * $Header: /cvsroot/mvnforum/myvietnam/src/net/myvietnam/mvncore/security/SecurityUtil.java,v 1.3 2007/04/09 10:30:21 phuongpdd Exp $
 * $Author: phuongpdd $
 * $Revision: 1.3 $
 * $Date: 2007/04/09 10:30:21 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding MyVietnam and MyVietnam CoreLib
 * MUST remain intact in the scripts and source code.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Dung Bui  
 */

package net.myvietnam.mvncore.security;

import javax.servlet.http.HttpServletRequest;

import net.myvietnam.mvncore.web.GenericRequest;

public class SecurityUtil {

    public static void checkHttpPostMethod(HttpServletRequest request) {
        String method = request.getMethod();
        if (method.equalsIgnoreCase("POST") == false) {
            throw new IllegalStateException("You must use POST method");
        }
    }
    
    public static void checkHttpPostMethod(GenericRequest genericRequest) {
        if (genericRequest.isServletRequest()) {
            String method = genericRequest.getMethod();
            if (method.equalsIgnoreCase("POST") == false) {
                throw new IllegalStateException("You must use POST method");
            }
        }
    }
}
