/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/categorytree/CategoryBuilder.java,v 1.5 2007/12/17 09:09:42 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.5 $
 * $Date: 2007/12/17 09:09:42 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong Pham Dinh Duy
 */
package com.mvnforum.categorytree;

import java.util.*;

import net.myvietnam.mvncore.exception.DatabaseException;

import com.mvnforum.db.*;

public abstract class CategoryBuilder extends Observable {

    protected StringBuffer tree;

    protected ForumBean[] forums;
    protected CategoryBean[] categories;

    protected String ID;

    protected int depth;

    protected CategoryTreeListener listener;

    protected CategoryBean root;
    protected int rootID = -1;

    public CategoryBuilder() throws DatabaseException {
        tree = new StringBuffer();
        forums = (ForumBean[]) ForumCache.getInstance().getBeans().toArray(new ForumBean[0]);
        categories = (CategoryBean[]) CategoryCache.getInstance().getBeans().toArray(new CategoryBean[0]);
        calculate();
    }

    public void setListener(CategoryTreeListener listener) {
        this.listener = listener;
    }

    public void setRoot(CategoryBean root) {
        this.root = root;
        this.rootID = root.getCategoryID();
    }

    protected static boolean isParent(CategoryBean child, int categoryId) {
        return (child.getParentCategoryID() == categoryId);
    }

    public CategoryBean getParentById(CategoryBean child) {
        for (int i = 0; i < categories.length; i++ ) {
            CategoryBean category = categories[i];
            if (isParent(child, category.getCategoryID())) {
                return category;
            }
        }
        return null;
    }

    protected void calculate() {
        for (int i = 0; i < categories.length; i++) {
            int level = 1;
            CategoryBean category = categories[i];
            while(true) {
                category = getParentById(category);
                if (category == null) {
                    break;
                }
                level++;
            }
            if (level > depth) {
                depth = level;
            }
        }
    }

    public Collection getChildrenByCategoryId(int parentId) {
        ArrayList children  = new ArrayList();
        for (int i = 0; i < categories.length; i++ ) {
            CategoryBean child = categories[i];
            if (isParent(child, parentId)) {
                children.add(child);
            }
        }
        return children;
    }

    public Collection getForumsByCategoryId(int categoryId) {
        ArrayList children  = new ArrayList();
        for (int i = 0; i < forums.length; i++) {
            ForumBean forum = forums[i];
            if (belongsTo(forum, categoryId)) {
                children.add(forum);
            }
        }
        return children;
    }

    private static boolean belongsTo(ForumBean child, int categoryId) {
        return (child.getCategoryID() == categoryId);
    }

    public String getID() {
        if (ID != null) {
            return this.ID;
        }
        return "";
    }

    public Collection getTopCategories() {
        final int TOP_LEVEL = 0;
        return getChildrenByCategoryId(TOP_LEVEL);
    }

    public void drawHeader() {
        CategoryTreeEvent event = new CategoryTreeEvent("default");
        event.setDepth(this.depth);
        event.setLevel(0);
        event.setIdsPath("1");
        tree.append(listener.drawHeader(event));
    }

    public abstract void drawBody();

    public void drawFooter() {
        CategoryTreeEvent event = new CategoryTreeEvent("default");
        event.setDepth(this.depth);
        event.setLevel(0);
        event.setIdsPath("1");
        tree.append(listener.drawFooter(event));
    }

    //return category tree
    public String getTree() {
        listener.commitTemplate(tree);
        return tree.toString();
    }

}
