/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/admin/ConfigurationWebHandler.java,v 1.107 2008/01/29 08:09:17 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.107 $
 * $Date: 2008/01/29 08:09:17 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Minh Nguyen
 * @author: Mai  Nguyen
 */
package com.mvnforum.admin;

import java.io.*;
import java.util.*;

import net.myvietnam.mvncore.MVNCoreConfig;
import net.myvietnam.mvncore.configuration.DOM4JConfiguration;
import net.myvietnam.mvncore.exception.BadInputException;
import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.security.SecurityUtil;
import net.myvietnam.mvncore.service.EnvironmentService;
import net.myvietnam.mvncore.service.MvnCoreServiceFactory;
import net.myvietnam.mvncore.util.*;
import net.myvietnam.mvncore.web.GenericRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.*;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

import com.mvnforum.*;
import com.mvnforum.auth.*;
import com.mvnforum.db.*;

import freemarker.template.*;

public class ConfigurationWebHandler {

    private static Log log = LogFactory.getLog(ConfigurationWebHandler.class);

    private OnlineUserManager onlineUserManager = OnlineUserManager.getInstance();

    public ConfigurationWebHandler() {
    }

    public void prepareConfigMVNForum(GenericRequest request)
        throws IOException, DatabaseException, AuthenticationException {
        
        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        String strPathName = FileUtil.getServletClassesPath();
        DOM4JConfiguration mvnforumConfig;
        try {
            mvnforumConfig = new DOM4JConfiguration(new File(strPathName + "mvnforum.xml"));
        } catch (Exception ex) {
            log.error("Cannot load the DOM4JConfiguration.", ex);
            throw new IOException("Cannot load the DOM4JConfiguration.");
        }

        request.setAttribute("mvnforumConfig", mvnforumConfig);
    }

    public void prepareConfigMVNCore(GenericRequest request)
        throws IOException, DatabaseException, AuthenticationException {

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        String strPathName = FileUtil.getServletClassesPath();
        DOM4JConfiguration mvncoreConfig;
        try {
            mvncoreConfig = new DOM4JConfiguration(new File(strPathName + "mvncore.xml"));
        } catch (Exception ex) {
            log.error("Cannot load the DOM4JConfiguration.", ex);
            throw new IOException("Cannot load the DOM4JConfiguration.");
        }

        request.setAttribute("mvncoreConfig", mvncoreConfig);
    }

    public void updateConfigStepOne(GenericRequest request)
        throws BadInputException, DocumentException, IOException,
        DatabaseException, AuthenticationException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        // Children of mvnforumConfig
        String mvnforum_home = GenericParamUtil.getParameterSafe(request, "mvnforum_home", true);
        String mvnforum_log = GenericParamUtil.getParameterSafe(request, "mvnforum_log", true);
        String webmaster_email = GenericParamUtil.getParameterEmail(request, "webmaster_email");
        String watch_email = GenericParamUtil.getParameterEmail(request, "watch_email");
        String logo_url = GenericParamUtil.getParameterSafe(request, "logo_url", true);
        String redirect_login_url = GenericParamUtil.getParameterSafe(request, "redirect_login_url", true);
        String redirect_logout_url = GenericParamUtil.getParameterSafe(request, "redirect_logout_url", true);
        String supported_locales = GenericParamUtil.getParameterSafe(request, "supported_locales", false);
        String default_locale_name = GenericParamUtil.getParameterSafe(request, "default_locale_name", true);
        String locale_parameter_name = GenericParamUtil.getParameterSafe(request, "locale_parameter_name", true);
        String default_guest_name = GenericParamUtil.getParameterSafe(request, "default_guest_name", true);
        int default_guest_timezone = GenericParamUtil.getParameterInt(request, "default_guest_timezone");
        int default_status_of_registered_member = GenericParamUtil.getParameterInt(request, "default_status_of_registered_member");
        boolean enable_register_rule = GenericParamUtil.getParameterBoolean(request, "enable_register_rule");

        boolean enable_cache_member = GenericParamUtil.getParameterBoolean(request, "enable_cache_member");
        boolean enable_cache_post = GenericParamUtil.getParameterBoolean(request, "enable_cache_post");
        boolean enable_cache_thread = GenericParamUtil.getParameterBoolean(request, "enable_cache_thread");
        boolean enable_cache_forum = GenericParamUtil.getParameterBoolean(request, "enable_cache_forum");
        boolean enable_cache_category = GenericParamUtil.getParameterBoolean(request, "enable_cache_category");

        boolean enable_passwordless_auth = GenericParamUtil.getParameterBoolean(request, "enable_passwordless_auth");
        boolean enable_login_info_in_cookie = GenericParamUtil.getParameterBoolean(request, "enable_login_info_in_cookie");
        boolean enable_login_info_in_session = GenericParamUtil.getParameterBoolean(request, "enable_login_info_in_session");
        boolean enable_login_info_in_realm = GenericParamUtil.getParameterBoolean(request, "enable_login_info_in_realm");
        boolean enable_login_info_in_customization = GenericParamUtil.getParameterBoolean(request, "enable_login_info_in_customization");
        boolean enable_check_invalid_session = GenericParamUtil.getParameterBoolean(request, "enable_check_invalid_session");        
        boolean require_activation = GenericParamUtil.getParameterBoolean(request, "require_activation");
        boolean enable_login = GenericParamUtil.getParameterBoolean(request, "enable_login");
        boolean enable_new_member = GenericParamUtil.getParameterBoolean(request, "enable_new_member");
        boolean enable_new_post = GenericParamUtil.getParameterBoolean(request, "enable_new_post");
        boolean enable_rss = GenericParamUtil.getParameterBoolean(request, "enable_rss");
        boolean enable_watch = GenericParamUtil.getParameterBoolean(request, "enable_watch");
        boolean enable_attachment = GenericParamUtil.getParameterBoolean(request, "enable_attachment");
        boolean enable_avatar = GenericParamUtil.getParameterBoolean(request, "enable_avatar");
        boolean enable_emoticon = GenericParamUtil.getParameterBoolean(request, "enable_emoticon");
        boolean enable_captcha = GenericParamUtil.getParameterBoolean(request, "enable_captcha");
        boolean enable_portal_like_index_page = GenericParamUtil.getParameterBoolean(request, "enable_portal_like_index_page");

        boolean enable_search = GenericParamUtil.getParameterBoolean(request, "enable_search");
        boolean enable_online_users = GenericParamUtil.getParameterBoolean(request, "enable_online_users");
        boolean enable_duplicate_onlineusers = GenericParamUtil.getParameterBoolean(request, "enable_duplicate_onlineusers");
        boolean enable_invisible_users = GenericParamUtil.getParameterBoolean(request, "enable_invisible_users");
        boolean enable_listmembers = GenericParamUtil.getParameterBoolean(request, "enable_listmembers");
        boolean enable_show_last_login_of_current_member = GenericParamUtil.getParameterBoolean(request, "enable_show_last_login_of_current_member");
        boolean enable_show_last_login = GenericParamUtil.getParameterBoolean(request, "enable_show_last_login");
        boolean enable_auto_watching = GenericParamUtil.getParameterBoolean(request, "enable_auto_watching");

        boolean enable_show_birthday = GenericParamUtil.getParameterBoolean(request, "enable_show_birthday");
        boolean enable_show_gender = GenericParamUtil.getParameterBoolean(request, "enable_show_gender");
        boolean enable_show_address = GenericParamUtil.getParameterBoolean(request, "enable_show_address");
        boolean enable_show_city = GenericParamUtil.getParameterBoolean(request, "enable_show_city");
        boolean enable_show_state = GenericParamUtil.getParameterBoolean(request, "enable_show_state");
        boolean enable_show_country = GenericParamUtil.getParameterBoolean(request, "enable_show_country");
        boolean enable_show_phone = GenericParamUtil.getParameterBoolean(request, "enable_show_phone");
        boolean enable_show_mobile = GenericParamUtil.getParameterBoolean(request, "enable_show_mobile");
        boolean enable_show_career = GenericParamUtil.getParameterBoolean(request, "enable_show_career");
        boolean enable_show_homepage = GenericParamUtil.getParameterBoolean(request, "enable_show_homepage");
        boolean enable_show_cool_link_1 = GenericParamUtil.getParameterBoolean(request, "enable_show_cool_link_1");
        boolean enable_show_cool_link_2 = GenericParamUtil.getParameterBoolean(request, "enable_show_cool_link_2");
        boolean enable_show_yahoo = GenericParamUtil.getParameterBoolean(request, "enable_show_yahoo");
        boolean enable_show_aol = GenericParamUtil.getParameterBoolean(request, "enable_show_aol");
        boolean enable_show_icq = GenericParamUtil.getParameterBoolean(request, "enable_show_icq");
        boolean enable_show_msn = GenericParamUtil.getParameterBoolean(request, "enable_show_msn");
        boolean enable_show_join_date = GenericParamUtil.getParameterBoolean(request, "enable_show_join_date");
        boolean enable_show_post_count = GenericParamUtil.getParameterBoolean(request, "enable_show_post_count");
        boolean enable_show_online_status = GenericParamUtil.getParameterBoolean(request, "enable_show_online_status");
        boolean enable_show_lastname = GenericParamUtil.getParameterBoolean(request, "enable_show_lastname");
        boolean enable_show_firstname = GenericParamUtil.getParameterBoolean(request, "enable_show_firstname");
        boolean enable_show_view_count = GenericParamUtil.getParameterBoolean(request, "enable_show_view_count");
        boolean enable_show_email = GenericParamUtil.getParameterBoolean(request, "enable_show_email");

        boolean enable_use_popup_menu_in_viewthread = GenericParamUtil.getParameterBoolean(request, "enable_use_popup_menu_in_viewthread");
        boolean enable_split_thread = GenericParamUtil.getParameterBoolean(request, "enable_split_thread");
        boolean enable_listunansweredthreads = GenericParamUtil.getParameterBoolean(request, "enable_listunansweredthreads");
        boolean enable_list_users_browsing_thread = GenericParamUtil.getParameterBoolean(request, "enable_list_users_browsing_thread");
        boolean enable_email_to_admin_content_with_censored_words = GenericParamUtil.getParameterBoolean(request, "enable_email_to_admin_content_with_censored_words");
        boolean enable_guest_view_listusers = GenericParamUtil.getParameterBoolean(request, "enable_guest_view_listusers");
        boolean only_normal_thread_type_in_active_threads = GenericParamUtil.getParameterBoolean(request, "only_normal_thread_type_in_active_threads");
        boolean send_watchmail_as_html = GenericParamUtil.getParameterBoolean(request, "send_watchmail_as_html");
        boolean enable_easy_watching = GenericParamUtil.getParameterBoolean(request, "enable_easy_watching");
        boolean enable_send_watch_mail_of_my_own_post = GenericParamUtil.getParameterBoolean(request, "enable_send_watch_mail_of_my_own_post");
        
        boolean enable_private_message = GenericParamUtil.getParameterBoolean(request, "enable_private_message");
        boolean enable_public_message = GenericParamUtil.getParameterBoolean(request, "enable_public_message");
        boolean enable_message_attachment = GenericParamUtil.getParameterBoolean(request, "enable_message_attachment");
        boolean enable_most_active_threads = GenericParamUtil.getParameterBoolean(request, "enable_most_active_threads");
        boolean enable_most_active_members = GenericParamUtil.getParameterBoolean(request, "enable_most_active_members");
        boolean enable_site_statistics_overview = GenericParamUtil.getParameterBoolean(request, "enable_site_statistics_overview");
        boolean enable_admin_can_change_password = GenericParamUtil.getParameterBoolean(request, "enable_admin_can_change_password");
        boolean enable_guest_view_image_attachment = GenericParamUtil.getParameterBoolean(request, "enable_guest_view_image_attachment");
        boolean enable_expanse_category_tree_by_default = GenericParamUtil.getParameterBoolean(request, "enable_expanse_category_tree_by_default");

        boolean enable_encrypt_password_on_browser = GenericParamUtil.getParameterBoolean(request, "enable_encrypt_password_on_browser");
        boolean enable_external_user_database = GenericParamUtil.getParameterBoolean(request, "enable_external_user_database");
        int days_to_show_recent_members = GenericParamUtil.getParameterInt(request, "days_to_show_recent_members");
        boolean enable_list_new_members_in_recent_days = GenericParamUtil.getParameterBoolean(request, "enable_list_new_members_in_recent_days");
        boolean enable_list_users_browsing_forum = GenericParamUtil.getParameterBoolean(request, "enable_list_users_browsing_forum");
        boolean enable_email_threatening_content = GenericParamUtil.getParameterBoolean(request, "enable_email_threatening_content");
        boolean have_internet = GenericParamUtil.getParameterBoolean(request, "have_internet");
        String event_log_locale = GenericParamUtil.getParameterSafe(request, "event_log_locale", true);
        int default_category_id = GenericParamUtil.getParameterInt(request, "default_category_id");
        int default_watch_type = GenericParamUtil.getParameterInt(request, "default_watch_type");

        int default_watch_option = GenericParamUtil.getParameterInt(request, "default_watch_option");
        int default_moderation_option = GenericParamUtil.getParameterInt(request, "default_moderation_option");
        
        boolean enable_image_thumbnail = GenericParamUtil.getParameterBoolean(request, "enable_image_thumbnail");
        int image_thumbnail_width = 0;
        int image_thumbnail_height = 0;
        if (enable_image_thumbnail) {
            image_thumbnail_width = GenericParamUtil.getParameterInt(request, "image_thumbnail_width");
            image_thumbnail_height = GenericParamUtil.getParameterInt(request, "image_thumbnail_height");
        }
        
        // children of mvnforumfactoryconfig
        String member_implementation = GenericParamUtil.getParameterSafe(request, "member_implementation", true);
        String onlineuser_implementation = GenericParamUtil.getParameterSafe(request, "onlineuser_implementation", true);
        String authenticator_implementation = GenericParamUtil.getParameterSafe(request, "authenticator_implementation", false);
        String requestprocessor_implementation = GenericParamUtil.getParameterSafe(request, "requestprocessor_implementation", true);
        String lucene_analyzer_implementation = GenericParamUtil.getParameterSafe(request, "lucene_analyzer_implementation", true);
        String mvnforum_service_implementation = GenericParamUtil.getParameterSafe(request, "mvnforum_service_implementation", true);
        String mvn_auth_service_implementation = GenericParamUtil.getParameterSafe(request, "mvn_auth_service_implementation", true);

        WatchBean.validateWatchOption(default_watch_option);
        ForumBean.validateForumModerationMode(default_moderation_option);
        MemberBean.validateMemberStatus(default_status_of_registered_member);
        WatchBean.validateWatchType(default_watch_type);
        
        // Now checking the validity of value
        Locale locale = onlineUser.getLocale();

        try {
            // Create a directory if it does not exist
            FileUtil.createDirs(mvnforum_home, true);

            String tempFilename = mvnforum_home + File.separatorChar + "mvnforum_tempfile.tmp";
            File tempFile = new File(tempFilename);
            if (log.isDebugEnabled()) {
                log.debug("Temp file = " + tempFilename);
                log.debug("Absolute filename of temp file = " + tempFile.getAbsolutePath());
            }

            FileOutputStream fos = new FileOutputStream(tempFilename);
            fos.write(tempFilename.getBytes());
            fos.close();

            tempFile.delete();
        } catch (IOException ex) {
            String errorMessage = "Check your mvnforum_home. Detail : " + ex.getMessage();
            throw new BadInputException(errorMessage);
        }

        try {
            int lastBackSlashIndex = mvnforum_log.lastIndexOf('\\');
            int lastForwardSlashIndex = mvnforum_log.lastIndexOf('/');
            int index = Math.max(lastBackSlashIndex, lastForwardSlashIndex);
            if (index < 0) {
                throw new BadInputException("Cannot find any '\\' or '/' in mvnforum_log : " + mvnforum_log);
            }
            String parentFolder = mvnforum_log.substring(0, index);
            log.debug("parentFolder = " + parentFolder);

            // always create a dir, if the dir already exitsted, nothing happens
            FileUtil.createDirs(parentFolder, true);

            String tempFilename = parentFolder + File.separatorChar + "mvnforum_tempfile.tmp";
            File tempFile = new File(tempFilename);
            if (log.isDebugEnabled()) {
                log.debug("Temp file in log folder = " + tempFilename);
                log.debug("Absolute filename of temp file in log folder = " + tempFile.getAbsolutePath());
            }

            FileOutputStream fos = new FileOutputStream(tempFilename);
            fos.write(tempFilename.getBytes());
            fos.close();

            tempFile.delete();
        } catch (IOException ex) {
            String errorMessage = "Check your mvnforum_log. Detail : " + ex.getMessage();
            throw new BadInputException(errorMessage);
        }

        MyUtil.checkClassName(locale, member_implementation, true);
        MyUtil.checkClassName(locale, onlineuser_implementation, true);
        MyUtil.checkClassName(locale, authenticator_implementation, false);
        MyUtil.checkClassName(locale, requestprocessor_implementation, true);
        MyUtil.checkClassName(locale, lucene_analyzer_implementation, true);
        MyUtil.checkClassName(locale, mvnforum_service_implementation, true);
        MyUtil.checkClassName(locale, mvn_auth_service_implementation, true);


        // End checking, now save the value
        String strPathName = FileUtil.getServletClassesPath();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(strPathName + "mvnforum.xml"));

        Element root = document.getRootElement();

        // Iterate through child elements of root
        for (Iterator i = root.elementIterator(); i.hasNext(); ) {
            Element element = (Element) i.next();
            for (int j = 0, size = element.nodeCount(); j < size; j++) {
                Node node = element.node(j);
                if (node.getNodeTypeName().equals("Element")) {
                    if (node.getName().equals("mvnforum_home")) {
                        node.setText(mvnforum_home);
                    } else if (node.getName().equals("mvnforum_log")) {
                        node.setText(mvnforum_log);
                    } else if (node.getName().equals("webmaster_email")) {
                        node.setText(webmaster_email);
                    } else if (node.getName().equals("watch_email")) {
                        node.setText(watch_email);
                    } else if (node.getName().equals("logo_url")) {
                        node.setText(logo_url);
                    } else if (node.getName().equals("redirect_login_url")) {
                        node.setText(redirect_login_url);
                    } else if (node.getName().equals("redirect_logout_url")) {
                        node.setText(redirect_logout_url);
                    } else if (node.getName().equals("supported_locales")) {
                        node.setText(supported_locales);
                    } else if (node.getName().equals("default_locale_name")) {
                        node.setText(default_locale_name);
                    } else if (node.getName().equals("locale_parameter_name")) {
                        node.setText(locale_parameter_name);
                    } else if (node.getName().equals("default_guest_name")) {
                        node.setText(default_guest_name);
                    } else if (node.getName().equals("default_guest_timezone")) {
                        node.setText(String.valueOf(default_guest_timezone));

                    } else if (node.getName().equals("enable_cache_member")) {
                        node.setText(String.valueOf(enable_cache_member));
                    } else if (node.getName().equals("enable_cache_post")) {
                        node.setText(String.valueOf(enable_cache_post));
                    } else if (node.getName().equals("enable_cache_thread")) {
                        node.setText(String.valueOf(enable_cache_thread));
                    } else if (node.getName().equals("enable_cache_forum")) {
                        node.setText(String.valueOf(enable_cache_forum));
                    } else if (node.getName().equals("enable_cache_category")) {
                        node.setText(String.valueOf(enable_cache_category));

                    } else if (node.getName().equals("enable_passwordless_auth")) {
                        node.setText(String.valueOf(enable_passwordless_auth));
                    } else if (node.getName().equals("enable_login_info_in_cookie")) {
                        node.setText(String.valueOf(enable_login_info_in_cookie));
                    } else if (node.getName().equals("enable_login_info_in_session")) {
                        node.setText(String.valueOf(enable_login_info_in_session));
                    } else if (node.getName().equals("enable_login_info_in_realm")) {
                        node.setText(String.valueOf(enable_login_info_in_realm));
                    } else if (node.getName().equals("enable_login_info_in_customization")) {
                        node.setText(String.valueOf(enable_login_info_in_customization));
                    } else if (node.getName().equals("enable_check_invalid_session")) {
                        node.setText(String.valueOf(enable_check_invalid_session));
                    } else if (node.getName().equals("require_activation")) {
                        node.setText(String.valueOf(require_activation));
                    } else if (node.getName().equals("enable_login")) {
                        node.setText(String.valueOf(enable_login));
                    } else if (node.getName().equals("enable_new_member")) {
                        node.setText(String.valueOf(enable_new_member));
                    } else if (node.getName().equals("enable_new_post")) {
                        node.setText(String.valueOf(enable_new_post));
                    } else if (node.getName().equals("enable_rss")) {
                        node.setText(String.valueOf(enable_rss));
                    } else if (node.getName().equals("enable_watch")) {
                        node.setText(String.valueOf(enable_watch));
                    } else if (node.getName().equals("enable_attachment")) {
                        node.setText(String.valueOf(enable_attachment));
                    } else if (node.getName().equals("enable_avatar")) {
                        node.setText(String.valueOf(enable_avatar));
                    } else if (node.getName().equals("enable_emoticon")) {
                        node.setText(String.valueOf(enable_emoticon));
                    } else if (node.getName().equals("enable_captcha")) {
                        node.setText(String.valueOf(enable_captcha));
                    } else if (node.getName().equals("enable_portal_like_index_page")) {
                        node.setText(String.valueOf(enable_portal_like_index_page));

                    } else if (node.getName().equals("enable_search")) {
                        node.setText(String.valueOf(enable_search));
                    } else if (node.getName().equals("enable_online_users")) {
                        node.setText(String.valueOf(enable_online_users));
                    } else if (node.getName().equals("enable_duplicate_onlineusers")) {
                        node.setText(String.valueOf(enable_duplicate_onlineusers));
                    } else if (node.getName().equals("enable_invisible_users")) {
                        node.setText(String.valueOf(enable_invisible_users));
                    } else if (node.getName().equals("enable_listmembers")) {
                        node.setText(String.valueOf(enable_listmembers));
                    } else if (node.getName().equals("enable_show_last_login_of_current_member")) {
                        node.setText(String.valueOf(enable_show_last_login_of_current_member));
                    } else if (node.getName().equals("enable_show_last_login")) {
                        node.setText(String.valueOf(enable_show_last_login));
                    } else if (node.getName().equals("enable_auto_watching")) {
                        node.setText(String.valueOf(enable_auto_watching));
                    } else if (node.getName().equals("enable_show_birthday")) {
                        node.setText(String.valueOf(enable_show_birthday));
                    } else if (node.getName().equals("enable_show_gender")) {
                        node.setText(String.valueOf(enable_show_gender));
                    } else if (node.getName().equals("enable_show_address")) {
                        node.setText(String.valueOf(enable_show_address));
                    } else if (node.getName().equals("enable_show_city")) {
                        node.setText(String.valueOf(enable_show_city));
                    } else if (node.getName().equals("enable_show_state")) {
                        node.setText(String.valueOf(enable_show_state));
                    } else if (node.getName().equals("enable_show_country")) {
                        node.setText(String.valueOf(enable_show_country));
                    } else if (node.getName().equals("enable_show_phone")) {
                        node.setText(String.valueOf(enable_show_phone));
                    } else if (node.getName().equals("enable_show_mobile")) {
                        node.setText(String.valueOf(enable_show_mobile));
                    } else if (node.getName().equals("enable_show_career")) {
                        node.setText(String.valueOf(enable_show_career));
                    } else if (node.getName().equals("enable_show_homepage")) {
                        node.setText(String.valueOf(enable_show_homepage));
                    } else if (node.getName().equals("enable_show_cool_link_1")) {
                        node.setText(String.valueOf(enable_show_cool_link_1));
                    } else if (node.getName().equals("enable_show_cool_link_2")) {
                        node.setText(String.valueOf(enable_show_cool_link_2));
                    } else if (node.getName().equals("enable_show_yahoo")) {
                        node.setText(String.valueOf(enable_show_yahoo));
                    } else if (node.getName().equals("enable_show_aol")) {
                        node.setText(String.valueOf(enable_show_aol));
                    } else if (node.getName().equals(" enable_show_msn")) {
                        node.setText(String.valueOf(enable_show_msn));
                    } else if (node.getName().equals("enable_show_icq")) {
                        node.setText(String.valueOf(enable_show_icq));
                    } else if (node.getName().equals("enable_show_join_date")) {
                        node.setText(String.valueOf(enable_show_join_date));
                    } else if (node.getName().equals("enable_show_post_count")) {
                        node.setText(String.valueOf(enable_show_post_count));
                    } else if (node.getName().equals("enable_show_online_status")) {
                        node.setText(String.valueOf(enable_show_online_status));
                    } else if (node.getName().equals("enable_show_lastname")) {
                        node.setText(String.valueOf(enable_show_lastname));
                    } else if (node.getName().equals("enable_show_firstname")) {
                        node.setText(String.valueOf(enable_show_firstname));
                    } else if (node.getName().equals("enable_show_view_count")) {
                        node.setText(String.valueOf(enable_show_view_count));
                    } else if (node.getName().equals("enable_show_email")) {
                        node.setText(String.valueOf(enable_show_email));
                    } else if (node.getName().equals("enable_use_popup_menu_in_viewthread")) {
                        node.setText(String.valueOf(enable_use_popup_menu_in_viewthread));
                    } else if (node.getName().equals("enable_split_thread")) {
                        node.setText(String.valueOf(enable_split_thread));
                    } else if (node.getName().equals("enable_listunansweredthreads")) {
                        node.setText(String.valueOf(enable_listunansweredthreads));
                    } else if (node.getName().equals("enable_list_users_browsing_thread")) {
                        node.setText(String.valueOf(enable_list_users_browsing_thread));
                    } else if (node.getName().equals("enable_email_to_admin_content_with_censored_words")) {
                        node.setText(String.valueOf(enable_email_to_admin_content_with_censored_words));
                    } else if (node.getName().equals("enable_guest_view_listusers")) {
                        node.setText(String.valueOf(enable_guest_view_listusers));
                    } else if (node.getName().equals("only_normal_thread_type_in_active_threads")) {
                        node.setText(String.valueOf(only_normal_thread_type_in_active_threads));
                    } else if (node.getName().equals("send_watchmail_as_html")) {
                        node.setText(String.valueOf(send_watchmail_as_html));
                    } else if (node.getName().equals("enable_easy_watching")) {
                        node.setText(String.valueOf(enable_easy_watching));
                    } else if (node.getName().equals("enable_send_watch_mail_of_my_own_post")) {
                        node.setText(String.valueOf(enable_send_watch_mail_of_my_own_post));
                    } else if (node.getName().equals("enable_private_message")) {
                        node.setText(String.valueOf(enable_private_message));
                    } else if (node.getName().equals("enable_public_message")) {
                        node.setText(String.valueOf(enable_public_message));
                    } else if (node.getName().equals("enable_message_attachment")) {
                        node.setText(String.valueOf(enable_message_attachment));
                    } else if (node.getName().equals("enable_most_active_threads")) {
                        node.setText(String.valueOf(enable_most_active_threads));
                    } else if (node.getName().equals("enable_most_active_members")) {
                        node.setText(String.valueOf(enable_most_active_members));
                    } else if (node.getName().equals("enable_site_statistics_overview")) {
                        node.setText(String.valueOf(enable_site_statistics_overview));
                    } else if (node.getName().equals("enable_admin_can_change_password")) {
                        node.setText(String.valueOf(enable_admin_can_change_password));
                    } else if (node.getName().equals("enable_guest_view_image_attachment")) {
                        node.setText(String.valueOf(enable_guest_view_image_attachment));
                    } else if (node.getName().equals("enable_expanse_category_tree_by_default")) {
                        node.setText(String.valueOf(enable_expanse_category_tree_by_default));
                    } else if (node.getName().equals("default_watch_option")) {
                        node.setText(String.valueOf(default_watch_option));
                    } else if (node.getName().equals("default_moderation_option")) {
                        node.setText(String.valueOf(default_moderation_option));
                    } else if (node.getName().equals("enable_encrypt_password_on_browser")) {
                        node.setText(String.valueOf(enable_encrypt_password_on_browser));
                    } else if (node.getName().equals("enable_external_user_database")) {
                        node.setText(String.valueOf(enable_external_user_database));
                    } else if (node.getName().equals("days_to_show_recent_members")) {
                        node.setText(String.valueOf(days_to_show_recent_members));
                    } else if (node.getName().equals("enable_list_new_members_in_recent_days")) {
                        node.setText(String.valueOf(enable_list_new_members_in_recent_days));
                    } else if (node.getName().equals("enable_list_users_browsing_forum")) {
                        node.setText(String.valueOf(enable_list_users_browsing_forum));
                    } else if (node.getName().equals("enable_email_threatening_content")) {
                        node.setText(String.valueOf(enable_email_threatening_content));
                    } else if (node.getName().equals("have_internet")) {
                        node.setText(String.valueOf(have_internet));
                    } else if (node.getName().equals("event_log_locale")) {
                        node.setText(String.valueOf(event_log_locale));
                    } else if (node.getName().equals("default_category_id")) {
                        node.setText(String.valueOf(default_category_id));
                    } else if (node.getName().equals("default_watch_type")) {
                        node.setText(String.valueOf(default_watch_type));
                    } else if (node.getName().equals("default_status_of_registered_member")) {
                        node.setText(String.valueOf(default_status_of_registered_member));
                    } else if (node.getName().equals("enable_register_rule")) {
                        node.setText(String.valueOf(enable_register_rule));
                        
                    //  children of image_thumbnail
                    } else if (node.getName().equals("image_thumbnail")) {
                        Element el = (Element)node;
                        for (int k = 0; k < el.nodeCount(); k++) {

                            Node childNode = el.node(k);
                            if (childNode.getNodeTypeName().equals("Element")) {

                                if (childNode.getName().equals("enable")) {
                                    childNode.setText(String.valueOf(enable_image_thumbnail));
                                } else if (childNode.getName().equals("width")) {
                                    if (enable_image_thumbnail) {
                                        childNode.setText(String.valueOf(image_thumbnail_width));
                                    }
                                } else if (childNode.getName().equals("height")) {
                                    if (enable_image_thumbnail) {
                                        childNode.setText(String.valueOf(image_thumbnail_height));
                                     }
                                }
                            }
                        }
                        
                    // children of mvnforumfactoryconfig
                    } else if (node.getName().equals("member_implementation")) {
                        node.setText(member_implementation);
                    } else if (node.getName().equals("onlineuser_implementation")) {
                        node.setText(onlineuser_implementation);
                    } else if (node.getName().equals("authenticator_implementation")) {
                        node.setText(authenticator_implementation);
                    } else if (node.getName().equals("requestprocessor_implementation")) {
                        node.setText(requestprocessor_implementation);
                    } else if (node.getName().equals("lucene_analyzer_implementation")) {
                        node.setText(lucene_analyzer_implementation);
                    } else if (node.getName().equals("mvnforum_service_implementation")) {
                        node.setText(mvnforum_service_implementation);
                    } else if (node.getName().equals("mvn_auth_service_implementation")) {
                        node.setText(mvn_auth_service_implementation);
                    }
                }
            }
        }

        saveDocument(document, strPathName + "mvnforum.xml");
        MVNForumConfig.reload();
        request.setAttribute("step", "1");
    }

    public void updateConfigStepTwo(GenericRequest request)
        throws BadInputException, DocumentException, IOException,
        DatabaseException, AuthenticationException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        int max_private_message = GenericParamUtil.getParameterUnsignedInt(request, "max_private_message");
        String max_message_attachment_size = GenericParamUtil.getParameterSafe(request, "max_message_attachment_size", true);
        String max_attachment_size = GenericParamUtil.getParameterSafe(request, "max_attachment_size", true);
        int max_favorite_thread = GenericParamUtil.getParameterUnsignedInt(request, "max_favorite_thread");
        int max_edit_days = GenericParamUtil.getParameterUnsignedInt(request, "max_edit_days");
        int max_attach_days = GenericParamUtil.getParameterUnsignedInt(request, "max_attach_days");
        int max_delete_days = GenericParamUtil.getParameterUnsignedInt(request, "max_delete_days");
        int rows_per_page = GenericParamUtil.getParameterUnsignedInt(request, "rows_per_page");
        int rows_per_rss = GenericParamUtil.getParameterUnsignedInt(request, "rows_per_rss");
        int hot_topic_threshold = GenericParamUtil.getParameterUnsignedInt(request, "hot_topic_threshold");

        int max_http_requests_per_hour_per_ip = GenericParamUtil.getParameterUnsignedInt(request, "max_http_requests_per_hour_per_ip");
        int max_posts_per_hour_per_ip = GenericParamUtil.getParameterUnsignedInt(request, "max_posts_per_hour_per_ip");
        int max_members_per_hour_per_ip = GenericParamUtil.getParameterUnsignedInt(request, "max_members_per_hour_per_ip");
        int max_logins_per_hour_per_ip = GenericParamUtil.getParameterUnsignedInt(request, "max_logins_per_hour_per_ip");
        int max_messages_per_hour_per_ip = GenericParamUtil.getParameterUnsignedInt(request, "max_messages_per_hour_per_ip");
        int max_password_days = GenericParamUtil.getParameterUnsignedInt(request, "max_password_days");
        int max_posts_per_hour_per_member = GenericParamUtil.getParameterUnsignedInt(request, "max_posts_per_hour_per_member");
        
        int max_chars_in_short_summary = GenericParamUtil.getParameterUnsignedInt(request, "max_chars_in_short_summary");
        int max_chars_in_long_summary = GenericParamUtil.getParameterUnsignedInt(request, "max_chars_in_long_summary");
        int max_chars_in_rss = GenericParamUtil.getParameterUnsignedInt(request, "max_chars_in_rss");

        boolean enable_backup_on_server = GenericParamUtil.getParameterBoolean(request, "enable_backup_on_server");
        int max_import_size = GenericParamUtil.getParameterUnsignedInt(request, "max_import_size");

        String strPathName = FileUtil.getServletClassesPath();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(strPathName + "mvnforum.xml"));
        Element root = document.getRootElement();

        // iterate through child elements of root
        for (Iterator i = root.elementIterator("mvnforumconfig"); i.hasNext(); ) {
            Element element = (Element) i.next();
            for (int j = 0, size = element.nodeCount(); j < size; j++) {
                Node node = element.node(j);
                if (node.getNodeTypeName().equals("Element")) {
                    if (node.getName().equals("max_private_message")) {
                        node.setText(String.valueOf(max_private_message));
                    } else if (node.getName().equals("max_message_attachment_size")) {
                        node.setText(max_message_attachment_size);
                    } else if (node.getName().equals("max_attachment_size")) {
                        node.setText(max_attachment_size);
                    } else if (node.getName().equals("max_favorite_thread")) {
                        node.setText(String.valueOf(max_favorite_thread));
                    } else if (node.getName().equals("max_edit_days")) {
                        node.setText(String.valueOf(max_edit_days));
                    } else if (node.getName().equals("max_attach_days")) {
                        node.setText(String.valueOf(max_attach_days));
                    } else if (node.getName().equals("max_delete_days")) {
                        node.setText(String.valueOf(max_delete_days));
                    } else if (node.getName().equals("rows_per_page")) {
                        node.setText(String.valueOf(rows_per_page));
                    } else if (node.getName().equals("rows_per_rss")) {
                        node.setText(String.valueOf(rows_per_rss));
                    } else if (node.getName().equals("hot_topic_threshold")) {
                        node.setText(String.valueOf(hot_topic_threshold));

                    } else if (node.getName().equals("max_http_requests_per_hour_per_ip")) {
                        node.setText(String.valueOf(max_http_requests_per_hour_per_ip));
                    } else if (node.getName().equals("max_posts_per_hour_per_ip")) {
                        node.setText(String.valueOf(max_posts_per_hour_per_ip));
                    } else if (node.getName().equals("max_members_per_hour_per_ip")) {
                        node.setText(String.valueOf(max_members_per_hour_per_ip));
                    } else if (node.getName().equals("max_logins_per_hour_per_ip")) {
                        node.setText(String.valueOf(max_logins_per_hour_per_ip));
                    } else if (node.getName().equals("max_messages_per_hour_per_ip")) {
                        node.setText(String.valueOf(max_messages_per_hour_per_ip));
                    } else if (node.getName().equals("max_password_days")) {
                        node.setText(String.valueOf(max_password_days));
                    } else if (node.getName().equals("max_posts_per_hour_per_member")) {
                        node.setText(String.valueOf(max_posts_per_hour_per_member));

                    } else if (node.getName().equals("max_chars_in_short_summary")) {
                        node.setText(String.valueOf(max_chars_in_short_summary));
                    } else if (node.getName().equals("max_chars_in_long_summary")) {
                        node.setText(String.valueOf(max_chars_in_long_summary));
                    } else if (node.getName().equals("max_chars_in_rss")) {
                        node.setText(String.valueOf(max_chars_in_rss));

                    } else if (node.getName().equals("enable_backup_on_server")) {
                        node.setText(String.valueOf(enable_backup_on_server));
                    } else if (node.getName().equals("max_import_size")) {
                        node.setText(String.valueOf(max_import_size));
                    }
                }
            }
        }
        saveDocument(document, strPathName + "mvnforum.xml");
        MVNForumConfig.reload();
        request.setAttribute("step", "2");
    }

    public void updateConfigStepThree(GenericRequest request)
        throws BadInputException, DocumentException, IOException,
        DatabaseException, AuthenticationException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        boolean require_register_firstname = GenericParamUtil.getParameterBoolean(request, "require_register_firstname");
        boolean require_register_lastname = GenericParamUtil.getParameterBoolean(request, "require_register_lastname");
        boolean require_register_gender = GenericParamUtil.getParameterBoolean(request, "require_register_gender");
        boolean require_register_birthday = GenericParamUtil.getParameterBoolean(request, "require_register_birthday");
        boolean require_register_address = GenericParamUtil.getParameterBoolean(request, "require_register_address");
        boolean require_register_city = GenericParamUtil.getParameterBoolean(request, "require_register_city");
        boolean require_register_state = GenericParamUtil.getParameterBoolean(request, "require_register_state");
        boolean require_register_country = GenericParamUtil.getParameterBoolean(request, "require_register_country");
        boolean require_register_phone = GenericParamUtil.getParameterBoolean(request, "require_register_phone");
        boolean require_register_mobile = GenericParamUtil.getParameterBoolean(request, "require_register_mobile");
        boolean require_register_career = GenericParamUtil.getParameterBoolean(request, "require_register_career");
        boolean require_register_homepage = GenericParamUtil.getParameterBoolean(request, "require_register_homepage");
        boolean require_register_yahoo = GenericParamUtil.getParameterBoolean(request, "require_register_yahoo");
        boolean require_register_aol = GenericParamUtil.getParameterBoolean(request, "require_register_aol");
        boolean require_register_icq = GenericParamUtil.getParameterBoolean(request, "require_register_icq");
        boolean require_register_msn = GenericParamUtil.getParameterBoolean(request, "require_register_msn");
        boolean require_register_link_1 = GenericParamUtil.getParameterBoolean(request, "require_register_link_1");
        boolean require_register_link_2 = GenericParamUtil.getParameterBoolean(request, "require_register_link_2");

        String strPathName = FileUtil.getServletClassesPath();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(strPathName + "mvnforum.xml"));

        Element root = document.getRootElement();

        // iterate through child elements of root
        for (Iterator i = root.elementIterator("mvnforumconfig"); i.hasNext(); ) {
            Element element = (Element) i.next();
            for (int j = 0, size = element.nodeCount(); j < size; j++) {
                Node node = element.node(j);
                if (node.getNodeTypeName().equals("Element")) {
                    if (node.getName().equals("require_register_firstname")) {
                        node.setText(String.valueOf(require_register_firstname));
                    } else if (node.getName().equals("require_register_lastname")) {
                        node.setText(String.valueOf(require_register_lastname));
                    } else if (node.getName().equals("require_register_gender")) {
                        node.setText(String.valueOf(require_register_gender));
                    } else if (node.getName().equals("require_register_birthday")) {
                        node.setText(String.valueOf(require_register_birthday));
                    } else if (node.getName().equals("require_register_address")) {
                        node.setText(String.valueOf(require_register_address));
                    } else if (node.getName().equals("require_register_city")) {
                        node.setText(String.valueOf(require_register_city));
                    } else if (node.getName().equals("require_register_state")) {
                        node.setText(String.valueOf(require_register_state));
                    } else if (node.getName().equals("require_register_country")) {
                        node.setText(String.valueOf(require_register_country));
                    } else if (node.getName().equals("require_register_phone")) {
                        node.setText(String.valueOf(require_register_phone));
                    } else if (node.getName().equals("require_register_mobile")) {
                        node.setText(String.valueOf(require_register_mobile));
                    } else if (node.getName().equals("require_register_career")) {
                        node.setText(String.valueOf(require_register_career));
                    } else if (node.getName().equals("require_register_homepage")) {
                        node.setText(String.valueOf(require_register_homepage));
                    } else if (node.getName().equals("require_register_yahoo")) {
                        node.setText(String.valueOf(require_register_yahoo));
                    } else if (node.getName().equals("require_register_aol")) {
                        node.setText(String.valueOf(require_register_aol));
                    } else if (node.getName().equals("require_register_icq")) {
                        node.setText(String.valueOf(require_register_icq));
                    } else if (node.getName().equals("require_register_msn")) {
                        node.setText(String.valueOf(require_register_msn));
                    } else if (node.getName().equals("require_register_link_1")) {
                        node.setText(String.valueOf(require_register_link_1));
                    } else if (node.getName().equals("require_register_link_2")) {
                        node.setText(String.valueOf(require_register_link_2));
                    }
                }
            }
        }
        saveDocument(document, strPathName + "mvnforum.xml");
        MVNForumConfig.reload();
        request.setAttribute("step", "3");
    }

    public void updateConfigMVNCore(GenericRequest request)
        throws BadInputException, DocumentException, IOException,
        DatabaseException, AuthenticationException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        boolean isUseDatasource = GenericParamUtil.getParameterBoolean(request, "use_datasource");

        int database_type = 0;
        String driver_class_name = "";
        String database_url = "";
        String database_user = "";
        String database_password = "";
        int max_connection = 0;
        int max_time_to_wait = 0;
        int minutes_between_refresh = 0;
        String datasource_name = "";

        if (isUseDatasource == false) {
            database_type = GenericParamUtil.getParameterUnsignedInt(request, "database_type");
            driver_class_name = GenericParamUtil.getParameterSafe(request, "driver_class_name", true);
            database_url = GenericParamUtil.getParameterSafe(request, "database_url", true);
            database_user = GenericParamUtil.getParameterSafe(request, "database_user", true);
            database_password = GenericParamUtil.getParameterSafe(request, "database_password", false);
            max_connection = GenericParamUtil.getParameterUnsignedInt(request, "max_connection");
            max_time_to_wait = GenericParamUtil.getParameterUnsignedInt(request, "max_time_to_wait");
            minutes_between_refresh = GenericParamUtil.getParameterUnsignedInt(request, "minutes_between_refresh");
        } else {
            datasource_name = GenericParamUtil.getParameterSafe(request, "datasource_name", false);
        }

        String default_mail_from = GenericParamUtil.getParameterEmail(request, "default_mail_from");

        boolean isReceiveUseMailsource = GenericParamUtil.getParameterBoolean(request, "receive_mail_enable_mail_source");
        boolean isSendUseMailsource = GenericParamUtil.getParameterBoolean(request, "send_mail_enable_mail_source");
        boolean isSendUseSMTPServer = GenericParamUtil.getParameterBoolean(request, "send_mail_use_embeded_smtp_mail_server");

        String receive_mail_source_name = "";
        String receive_mail_server = "";
        String receive_mail_username = "";
        String receive_mail_password = "";
        int receive_mail_port =0;

        String send_mail_source_name = "";
        String send_mail_server = "";
        String send_mail_username = "";
        String send_mail_password = "";
        int send_mail_port = 0;

        if (isReceiveUseMailsource == false) {
            receive_mail_server = GenericParamUtil.getParameterSafe(request, "receive_mail_server", true);
            receive_mail_username = GenericParamUtil.getParameterSafe(request, "receive_mail_username", false);
            receive_mail_password = GenericParamUtil.getParameterSafe(request, "receive_mail_password", false);
            receive_mail_port = GenericParamUtil.getParameterUnsignedInt(request, "receive_mail_port");
        } else {
            receive_mail_source_name = GenericParamUtil.getParameterSafe(request, "receive_mail_source_name", true);
        }
        if (isSendUseSMTPServer) {
            // do nothing
        } else if (isSendUseMailsource) {
            send_mail_source_name = GenericParamUtil.getParameterSafe(request, "send_mail_source_name", true);
        } else {
            send_mail_server = GenericParamUtil.getParameterSafe(request, "send_mail_server", true);
            send_mail_username = GenericParamUtil.getParameterSafe(request, "send_mail_username", false);
            send_mail_password = GenericParamUtil.getParameterSafe(request, "send_mail_password", false);
            send_mail_port = GenericParamUtil.getParameterUnsignedInt(request, "send_mail_port");
        }

        String context_path = GenericParamUtil.getParameterSafe(request, "context_path", false);
        String server_path = GenericParamUtil.getParameterSafe(request, "server_path", true);

        int server_hour_offset = GenericParamUtil.getParameterInt(request, "server_hour_offset");
        if (server_hour_offset < -13 || server_hour_offset > 13) {
            server_hour_offset = 0;
        }

        String blocked_user_agent = GenericParamUtil.getParameterSafe(request, "blocked_user_agent", false);
        String blocked_ip = GenericParamUtil.getParameterSafe(request, "blocked_ip", false);

        boolean enable_link_nofollow = GenericParamUtil.getParameterBoolean(request, "enable_link_nofollow");
        boolean enable_encode_url = GenericParamUtil.getParameterBoolean(request, "enable_encode_url");

        String portal_type = GenericParamUtil.getParameterSafe(request, "portal_type", true);
        String mvncoreservice_implementation = GenericParamUtil.getParameterSafe(request, "mvncoreservice_implementation", true);

        String mailinterceptor_implementation = GenericParamUtil.getParameterSafe(request, "mailinterceptor_implementation", false);
        String contentinterceptor_implementation = GenericParamUtil.getParameterSafe(request, "contentinterceptor_implementation", false);
        String loginidinterceptor_implementation = GenericParamUtil.getParameterSafe(request, "loginidinterceptor_implementation", false);
        String passwordinterceptor_implementation = GenericParamUtil.getParameterSafe(request, "passwordinterceptor_implementation", false);

        // Now checking the validity of value
        Locale locale = onlineUser.getLocale();

        MyUtil.checkClassName(locale, driver_class_name, true);

        MyUtil.checkClassName(locale, mvncoreservice_implementation, true);

        MyUtil.checkClassName(locale, mailinterceptor_implementation, false);
        MyUtil.checkClassName(locale, contentinterceptor_implementation, false);
        MyUtil.checkClassName(locale, loginidinterceptor_implementation, false);
        MyUtil.checkClassName(locale, passwordinterceptor_implementation, false);

        // End checking, now save the value
        String strPathName = FileUtil.getServletClassesPath();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(strPathName + "mvncore.xml"));

        boolean enable_mvnforum = GenericParamUtil.getParameterBoolean(request, "enable_mvnforum");
        boolean enable_mvncms = GenericParamUtil.getParameterBoolean(request, "enable_mvncms");

        Element root = document.getRootElement();
        for (int i = 0; i < root.nodeCount(); i++) {

            Node node = root.node(i);
            if (node.getNodeTypeName().equals("Element")) {
                if (node.getName().equals("plugin_options")) {

                    Element el = (Element)node;
                    for (int j = 0; j < el.nodeCount(); j++) {

                        Node childNode = el.node(j);
                        if (childNode.getNodeTypeName().equals("Element")) {

                            if (childNode.getName().equals("enable_mvnforum")) {
                                childNode.setText(String.valueOf(enable_mvnforum));
                            } else if (childNode.getName().equals("enable_mvncms")) {
                                childNode.setText(String.valueOf(enable_mvncms));
                            }
                        }
                    }
                } else if (node.getName().equals("dboptions")) {

                    Element el = (Element)node;
                    for (int j = 0; j < el.nodeCount(); j++) {

                        Node childNode = el.node(j);
                        if (childNode.getNodeTypeName().equals("Element")) {
                            if (childNode.getName().equals("database_type")) {
                                childNode.setText(String.valueOf(database_type));
                            } else if (childNode.getName().equals("use_datasource")) {
                                childNode.setText(String.valueOf(isUseDatasource));
                            } else if (childNode.getName().equals("driver_class_name")) {
                                if (isUseDatasource == false) {
                                    childNode.setText(driver_class_name);
                                }
                            } else if (childNode.getName().equals("database_url")) {
                                if (isUseDatasource == false) {
                                    childNode.setText(database_url);
                                }
                            } else if (childNode.getName().equals("database_user")) {
                                if (isUseDatasource == false) {
                                    childNode.setText(database_user);
                                }
                            } else if (childNode.getName().equals("database_password")) {
                                if (isUseDatasource == false) {
                                    childNode.setText(database_password);
                                }
                            } else if (childNode.getName().equals("max_connection")) {
                                if (isUseDatasource == false) {
                                childNode.setText(String.valueOf(max_connection));
                                }
                            } else if (childNode.getName().equals("max_time_to_wait")) {
                                if (isUseDatasource == false) {
                                    childNode.setText(String.valueOf(max_time_to_wait));
                                }
                            } else if (childNode.getName().equals("minutes_between_refresh")) {
                                if (isUseDatasource == false) {
                                childNode.setText(String.valueOf(minutes_between_refresh));
                                }
                            } else if (childNode.getName().equals("datasource_name")) {
                                if (isUseDatasource) {
                                    childNode.setText(datasource_name);
                                }
                            }
                        }
                    }
                } else if (node.getName().equals("mailoptions")) {

                    Element el = (Element)node;
                    for (int j = 0; j < el.nodeCount(); j++) {

                        Node childNode = el.node(j);
                        if (childNode.getNodeTypeName().equals("Element")) {
                            if (childNode.getName().equals("default_mail_from")) {
                                childNode.setText(String.valueOf(default_mail_from));
                            } else if (childNode.getName().equals("receive_mail")) {

                                Element subEl = (Element)childNode;
                                for (int k = 0; k < subEl.nodeCount(); k++) {

                                    Node grandChildNode = subEl.node(k);
                                    if (grandChildNode.getNodeTypeName().equals("Element")) {
                                        if (grandChildNode.getName().equals("enable_mail_source")) {
                                            grandChildNode.setText(String.valueOf(isReceiveUseMailsource));
                                        } else if (grandChildNode.getName().equals("mail_server")) {
                                            if (isReceiveUseMailsource == false) {
                                                grandChildNode.setText(receive_mail_server);
                                            }
                                        } else if (grandChildNode.getName().equals("username")) {
                                            if (isReceiveUseMailsource == false) {
                                                grandChildNode.setText(receive_mail_username);
                                            }
                                        } else if (grandChildNode.getName().equals("password")) {
                                            if (isReceiveUseMailsource == false) {
                                                grandChildNode.setText(receive_mail_password);
                                            }
                                        } else if (grandChildNode.getName().equals("port")) {
                                            if (isReceiveUseMailsource == false) {
                                                grandChildNode.setText(String.valueOf(receive_mail_port));
                                            }
                                        } else if (grandChildNode.getName().equals("mail_source_name")) {
                                            if (isReceiveUseMailsource) {
                                                grandChildNode.setText(String.valueOf(receive_mail_source_name));
                                            }
                                        }
                                    }
                                }
                            } else if (childNode.getName().equals("send_mail")) {

                                Element subEl = (Element)childNode;
                                for (int k = 0; k < subEl.nodeCount(); k++) {

                                    Node grandChildNode = subEl.node(k);
                                    if (grandChildNode.getNodeTypeName().equals("Element")) {
                                        if (isSendUseSMTPServer) {
                                            if (grandChildNode.getName().equals("use_embeded_smtp_mail_server")) {
                                                grandChildNode.setText(String.valueOf(isSendUseSMTPServer));
                                            }
                                        } else {
                                            if (grandChildNode.getName().equals("use_embeded_smtp_mail_server")) {
                                                grandChildNode.setText(String.valueOf(isSendUseSMTPServer));
                                            } else if (grandChildNode.getName().equals("enable_mail_source")) {
                                                grandChildNode.setText(String.valueOf(isSendUseMailsource));
                                            } else if (grandChildNode.getName().equals("mail_server")) {
                                                if (isSendUseMailsource == false) {
                                                    grandChildNode.setText(send_mail_server);
                                                }
                                            } else if (grandChildNode.getName().equals("username")) {
                                                if (isSendUseMailsource == false) {
                                                    grandChildNode.setText(send_mail_username);
                                                }
                                            } else if (grandChildNode.getName().equals("password")) {
                                                if (isSendUseMailsource == false) {
                                                    grandChildNode.setText(send_mail_password);
                                                }
                                            } else if (grandChildNode.getName().equals("port")) {
                                                if (isSendUseMailsource == false) {
                                                    grandChildNode.setText(String.valueOf(send_mail_port));
                                                }
                                            } else if (grandChildNode.getName().equals("mail_source_name")) {
                                                if (isSendUseMailsource) {
                                                    grandChildNode.setText(String.valueOf(send_mail_source_name));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    //end mailoptions
                } else if (node.getName().equals("paramoptions")) {

                    Element el = (Element)node;
                    for (int j = 0; j < el.nodeCount(); j++) {

                        Node childNode = el.node(j);
                        if (childNode.getNodeTypeName().equals("Element")) {

                            if (childNode.getName().equals("context_path")) {
                                childNode.setText(context_path);
                            } else if (childNode.getName().equals("server_path")) {
                                childNode.setText(server_path);
                            }
                        }
                    }
                } else if (node.getName().equals("dateoptions")) {
                    Element el = ((Element)node).element("server_hour_offset");
                    el.setText(String.valueOf(server_hour_offset));
                } else if (node.getName().equals("useragentoptions")) {
                    Element el = ((Element)node).element("blocked_user_agent");
                    el.setText(String.valueOf(blocked_user_agent));
                } else if (node.getName().equals("ipoptions")) {
                    Element el = ((Element)node).element("blocked_ip");
                    el.setText(String.valueOf(blocked_ip));
                } else if (node.getName().equals("mvncoreconfig")) {

                    Element el = (Element)node;
                    for (int j = 0; j < el.nodeCount(); j++) {

                        Node childNode = el.node(j);
                        if (childNode.getNodeTypeName().equals("Element")) {

                            if (childNode.getName().equals("enable_link_nofollow")) {
                                childNode.setText(String.valueOf(enable_link_nofollow));
                            } else if (childNode.getName().equals("enable_encode_url")) {
                                childNode.setText(String.valueOf(enable_encode_url));
                            } else if (childNode.getName().equals("portal_type")) {
                                childNode.setText(portal_type);
                            } else if (childNode.getName().equals("mvncoreservice_implementation")) {
                                childNode.setText(mvncoreservice_implementation);
                            }
                        }
                    }
                } else if (node.getName().equals("interceptor")) {

                    Element el = (Element)node;
                    for (int j = 0; j < el.nodeCount(); j++) {

                        Node childNode = el.node(j);
                        if (childNode.getNodeTypeName().equals("Element")) {

                            if (childNode.getName().equals("mailinterceptor_implementation")) {
                                childNode.setText(mailinterceptor_implementation);
                            } else if (childNode.getName().equals("contentinterceptor_implementation")) {
                                childNode.setText(contentinterceptor_implementation);
                            } else if (childNode.getName().equals("loginidinterceptor_implementation")) {
                                childNode.setText(loginidinterceptor_implementation);
                            } else if (childNode.getName().equals("passwordinterceptor_implementation")) {
                                childNode.setText(passwordinterceptor_implementation);
                            }
                        }
                    }
                }
            }
        }

        saveDocument(document, strPathName + "mvncore.xml");
        MVNCoreConfig.reload();
        request.setAttribute("action", "updatemvncore");
    }

    public void updateUrlPattern(GenericRequest request)
        throws BadInputException, DocumentException, IOException,
        AuthenticationException, DatabaseException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        String admin_url = GenericParamUtil.getParameterSafe(request, "admin_url", true);
        String user_url = GenericParamUtil.getParameterSafe(request, "user_url", true);

        String strPathName = FileUtil.getServletClassesPath();
        SAXReader reader = new SAXReader();
        String xmlFilePath = strPathName + "mvnforum.xml";
        Document document = reader.read(new File(xmlFilePath));

        Element root = document.getRootElement();
        for (int i = 0; i < root.nodeCount(); i++) {
            Node node = root.node(i);
            //log.debug("Node " + i + " = " + node.getName());
            if (node.getNodeTypeName().equals("Element")) {
                if (node.getName().equals("adminmoduleconfig")) {
                    Node subElement = ((Element) node).element("url_pattern");
                    //log.debug("sub element " + subElement);
                    subElement.setText(admin_url);
                } else if (node.getName().equals("usermoduleconfig")) {
                    Node subElement = ((Element) node).element("url_pattern");
                    //log.debug("sub element " + subElement);
                    subElement.setText(user_url);
                }
            }
        }

        saveDocument(document, xmlFilePath);
        request.setAttribute("action", "updateurls");
    }

    public void configBackupProcess(GenericRequest request)
        throws IOException, DatabaseException, AuthenticationException {

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        String servletClassPath = FileUtil.getServletClassesPath();
        EnvironmentService environmentService = MvnCoreServiceFactory.getMvnCoreService().getEnvironmentService(); 

        String mvnCoreFileName      = servletClassPath + File.separator + "mvncore.xml";
        String mvnForumFileName     = servletClassPath + File.separator + "mvnforum.xml";
        String mvnForumEntFileName  = servletClassPath + File.separator + "mvnforum_enterprise.xml";
        String mvnAdFileName        = servletClassPath + File.separator + "mvnad.xml";
        String mvnCmsFileName       = servletClassPath + File.separator + "mvncms.xml";

        String pattern = "yyyy-MM-dd_HH-mm-ss";
        String nowDesc = DateUtil.format(new Date(), pattern);
        String newMvnCoreFileName       = servletClassPath + File.separator + "mvncore_" + nowDesc + ".xml";
        String newMvnForumFileName      = servletClassPath + File.separator + "mvnforum_" + nowDesc + ".xml";
        String newMvnForumEntFileName   = servletClassPath + File.separator + "mvnforum_enterprise" + nowDesc + ".xml";
        String newMvnAdFileName         = servletClassPath + File.separator + "mvnad" + nowDesc + ".xml";
        String newMvnCmsFileName        = servletClassPath + File.separator + "mvncms" + nowDesc + ".xml";

        // We don't have to check files here, we check it in FileUtil.copyFile
        FileUtil.copyFile(mvnCoreFileName, newMvnCoreFileName, false);
        FileUtil.copyFile(mvnForumFileName, newMvnForumFileName, false);
        
        if (environmentService.isEnterprise()) {
            FileUtil.copyFile(mvnForumEntFileName, newMvnForumEntFileName, false);
            File newMvnForumEntFile = new File(newMvnForumEntFileName);
            request.setAttribute("MvnForumEntFileName", newMvnForumEntFile.getAbsolutePath());
        }
        if (environmentService.isMVNAd()) {
            FileUtil.copyFile(mvnAdFileName, newMvnAdFileName, false);
            File newMvnAdFile = new File(newMvnAdFileName);
            request.setAttribute("MvnAdFileName", newMvnAdFile.getAbsolutePath());
        }
        if (environmentService.isMVNCMS()) {
            FileUtil.copyFile(mvnCmsFileName, newMvnCmsFileName, false);
            File newMvnCmsFile = new File(newMvnCmsFileName);
            request.setAttribute("MvnCmsFileName", newMvnCmsFile.getAbsolutePath());
        }

        File newMVNCoreFile = new File(newMvnCoreFileName);
        File newMVNForumFile = new File(newMvnForumFileName);

        request.setAttribute("MvnCoreFileName", newMVNCoreFile.getAbsolutePath());
        request.setAttribute("MvnForumFileName", newMVNForumFile.getAbsolutePath());
        request.setAttribute("step", "Backup");
    }

    private void saveDocument(Document doc, String fileName) throws IOException {
        XMLWriter writer = new XMLWriter(new FileWriter(fileName));
        writer.write(doc);
        writer.close();
    }

    public void prepareEditTemplate(GenericRequest request)
        throws AuthenticationException, DatabaseException, IOException,
        FileNotFoundException, BadInputException {

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        String templateName = GenericParamUtil.getParameterSafe(request, "template", false);
        StringUtil.checkGoodName(templateName);
        String subject = "";
        String body = "";
        final String SUBJECT_SUFFIX = "_subject";
        final String BODY_SUFFIX = "_body";
        final String EXTENSION = ".ftl";

        if (templateName.equals("")) {
            templateName = MVNForumGlobal.TEMPLATE_SENDACTIVATECODE_PREFIX;
        }

        // check for valid input
        if ((templateName.equals(MVNForumGlobal.TEMPLATE_FORGOTPASSWORD_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_SENDACTIVATECODE_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_DIGEST_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_SENDMAIL_BECAUSE_CENSORED_POST_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_SINGLE_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_SINGLE_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_DIGEST_PREFIX) == false)) {
            throw new AssertionError("Does not accept invalid input: " + templateName);
        }

        String templateDir = MVNForumConfig.getTemplateDir();
        String subjectFileName = templateDir + File.separator + templateName + SUBJECT_SUFFIX;
        String bodyFileName    = templateDir + File.separator + templateName + BODY_SUFFIX;

        if (MVNForumConfig.getSendWatchMailAsHTML() &&
            templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_DIGEST_PREFIX)) {
            bodyFileName += "_html";
        }

        subjectFileName += EXTENSION;
        bodyFileName += EXTENSION;

//        subject = new String(FileUtil.getBytes(new FileInputStream(subjectFileName)), "UTF-8");
//        body    = new String(FileUtil.getBytes(new FileInputStream(bodyFileName)), "UTF-8");
        subject = FileUtil.readFile(subjectFileName, "UTF-8");
        body    = FileUtil.readFile(bodyFileName, "UTF-8");

        request.setAttribute("TemplateSubject", subject);
        request.setAttribute("TemplateBody", body);
    }

    public void processEditTemplate(GenericRequest request)
        throws DatabaseException, AuthenticationException, IOException,
        FileNotFoundException, BadInputException, TemplateException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();

        final String SUBJECT_SUFFIX = "_subject";
        final String BODY_SUFFIX = "_body";
        final String EXTENSION = ".ftl";

        String templateName = GenericParamUtil.getParameterSafe(request, "template", true);
        StringUtil.checkGoodName(templateName);

        // checking valid input here
        if ((templateName.equals(MVNForumGlobal.TEMPLATE_FORGOTPASSWORD_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_SENDACTIVATECODE_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_DIGEST_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_SENDMAIL_BECAUSE_CENSORED_POST_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_SINGLE_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_SINGLE_PREFIX) == false) &&
            (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_DIGEST_PREFIX) == false)) {
            throw new AssertionError("Does not accept invalid input: " + templateName);
        }

        String subject = GenericParamUtil.getParameter(request, "subject", true);
        String body    = GenericParamUtil.getParameter(request, "body", true);

        String templateDir = MVNForumConfig.getTemplateDir();
        String subjectFileName = templateDir + File.separator + templateName + SUBJECT_SUFFIX;
        String bodyFileName    = templateDir + File.separator + templateName + BODY_SUFFIX;

        if (MVNForumConfig.getSendWatchMailAsHTML() &&
            templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_DIGEST_PREFIX)) {
            bodyFileName += "_html";
        }

        subjectFileName += EXTENSION;
        bodyFileName += EXTENSION;

        // just for testing FreeMarker
        SimpleHash root = new SimpleHash();
        try {
            Configuration cfg = MVNForumConfig.getFreeMarkerConfiguration();
            if (templateName.equals(MVNForumGlobal.TEMPLATE_SENDACTIVATECODE_PREFIX)) {
                root.put("serverName", "");
                root.put("MVNForumInfo", "");
                root.put("activationUrl", "");
                root.put("memberName", "");
                root.put("activateCode", "");
            } else if (templateName.equals(MVNForumGlobal.TEMPLATE_FORGOTPASSWORD_PREFIX)) {
                root.put("serverName", "");
                root.put("MVNForumInfo", "");
                root.put("passwordResetUrl", "");
                root.put("memberName", "");
                root.put("currentTempPassword", "");
            } else if (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_DIGEST_PREFIX)) {
                root.put("lastSent", "");
                root.put("now", "");
                root.put("forumBase", "");

                ArrayList list = new ArrayList();
                SimpleHash subroot = new SimpleHash();
                subroot.put("leader", true);
                subroot.put("categoryName", "");
                subroot.put("forumName", "");
                subroot.put("threadTopic", "");
                subroot.put("memberName", "");
                subroot.put("lastPostMemberName", "");
                subroot.put("threadLastPostDate", "");
                subroot.put("threadUrl", "");
                list.add(subroot);

                root.put("threadWatchList", list);
            } else if (templateName.equals(MVNForumGlobal.TEMPLATE_SENDMAIL_BECAUSE_CENSORED_POST_PREFIX)) {
                root.put("postID", "");
                root.put("forumID", "");
                root.put("threadID", "");
                root.put("memberID", "");
                root.put("postURL", "");
            } else if (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_SINGLE_PREFIX)) {
                root.put("lastSent", "");
                root.put("now", "");
                root.put("forumBase", "");

                SimpleHash subRoot = new SimpleHash();
                subRoot.put("categoryName", "");
                subRoot.put("forumName", "");
                subRoot.put("threadTopic", "");
                subRoot.put("memberName", "");
                subRoot.put("lastPostMemberName", "");
                subRoot.put("threadLastPostDate", "");
                subRoot.put("threadUrl", "");
                subRoot.put("leader", true);

                ArrayList list = new ArrayList();
                list.add(subRoot);

                Iterator iter = list.iterator();

                root.put("threadWatch", iter.next());
            } else if (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_SINGLE_PREFIX)) {
                root.put("lastSent", "");
                root.put("now", "");
                root.put("forumBase", "");

                SimpleHash subRoot = new SimpleHash();
                subRoot.put("categoryName", "");
                subRoot.put("forumName", "");
                subRoot.put("threadTopic", "");
                subRoot.put("threadID", "");
                subRoot.put("memberReceiveMail", "");
                subRoot.put("memberName", "");
                subRoot.put("lastPostMemberName", "");
                subRoot.put("threadLastPostDate", "");
                subRoot.put("confirmedCode", "");
                subRoot.put("threadBodyLong", "");
                subRoot.put("threadBodyShort", "");
                subRoot.put("threadUrl", "");
                subRoot.put("leader", true);
                subRoot.put("haveConfirmedCode", true);

                ArrayList list = new ArrayList();
                list.add(subRoot);

                Iterator iter = list.iterator();

                root.put("threadWatch", iter.next());
            } else if (templateName.equals(MVNForumGlobal.TEMPLATE_WATCHMAIL_GATEWAY_DIGEST_PREFIX)) {
                root.put("lastSent", "");
                root.put("now", "");
                root.put("forumBase", "");

                SimpleHash subRoot = new SimpleHash();
                subRoot.put("categoryName", "");
                subRoot.put("forumName", "");
                subRoot.put("threadTopic", "");
                subRoot.put("threadID", "");
                subRoot.put("memberReceiveMail", "");
                subRoot.put("memberName", "");
                subRoot.put("lastPostMemberName", "");
                subRoot.put("threadLastPostDate", "");
                subRoot.put("confirmedCode", "");
                subRoot.put("threadBodyLong", "");
                subRoot.put("threadUrl", "");
                subRoot.put("leader", true);
                subRoot.put("haveConfirmedCode", true);
                subRoot.put("mailFrom", "");

                ArrayList list = new ArrayList();
                list.add(subRoot);

                root.put("threadWatchList", list);
            } else {
                AssertionUtil.doAssert(false, "Does not accept invalid input: " + templateName);
            }
            StringReader subjectReader = new StringReader(subject);
            StringReader bodyReader = new StringReader(body);

            Template subjectTemplate = new Template("", subjectReader, cfg, "");
            StringWriter subjectWriter = new StringWriter(256);
            subjectTemplate.process(root, subjectWriter);

            Template bodyTemplate = new Template("", bodyReader, cfg, "");
            StringWriter bodyWriter = new StringWriter(1024);
            bodyTemplate.process(root, bodyWriter);
        } catch(TemplateException ex) {
            throw ex;
        }
        FileUtil.writeFile(subject, subjectFileName, "UTF-8");
        FileUtil.writeFile(body, bodyFileName, "UTF-8");

        request.setAttribute("Successful", "true");
        request.setAttribute("TemplateSubject", subject);
        request.setAttribute("TemplateBody", body);
    }

    public void commitConfig(GenericRequest request)
        throws DatabaseException, AuthenticationException {

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureCanAdminSystem();
        
        MVNForumConfig.reload();
        MVNCoreConfig.reload();
        
        MvnCoreServiceFactory.getMvnCoreService().getEnvironmentService().overloadEnvironment();
        
        request.setAttribute("action", "commit");
    }

}
