#!/bin/sh

# ---------------------------------------------------------------------------------
# This shell script will build fetch the latest CVS version of MvnForum
# build and deploy it to the Jetty application server.

# cd to the root directory, containing the mvnforum/ myvietnam and mvnforum-postconf
# directories and run the script from there.
# ----------------------------------------------------------------------------------

# install various ENV variables and PATH's
. ~/.bash_profile

BASEDIR=`pwd`
COMPILE_DATE=`date`

WEBAPPBASEDIR=$BASEDIR/build/build-mvnforum/webapp/mvnforum
XMLCONFIG_CORE=$WEBAPPBASEDIR/WEB-INF/classes/mvncore.xml
XMLCONFIG_MVNFORUM=$WEBAPPBASEDIR/WEB-INF/classes/mvnforum.xml
LOG4JCONFIG=$WEBAPPBASEDIR/WEB-INF/classes/log4j.properties

HSQLDB_HOME=$HOME/hsqldb
HSQLDB_DATABASEPATH=$HOME/cvsforumdb
HSQLDB_DBNAME=testforumdb
HSQLDB_JDBCDRIVER=org.hsqldb.jdbcDriver
HSQLDB_JDBCURL=jdbc:hsqldb:$HSQLDB_DATABASEPATH/$HSQLDB_DBNAME
HSQLDB_JDBCUSER=sa

FORUM_HOME=/home/cvsforum
FORUM_USERFOOTER_JSP=$BASEDIR/mvnforum/srcweb/mvnplugin/mvnforum/user/footer.jsp
FORUM_ADMINFOOTER_JSP=$BASEDIR/mvnforum/srcweb/mvnplugin/mvnforum/admin/footer.jsp
FORUM_CONTEXTPATH=/cvs-forum
FORUM_SERVERPATH="http://mvnforum.linux.dk:8080"
FORUM_MAILSERVER="127.0.0.1"
FORUM_MAILFROM="cvsforum@mvnforum.linux.dk"
FORUM_TIMEZONE=1

JETTY_HOME=$HOME/jetty
JETTY_WEBAPPS_DIR=$JETTY_HOME/webapps
TESTFORUM_WEBAPPDIR="cvs-forum"


# ------------------------------------------------------------------------------------------
# first of all, stop Jetty appserver (and HsqlDB server) 
java -jar $JETTY_HOME/stop.jar

# remove the current cvs-forum webapp...
rm -fR $HOME/tmp/$TESTFORUM_WEBAPPDIR
mv $JETTY_WEBAPPS_DIR/$TESTFORUM_WEBAPPDIR $HOME/tmp/$TESTFORUM_WEBAPPDIR
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# delete various log files and other resources generated by MvnForum and Jetty...

rm -fR $FORUM_HOME/log/* 
rm -fR $FORUM_HOME/search/* 
rm -fR $FORUM_HOME/attachment/*
rm -fR $FORUM_HOME/attachments/* 
rm -fR $FORUM_HOME/jetty/logs/*
rm -fR $FORUM_HOME/template/*
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# fetch latest CVS version of 'mvnforum' and 'myvietnam' modules...

cd $BASEDIR/mvnforum
cvs update -d
cd $BASEDIR/myvietnam
cvs update -d
# ------------------------------------------------------------------------------------------



# ------------------------------------------------------------------------------------------
# Display the CVS build date/time stamp in the footer of each JSP page...

cd $BASEDIR
cp -f userfooter.jsp $FORUM_USERFOOTER_JSP 
java FileSearchReplace $FORUM_USERFOOTER_JSP "<%=MVNForumInfo.getProductReleaseDate()%>" "Compiled from CVS on $COMPILE_DATE"

cp -f adminfooter.jsp $FORUM_ADMINFOOTER_JSP 
java FileSearchReplace $FORUM_ADMINFOOTER_JSP "<%=MVNForumInfo.getProductReleaseDate()%>" "Compiled from CVS on $COMPILE_DATE"
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# compile mvnforum web-app...

cd $BASEDIR/mvnforum
rm -fR $BASEDIR/build
ant
cd $BASEDIR
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# create the HsqlDB database instance and populate it with MvnForum default data...

# remove old HsqlDB database
rm -f $HSQLDB_DATABASEPATH/*

# Create and populate a fresh database...
cd $HSQLDB_DATABASEPATH
java org.hsqldb.util.ScriptTool -database $HSQLDB_DBNAME -user $HSQLDB_JDBCUSER -script $BASEDIR/mvnforum/sql/mvnForum_hsqldb.sql

# The HsqlDB database server will be started by the web application...
cd $BASEDIR
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# search/replace configuration parameters in mvncore.xml file...

java FileSearchReplace $XMLCONFIG_CORE \
     "<driver_class_name>com.mysql.jdbc.Driver</driver_class_name>" "<driver_class_name>$HSQLDB_JDBCDRIVER</driver_class_name>" \
     "<database_url>jdbc:mysql://localhost/mvnforum?useUnicode=true&amp;characterEncoding=utf-8</database_url>" "<database_url>$HSQLDB_JDBCURL</database_url>" \
     "<database_user>root</database_user>" "<database_user>$HSQLDB_JDBCUSER</database_user>" \
     "<mail_server>mail.localhost.com</mail_server>" "<mail_server>$FORUM_MAILSERVER</mail_server>" \
     "<default_mail_from>webmaster@yourdomain.com</default_mail_from>" "<default_mail_from>$FORUM_MAILFROM</default_mail_from>" \
     "<context_path>/mvnforum</context_path>" "<context_path>$FORUM_CONTEXTPATH</context_path>" \
     "<server_path>http://localhost:8080</server_path>" "<server_path>$FORUM_SERVERPATH</server_path>" \
     "<server_hour_offset>0</server_hour_offset>" "<server_hour_offset>$FORUM_TIMEZONE</server_hour_offset>"
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# search/replace configuration parameters in mvnforum.xml file...

java FileSearchReplace $XMLCONFIG_MVNFORUM \
     "<mvnforum_home>c:\Software\jetty\webapps\mvnforum\WEB-INF\mvnForumHome</mvnforum_home>" "<mvnforum_home>$FORUM_HOME</mvnforum_home>" \
     "<mvnforum_log>c:\Software\jetty\webapps\mvnforum\WEB-INF\mvnForumHome\log\mvnforum.log</mvnforum_log>" "<mvnforum_log>$FORUM_HOME/log/mvnforum.log</mvnforum_log>" \
     "<webmaster_email>youremail@yourdomain.com</webmaster_email>" "<webmaster_email>$FORUM_MAILFROM</webmaster_email>" \
     "<max_logins_per_hour>5</max_logins_per_hour>" "<max_logins_per_hour>20</max_logins_per_hour>" \
     "<default_watch_option>0</default_watch_option>" "<default_watch_option>1</default_watch_option>"
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# search/replace configuration parameter in log4j.properties file...

java FileSearchReplace $LOG4JCONFIG \
     "log4j.appender.A2.File=C:/Software/jetty/webapps/mvnforum/WEB-INF/mvnForumHome/log/mvnforum.log" "log4j.appender.A2.File=$FORUM_HOME/log/mvnforum.log"
# ------------------------------------------------------------------------------------------

# ------------------------------------------------------------------------------------------
# copy HsqlDB jdbc driver to WEB-INF/lib dir of deployable webapp...

cp -f $HSQLDB_HOME/lib/hsqldb.jar $WEBAPPBASEDIR/WEB-INF/lib/hsqldb.jar
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# copy mvnForumHome dir inside webapp to $HOME then remove the original (not used). 

cp -fR $WEBAPPBASEDIR/WEB-INF/mvnForumHome/* $FORUM_HOME
rm -fR $WEBAPPBASEDIR/WEB-INF/mvnForumHome

# copy MvnForum property files to root of webapp, so that they can be viewed by the developers...
cp -f $XMLCONFIG_CORE $WEBAPPBASEDIR
cp -f $XMLCONFIG_MVNFORUM $WEBAPPBASEDIR
cp -f $LOG4JCONFIG $WEBAPPBASEDIR
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# Deploy the mvnforum webapp to Jetty...
mv $WEBAPPBASEDIR $JETTY_WEBAPPS_DIR/$TESTFORUM_WEBAPPDIR
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# Finally, start Jetty Application Server
cd $JETTY_HOME
nohup java -server -Djava.awt.headless=true -jar start.jar > /dev/null &
cd $BASEDIR
# ------------------------------------------------------------------------------------------


