/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/service/impl/CategoryServiceImplDefault.java,v 1.14 2007/10/09 11:09:21 lexuanttkhtn Exp $
 * $Author: lexuanttkhtn $
 * $Revision: 1.14 $
 * $Date: 2007/10/09 11:09:21 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong, Pham Dinh Duy
 */
package com.mvnforum.service.impl;

import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.util.AssertionUtil;
import net.myvietnam.mvncore.web.GenericRequest;
import net.myvietnam.mvncore.web.GenericResponse;

import com.mvnforum.auth.AuthenticationException;
import com.mvnforum.categorytree.CategoryTreeListener;
import com.mvnforum.categorytree.impl.CategorySelector;
import com.mvnforum.categorytree.impl.CategoryTreeListenerImpl;
import com.mvnforum.categorytree.impl.ListAllForumImpl;
import com.mvnforum.categorytree.impl.ListForums;
import com.mvnforum.categorytree.impl.ModcpImpl;
import com.mvnforum.categorytree.impl.RSSImpl;
import com.mvnforum.categorytree.impl.ViewMemberPermissionsImpl;
import com.mvnforum.db.CategoryBean;
import com.mvnforum.db.ForumBean;
import com.mvnforum.service.CategoryService;

public class CategoryServiceImplDefault implements CategoryService {

    private static int count;

    public CategoryServiceImplDefault() {
        count++;
        AssertionUtil.doAssert(count == 1, "Assertion: Must have only one instance.");
    }

    public CategoryTreeListener getManagementCategoryTree(GenericRequest request, GenericResponse response)
        throws AuthenticationException, DatabaseException {

        return new CategoryTreeListenerImpl(request, response);
    }

    public CategoryTreeListener getManagementCategorySelector(GenericRequest request, GenericResponse response)
        throws AuthenticationException, DatabaseException {

        return new CategorySelector(request, response);
    }

    public CategoryTreeListener getManagementListAllForum(GenericRequest request, GenericResponse response)
        throws AuthenticationException, DatabaseException {

        return new ListAllForumImpl(request, response);
    }

    public CategoryTreeListener getManagementCategorySelector(GenericRequest request, GenericResponse response, String page)
        throws AuthenticationException, DatabaseException {

        return new CategorySelector(request, response, page);
    }

    public CategoryTreeListener getManagementCategorySelector(GenericRequest request, GenericResponse response, String page, int forum, int category)
        throws AuthenticationException, DatabaseException {

        return new CategorySelector(request, response, page, forum, category);
    }

    public CategoryTreeListener getManagementCategorySelector(GenericRequest request, GenericResponse response, String page,int forumID)
        throws AuthenticationException, DatabaseException {

        return new CategorySelector(request, response, page, forumID);
    }

    public CategoryTreeListener getManagementCategorySelector(GenericRequest request, GenericResponse response, boolean addForum, String selectName)
        throws AuthenticationException, DatabaseException {

        return new CategorySelector(request, response, addForum, selectName);
    }

    public CategoryTreeListener getManagementCategorySelector(GenericRequest request, GenericResponse response, ForumBean forumBean)
        throws AuthenticationException, DatabaseException {

        return new CategorySelector(request, response, forumBean);
    }

    public ViewMemberPermissionsImpl getManagementViewMemberPermissions(GenericRequest request)
        throws AuthenticationException, DatabaseException {

        return new ViewMemberPermissionsImpl(request);
    }

    public CategoryTreeListener getManagementRSS(GenericRequest request, GenericResponse response, String sort, String order)
        throws DatabaseException, AuthenticationException {

        return new RSSImpl(request, response, sort, order);
    }

    public CategoryTreeListener getManagementModcp(GenericRequest request, GenericResponse response)
        throws DatabaseException, AuthenticationException {

        return new ModcpImpl(request, response);
    }

    public CategoryTreeListener getManagementListForums(GenericRequest request, GenericResponse response, CategoryBean rootCategory, boolean otherInvisible, boolean show_sub_category)
        throws DatabaseException, AuthenticationException {

        return new ListForums(request, response);
    }

}
