/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/categorytree/impl/ViewMemberPermissionsImpl.java,v 1.12 2007/12/17 09:09:39 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.12 $
 * $Date: 2007/12/17 09:09:39 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong Pham Dinh Duy
 */
package com.mvnforum.categorytree.impl;

import java.io.IOException;
import java.util.Locale;

import com.mvnforum.MVNForumResourceBundle;
import com.mvnforum.auth.*;
import com.mvnforum.categorytree.CategoryTreeEvent;
import com.mvnforum.db.CategoryBean;
import com.mvnforum.db.ForumBean;

import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.util.I18nUtil;
import net.myvietnam.mvncore.web.GenericRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.*;

public class ViewMemberPermissionsImpl extends FtlCategoryTreeListener {

    private static Log log = LogFactory.getLog(ViewMemberPermissionsImpl.class);
    
    // template can be shared between users after loaded
    private static Template template;

    private MVNForumPermission permission;
    private Locale locale;

    static {
        Configuration conf = new Configuration();
        TemplateLoader loader = new ClassTemplateLoader(
                ViewMemberPermissionsImpl.class);
        conf.setTemplateLoader(loader);
        try {
            template = conf.getTemplate("viewmemberpermissions.ftl");
        } catch (IOException e) {
            log.error("Cannot load template for View Member Permission", e);
        }
    }

    public ViewMemberPermissionsImpl(GenericRequest request)
        throws AuthenticationException, DatabaseException {

        permission = (MVNForumPermission)request.getAttribute("Permissions");
        locale = I18nUtil.getLocaleInRequest(request);
        init(template);
    }

    public String drawHeader(CategoryTreeEvent event) {
        SimpleHash row = new SimpleHash();

        row.put("RowType", "Header");
        rows.add(row);

        return "";
    }

    public String drawFooter(CategoryTreeEvent event) {
        SimpleHash row = new SimpleHash();

        row.put("RowType", "Footer");
        boolean checkNoCategory = (event.getDepth() == 0);
        row.put("checkNoCategory", checkNoCategory);
        if (checkNoCategory) {
            String no_category = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.no_category");
            row.put("no_category", no_category);
        }

        rows.add(row);

        return "";
    }

    public String drawCategory(CategoryTreeEvent event) {
        SimpleHash row = new SimpleHash();
        CategoryBean category = (CategoryBean) event.getSource();

        row.put("CategoryName", category.getCategoryName());
        row.put("Empty", (event.hasForum() == false));
        String no_forum = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.no_forum");
        row.put("no_forum", no_forum);
        row.put("RowType", "Category");

        rows.add(row);

        return "";
    }

    public String drawForum(CategoryTreeEvent event) {
        SimpleHash row = new SimpleHash();
        ForumBean forum = (ForumBean) event.getSource();
        int forumID = forum.getForumID();

        row.put("RowType", "Forum");
        row.put("ForumID", String.valueOf(forumID));
        row.put("ForumName", forum.getForumName());
        
        row.put("EditForum", permission.canEditForum(forumID));
        row.put("DeleteForum", permission.canDeleteForum(forumID));
        row.put("AssignForum", permission.canAssignToForum(forumID));
        
        row.put("AddThread", permission.canAddThread(forumID));
        row.put("ModerateThread", permission.canModerateThread(forumID));
        
        row.put("ReadPost", permission.canReadPost(forumID));
        row.put("AddPost", permission.canAddPost(forumID));
        row.put("EditOwnPost", permission.canEditOwnPost(forumID));
        row.put("EditAnyPost", permission.canEditPost(forumID));
        row.put("DeletePost", permission.canDeletePost(forumID));

        row.put("AddAttachment", permission.canAddAttachment(forumID));
        row.put("GetAttachment", permission.canGetAttachment(forumID));
        
        row.put("AddPoll", permission.canAddPoll(forumID));
        row.put("EditOwnPoll", permission.canEditOwnPoll(forumID));
        row.put("EditAnyPoll", permission.canEditPoll(forumID));
        row.put("DeletePoll", permission.canDeletePoll(forumID));

        rows.add(row);

        return "";
    }

    public String drawSeparator(CategoryTreeEvent event) {
        return "";
    }

    public void setDepthTree(int depth) {
        // this.depth = depth;
    }
}
