/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/auth/MVNForumPermissionFactory.java,v 1.26 2007/10/09 11:09:12 lexuanttkhtn Exp $
 * $Author: lexuanttkhtn $
 * $Revision: 1.26 $
 * $Date: 2007/10/09 11:09:12 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Minh Nguyen
 * @author: Mai  Nguyen
 */
package com.mvnforum.auth;

import java.util.*;

import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.exception.ObjectNotFoundException;
import net.myvietnam.mvncore.service.MvnCoreServiceFactory;

import com.mvnforum.*;
import com.mvnforum.db.*;

public class MVNForumPermissionFactory {

    private MVNForumPermissionFactory() {
    }

    static MVNForumPermission getAnonymousPermission()
        throws DatabaseException {

        MVNForumPermissionImpl permission = new MVNForumPermissionImpl();

        ArrayList permList = MVNForumPermissionWebHelper.getPermissionsForGroupGuest();
        for (int i = 0; i < permList.size(); i++) {
            int perm = ((Integer)permList.get(i)).intValue();
            permission.setPermission(perm);
        }

        ArrayList forumPermList = MVNForumPermissionWebHelper.getPermissionsForGroupGuestInForums();
        for (int i = 0; i < forumPermList.size(); i++) {
            ForumPermission perm = (ForumPermission)forumPermList.get(i);
            permission.setPermissionInForum(perm.getForumID(), perm.getPermission());
        }

        return permission;
    }

    public static MVNForumPermission getAuthenticatedPermission(MemberBean memberBean)
        throws DatabaseException, ObjectNotFoundException {

        int memberID = memberBean.getMemberID();

        if (memberID == MVNForumConstant.MEMBER_ID_OF_GUEST || memberID == 0) {
            throw new AssertionError("Cannot get authenticated permission for user Guest.");
        }

        MVNForumPermissionImpl permission = new MVNForumPermissionImpl();

        ArrayList memberPermList = MVNForumPermissionWebHelper.getMemberPermissions(memberID);
        for (int i = 0; i < memberPermList.size(); i++) {
            int perm = ((Integer)memberPermList.get(i)).intValue();
            permission.setPermission(perm);
        }

        ArrayList groupPermList = MVNForumPermissionWebHelper.getGroupPermissions(memberID);
        for (int i = 0; i < groupPermList.size(); i++) {
            int perm = ((Integer)groupPermList.get(i)).intValue();
            permission.setPermission(perm);
        }

        ArrayList forumMemberPermList = MVNForumPermissionWebHelper.getMemberPermissionsInForums(memberID);
        for (int i = 0; i < forumMemberPermList.size(); i++) {
            ForumPermission perm = (ForumPermission)forumMemberPermList.get(i);
            permission.setPermissionInForum(perm.getForumID(), perm.getPermission());
        }

        ArrayList forumGroupPermList = MVNForumPermissionWebHelper.getGroupPermissionsInForums(memberID);
        for (int i = 0; i < forumGroupPermList.size(); i++) {
            ForumPermission perm = (ForumPermission)forumGroupPermList.get(i);
            permission.setPermissionInForum(perm.getForumID(), perm.getPermission());
        }

        Collection groupsContainMember = DAOFactory.getGroupsDAO().getMyGroups(memberID);
        permission.setGroupsContainMember(groupsContainMember);

        if (MvnCoreServiceFactory.getMvnCoreService().getEnvironmentService().isMVNCMS()) {
            ArrayList cmsGroupPermList = MVNCmsPermissionWebHelper.getGroupPermissionsInStepWithChannel(memberID);
            for (int i = 0; i < cmsGroupPermList.size(); i++) {
                CmsPermission perm = (CmsPermission) cmsGroupPermList.get(i);
                if (perm.getChannelID() == 0) {
                    permission.setPermissionInStep(perm.getStepID(), perm.getPermission());
                } else {
                    permission.setPermissionInStepInChannel(perm.getStepID(), perm.getChannelID(), perm.getPermission());
                }
            }
        }

        // get list of forums owned by this member
        String memberName = memberBean.getMemberName();
        Collection listForums = MyUtil.getForumsOwnedByMemberName(memberName);

        // set permissions for list of forums
        for (Iterator iter = listForums.iterator(); iter.hasNext(); ) {
            ForumBean forumBean = (ForumBean) iter.next();
            int forumID = forumBean.getForumID();
            permission.setPermissionInForum(forumID, MVNForumPermission.PERMISSION_FORUM_ADMIN);
        }

        // After user login always have PERMISSION_AUTHENTICATED
        permission.setPermission(MVNForumPermission.PERMISSION_AUTHENTICATED);

        // now check if user account is activated or not
        if (MvnCoreServiceFactory.getMvnCoreService().getEnvironmentService().isPortlet() == false) { // disable portlet, run only servlets
            if (DAOFactory.getMemberDAO().getActivateCode(memberID).equals(MemberBean.MEMBER_ACTIVATECODE_ACTIVATED)) {
                permission.setPermission(MVNForumPermission.PERMISSION_ACTIVATED);
            }
        }

        if (MVNForumConfig.getAlwaysActivation()) {
            permission.setPermission(MVNForumPermission.PERMISSION_ACTIVATED);
        }

        // The Admin (id = 1) always has SystemAdmin permission
        if (MyUtil.isRootAdminID(memberID)) {
            permission.setPermission(MVNForumPermission.PERMISSION_SYSTEM_ADMIN);
        }
        return permission;
    }
}