/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/user/UserModuleURLMapHandler.java,v 1.96 2008/01/21 03:53:12 tbtrung Exp $
 * $Author: tbtrung $
 * $Revision: 1.96 $
 * $Date: 2008/01/21 03:53:12 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Minh Nguyen
 * @author: Mai  Nguyen
 */
package com.mvnforum.user;

import java.util.Locale;

import net.myvietnam.mvncore.exception.MissingURLMapEntryException;
import net.myvietnam.mvncore.mvnframework.URLMap;
import net.myvietnam.mvncore.util.*;
import net.myvietnam.mvncore.web.GenericRequest;

import com.mvnforum.MVNForumConfig;
import com.mvnforum.MVNForumResourceBundle;
import com.mvnforum.MyUtil;

public class UserModuleURLMapHandler {

    public UserModuleURLMapHandler() {
    }

    /**
     * We must pass the requestURI to this method, instead of from request,
     * because requestURI may be changed from Processor before call this method
     * NOTE: Currently we dont use the param request
     */
    public URLMap getMap(String requestURI, GenericRequest request, String localeName)
        throws MissingURLMapEntryException {

        //localeName = MyUtil.getLocaleNameAndSlash(localeName);
        URLMap map = new URLMap();

        String userModuleJSPDirectory = "user";
        if (MyUtil.isRequestFromMobileDevice(request)) {
            userModuleJSPDirectory = "user_xhtml";
        }

        if (requestURI.equals("/error")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/error.jsp");
        } else if (requestURI.equals("") || requestURI.equals("/")) {
            map.setResponse(UserModuleConfig.getUrlPattern() + "/index");
        } else if (requestURI.equals("/index")) {
            if (MVNForumConfig.getEnablePortalLikeIndexPage()) {
                map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/index.jsp");//index.jsp
            } else {
                map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listforums.jsp");//index.jsp
            }
        } else if (requestURI.equals("/listonlineusers")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listonlineusers.jsp");

        } else if (requestURI.equals("/listforums")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listforums.jsp");
        } else if (requestURI.equals("/listthreads")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listthreads.jsp");
        } else if (requestURI.equals("/listunansweredthreads")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listunansweredthreads.jsp");
        } else if (requestURI.equals("/listrecentthreads")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listrecentthreads.jsp");

        } else if (requestURI.equals("/addpost")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addpost.jsp");
        } else if (requestURI.equals("/addpostprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addpostsuccess.jsp");
        } else if (requestURI.equals("/editpost")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addpost.jsp");//editpost.jsp
        } else if (requestURI.equals("/updatepost")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/updatepostsuccess.jsp");
        } else if (requestURI.equals("/printpost")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/printpost.jsp");
        } else if (requestURI.equals("/deletepost")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletepost.jsp");
        } else if (requestURI.equals("/deletepostprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletepostsuccess.jsp");

        } else if (requestURI.equals("/addattachment")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addattachment.jsp");
        } else if (requestURI.equals("/addattachmentprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addattachmentsuccess.jsp");
        } else if (requestURI.equals("/deleteattachment")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deleteattachment.jsp");
        } else if (requestURI.equals("/deleteattachmentprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deleteattachmentsuccess.jsp");
        } else if (requestURI.equals("/editattachment")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editattachment.jsp");
        } else if (requestURI.equals("/editattachmentprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editattachmentsuccess.jsp");
        } else if (requestURI.equals("/listattachments")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listattachments.jsp");

        } else if (requestURI.equals("/viewthread")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/viewthread.jsp");
        } else if (requestURI.equals("/printthread")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/printthread.jsp");

        } else if (requestURI.equals("/modcp")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/modcp.jsp");
        } else if (requestURI.equals("/listrecentpendingthreads")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listrecentpendingthreads.jsp");
        } else if (requestURI.equals("/listthreadswithpendingposts")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listthreadswithpendingposts.jsp");
        } else if (requestURI.equals("/listrecentthreadswithpendingposts")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listrecentthreadswithpendingposts.jsp");
        } else if (requestURI.equals("/moderatependingthreads")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/moderatependingthreads.jsp");
        } else if (requestURI.equals("/moderatependingthreadsprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/moderatependingthreadssuccess.jsp");
        } else if (requestURI.equals("/moderatependingposts")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/moderatependingposts.jsp");
        } else if (requestURI.equals("/moderatependingpostsprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/moderatependingpostssuccess.jsp");

        } else if (requestURI.equals("/listpendingthreadsxml")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listpendingthreadsxml.jsp");

        } else if (requestURI.equals("/splitthread")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/splitthread.jsp");
        } else if (requestURI.equals("/splitthreadprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/splitthreadsuccess.jsp");

        } else if (requestURI.equals("/deletethread")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletethread.jsp");
        } else if (requestURI.equals("/deletethreadprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletethreadsuccess.jsp");

        } else if (requestURI.equals("/editthreadstatus")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editthreadstatus.jsp");
        } else if (requestURI.equals("/editthreadstatusprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editthreadstatussuccess.jsp");
        } else if (requestURI.equals("/editthreadtype")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editthreadtype.jsp");
        } else if (requestURI.equals("/editthreadtypeprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editthreadtypesuccess.jsp");

        } else if (requestURI.equals("/movethread")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/movethread.jsp");
        } else if (requestURI.equals("/movethreadprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/movethreadsuccess.jsp");

        } else if (requestURI.equals("/viewmember")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/viewmember.jsp");
        } else if (requestURI.equals("/listmembers")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/listmembers.jsp");
        } else if (requestURI.equals("/editmember")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editmember.jsp");
        } else if (requestURI.equals("/updatemember")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/updatemembersuccess.jsp");

        } else if (requestURI.equals("/login")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/login.jsp");
        } else if (requestURI.equals("/loginprocess")) {
            //map.setResponse("/mvnplugin/mvnforum/user/loginsuccess.jsp");
            map.setResponse(UserModuleConfig.getUrlPattern() + "/index");
        } else if (requestURI.equals("/logout")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/login.jsp");
        } else if (requestURI.equals("/deletecookieprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletecookiesuccess.jsp");

        } else if (requestURI.equals("/rsssummary")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/rsssummary.jsp");
        } else if (requestURI.equals("/atom")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/atom.jsp");
        } else if (requestURI.equals("/rss")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/rss.jsp");
        } else if (requestURI.equals("/rss2")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/rss2.jsp");

        } else if (requestURI.equals("/help")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/help.jsp");
        } else if (requestURI.equals("/helpintro")) {
            map.setResponse("/mvnplugin/mvnforum/docs/intro.html");
        } else if (requestURI.equals("/helpinstall")) {
            map.setResponse("/mvnplugin/mvnforum/docs/install.html");
        } else if (requestURI.equals("/helpuser")) {
            map.setResponse("/mvnplugin/mvnforum/docs/user.html");
        } else if (requestURI.equals("/helpadmin")) {
            map.setResponse("/mvnplugin/mvnforum/docs/admin.html");
        } else if (requestURI.equals("/helpdeveloper")) {
            map.setResponse("/mvnplugin/mvnforum/docs/developer.html");
        } else if (requestURI.equals("/faq")) {
            map.setResponse("/mvnplugin/mvnforum/docs/faq.html");

        } else if (requestURI.equals("/search")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/search.jsp");
        } else if (requestURI.equals("/searchmember")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/searchmember.jsp");
        } else if (requestURI.equals("/registermember")) {
            boolean agree = GenericParamUtil.getParameterBoolean(request, "agree");
            if ((MVNForumConfig.getEnableRegisterRule() == false) || (agree == true)) {
                map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmember.jsp");
            } else {
                map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/viewrule.jsp");
            }
        } else if (requestURI.equals("/registermemberprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmembersuccess.jsp");

        } else if (requestURI.equals("/searchattachments")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/searchattachments.jsp");

        } else if (requestURI.equals("/myprofile")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/myprofile.jsp");
        } else if (requestURI.equals("/changemypassword")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changemypassword.jsp");
        } else if (requestURI.equals("/changemypasswordprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changemypasswordsuccess.jsp");
        } else if (requestURI.equals("/changeemail")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changeemail.jsp");
        } else if (requestURI.equals("/changeemailprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changeemailsuccess.jsp");
        } else if (requestURI.equals("/changesignature")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changesignature.jsp");
        } else if (requestURI.equals("/changesignatureprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changesignaturesuccess.jsp");

        } else if (requestURI.equals("/changeavatar")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/changeavatar.jsp");
        } else if (requestURI.equals("/uploadavatar")) {
            map.setResponse(UserModuleConfig.getUrlPattern() + "/myprofile");
        } else if (requestURI.equals("/updateavatar")) {
            map.setResponse(UserModuleConfig.getUrlPattern() + "/myprofile");
        } else if (requestURI.equals("/mywatch")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/mywatch.jsp");
        } else if (requestURI.equals("/addwatch")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addwatch.jsp");
        } else if (requestURI.equals("/addwatchprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addwatchsuccess.jsp");
        } else if (requestURI.equals("/deletewatchprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletewatchsuccess.jsp");
        } else if (requestURI.equals("/editwatch")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editwatch.jsp");
        } else if (requestURI.equals("/editwatchprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/editwatchsuccess.jsp");

        } else if (requestURI.equals("/mymessage")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/mymessage.jsp");
        } else if (requestURI.equals("/addmessage")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessage.jsp");
        } else if (requestURI.equals("/addmessageprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessagesuccess.jsp");
        } else if (requestURI.equals("/sendmail")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/sendmail.jsp");
        } else if (requestURI.equals("/sendmailprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/sendmailsuccess.jsp");
        } else if (requestURI.equals("/viewmessage")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/viewmessage.jsp");
        } else if (requestURI.equals("/sendmessageprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessagesuccess.jsp");
        } else if (requestURI.equals("/deletemessageprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletemessagesuccess.jsp");
        } else if (requestURI.equals("/processmessage")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/processmessagesuccess.jsp");
        } else if (requestURI.equals("/addmessageattachment")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessageattachment.jsp");
        } else if (requestURI.equals("/addmessageattachmentprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessageattachmentsuccess.jsp");

        } else if (requestURI.equals("/mymessagefolder")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/mymessagefolder.jsp");
        } else if (requestURI.equals("/addmessagefolder")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessagefolder.jsp");
        } else if (requestURI.equals("/addmessagefolderprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addmessagefoldersuccess.jsp");
        } else if (requestURI.equals("/deletemessagefolder")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletemessagefolder.jsp");
        } else if (requestURI.equals("/deletemessagefolderprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletemessagefoldersuccess.jsp");
        } else if (requestURI.equals("/updatefolderorder")) {
            map.setResponse(UserModuleConfig.getUrlPattern() + "/mymessagefolder");

        } else if (requestURI.equals("/myfavoritethread")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/myfavoritethread.jsp");
        } else if (requestURI.equals("/addfavoritethreadprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/addfavoritethreadsuccess.jsp");
        } else if (requestURI.equals("/deletefavoritethreadprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/deletefavoritethreadsuccess.jsp");

        } else if (requestURI.equals("/iforgotpasswords")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/forgotpassword.jsp");
        } else if (requestURI.equals("/forgotpasswordprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/forgotpasswordsuccess.jsp");
        } else if (requestURI.equals("/resetpassword")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/resetpassword.jsp");
        } else if (requestURI.equals("/resetpasswordprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/resetpasswordsuccess.jsp");
        } else if (requestURI.equals("/bbcode")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/bbcode.jsp");

        } else if (requestURI.equals("/sendactivationcode")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/sendactivationcode.jsp");
        } else if (requestURI.equals("/sendactivationcodeprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/sendactivationcodesuccess.jsp");
        } else if (requestURI.equals("/activatemember")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/activatemember.jsp");
        } else if (requestURI.equals("/activatememberprocess")) {
            map.setResponse("/mvnplugin/mvnforum/" + userModuleJSPDirectory + "/activatemembersuccess.jsp");
        }

        Locale locale = I18nUtil.getLocaleInRequest(request);
        // unknown module, we throw an exception
        if (map.getResponse() == null) {
            //String errorMessage = "Cannot find matching entry in URLMap for '" + requestURI + "'. Please contact the administrator.";
            String localizedMessage = MVNForumResourceBundle.getString(locale, "mvncore.exception.MissingURLMapEntryException.cannot_find_matching_entry", new Object[] {requestURI});
            throw new MissingURLMapEntryException(localizedMessage);
            //throw new MissingURLMapEntryException(errorMessage);
        }
        return map;
    }
}
