/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/categorytree/impl/ListForums.java,v 1.30 2007/12/17 09:09:39 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.30 $
 * $Date: 2007/12/17 09:09:39 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong Pham Dinh Duy
 */

package com.mvnforum.categorytree.impl;

import java.io.IOException;
import java.util.Locale;

import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.security.Encoder;
import net.myvietnam.mvncore.service.MvnCoreServiceFactory;
import net.myvietnam.mvncore.service.URLResolverService;
import net.myvietnam.mvncore.util.I18nUtil;
import net.myvietnam.mvncore.web.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.mvnforum.*;
import com.mvnforum.auth.*;
import com.mvnforum.categorytree.CategoryTreeEvent;
import com.mvnforum.db.*;
import com.mvnforum.user.WatchUtil;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.*;

public class ListForums extends FtlCategoryTreeListener {

    private static Log log = LogFactory.getLog(ListForums.class);

    private GenericRequest request;
    private GenericResponse response;

    private OnlineUser onlineUser;
    private MVNForumPermission permission;
    private URLResolverService urlResolver = MvnCoreServiceFactory.getMvnCoreService().getURLResolverService();

    private static Template template;

    private int count                                = 0;
    private boolean flag                             = false;
    private boolean hasReadActiveCurrentForum        = false;
    private boolean hasUnreadActiveCurrentForum      = false;
    private boolean hasReadClosedCurrentForum        = false;
    private boolean hasUnreadClosedCurrentForum      = false;
    private boolean hasReadLockedCurrentForum        = false;
    private boolean hasUnreadLockedCurrentForum      = false;
    private boolean hasReadDisabledCurrentForum      = false;
    private boolean hasUnreadDisabledCurrentForum    = false;
    private int forumCountInCurrentCategory          = 0;
    private Locale locale;
    private CategoryBean category;

    static {
        Configuration conf = new Configuration();
        TemplateLoader loader = new ClassTemplateLoader(ListForums.class);
        conf.setTemplateLoader(loader);
        try {
            template = conf.getTemplate("listforums.ftl");
        } catch (IOException e) {
            log.error("Cannot load template for List Forums", e);
        }
    }

    public ListForums(GenericRequest request)
        throws AuthenticationException, DatabaseException {

        this.request = request;
        onlineUser = OnlineUserManager.getInstance().getOnlineUser(request);
        permission = onlineUser.getPermission();
        locale = I18nUtil.getLocaleInRequest(request);
        super.init(template);
    }

    public ListForums(GenericRequest request,GenericResponse response)
        throws AuthenticationException, DatabaseException {

        this.request = request;
        this.response = response;
        onlineUser = OnlineUserManager.getInstance().getOnlineUser(request);
        permission = onlineUser.getPermission();
        locale = I18nUtil.getLocaleInRequest(request);
        super.init(template);
    }

    public String drawHeader(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();

        row.put("name", "header");

        String forum_name_desc = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.forum_name_desc");
        row.put("forum_name_desc", forum_name_desc);
        String thread_count = MVNForumResourceBundle.getString(locale, "mvnforum.common.thread_count");
        row.put("thread_count", thread_count);
        String post_count = MVNForumResourceBundle.getString(locale, "mvnforum.common.post_count");
        row.put("post_count", post_count);
        String last_post = MVNForumResourceBundle.getString(locale, "mvnforum.common.last_post");
        row.put("last_post", last_post);

        rows.add(row);

        return "";
    }

    public String drawFooter(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        row.put("name", "footer");
        boolean checkNoCategory = (count == 0);
        row.put("checkNoCategory", checkNoCategory);
        if (checkNoCategory) {
            //there is no any category
            String no_category = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.no_category");
            row.put("no_category", no_category);
        }
        //for last category
        row.put("hasReadActiveCurrentForum", hasReadActiveCurrentForum);
        row.put("hasUnreadActiveCurrentForum", hasUnreadActiveCurrentForum);
        row.put("hasReadClosedCurrentForum", hasReadClosedCurrentForum);
        row.put("hasUnreadClosedCurrentForum", hasUnreadClosedCurrentForum);
        row.put("hasReadLockedCurrentForum", hasReadLockedCurrentForum);
        row.put("hasUnreadLockedCurrentForum", hasUnreadLockedCurrentForum);
        row.put("hasReadDisabledCurrentForum", hasReadDisabledCurrentForum);
        row.put("hasUnreadDisabledCurrentForum", hasUnreadDisabledCurrentForum);
        row.put("ContextPath", request.getContextPath());

        if (hasReadActiveCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_active");
            row.put("no_new", no_new);
        }
        if (hasUnreadActiveCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_active");
            row.put("has_new", has_new);
        }
        if (hasReadClosedCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_closed");
            row.put("closed_no_new", no_new);
        }
        if (hasUnreadClosedCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_closed");
            row.put("closed_has_new", has_new);
        }
        if (hasReadLockedCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_locked");
            row.put("locked_no_new", no_new);
        }
        if (hasUnreadLockedCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_locked");
            row.put("locked_has_new", has_new);
        }
        if (hasReadDisabledCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_disabled");
            row.put("disabled_no_new", no_new);
        }
        if (hasUnreadDisabledCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_disabled");
            row.put("disabled_has_new", has_new);
        }

        rows.add(row);

        return "";
    }

    public String drawForum(CategoryTreeEvent event) {

        ForumBean forum = (ForumBean) event.getSource();
        SimpleHash row = new SimpleHash();

        boolean checkForumToSee = ((forum.getCategoryID() == category.getCategoryID()) && permission.canReadPost(forum.getForumID()) && (forum.getForumStatus() != ForumBean.FORUM_STATUS_DISABLED));
        row.put("checkForumToSee", checkForumToSee);
        row.put("name", "forum");

        if (checkForumToSee) {
            //this is not a disable forum
            String forumIcon = MyUtil.getForumIconName(onlineUser.getLastLogonTimestamp().getTime(), forum.getForumLastPostDate().getTime(), forum.getForumStatus(), forum.getForumThreadCount());
            row.put("forumIcon", forumIcon);

            if (forumIcon.equals(MyUtil.FORUM_ICON_READ_ACTIVE)) {
                hasReadActiveCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_ACTIVE)) {
                hasUnreadActiveCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_READ_CLOSED)) {
                hasReadClosedCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_CLOSED)) {
                hasUnreadClosedCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_READ_LOCKED)) {
                hasReadLockedCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_LOCKED)) {
                hasUnreadLockedCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_READ_DISABLED)) {
                hasReadDisabledCurrentForum = true;
            } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_DISABLED)) {
                hasUnreadDisabledCurrentForum = true;
            }
            row.put("forumCountInCurrentCategory", new Integer(forumCountInCurrentCategory));
            forumCountInCurrentCategory++;

            row.put("ContextPath", request.getContextPath());

            StringBuffer filter = new StringBuffer();
            filter.append(MyUtil.filter(forum.getForumDesc(), false/*html*/, true/*emotion*/, true/*mvnCode*/, true/*newLine*/, true/*URL*/));
            row.put("filter", filter.toString());

            row.put("ForumThreadCount", String.valueOf(forum.getForumThreadCount()));
            row.put("ForumPostCount", String.valueOf(forum.getForumPostCount()));

            String listThreadsLink = urlResolver.encodeURL(request, response, "listthreads?forum=" + forum.getForumID());
            row.put("ForumName", forum.getForumName());
            row.put("ListThreadsLink", listThreadsLink);

            row.put("no_post", MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.no_post"));
            row.put("by", MVNForumResourceBundle.getString(locale, "mvnforum.common.by"));

            boolean checkCondition = (forum.getLastPostMemberName().length() == 0) || (forum.getForumThreadCount() == 0);
            row.put("checkCondition", checkCondition);

            row.put("GMTTimestampFormat", onlineUser.getGMTTimestampFormat(forum.getForumLastPostDate()));

            String viewmemberLink = urlResolver.encodeURL(request, response, "viewmember?member=" + Encoder.encodeURL(forum.getLastPostMemberName()));
            row.put("viewmemberLink", viewmemberLink);

            row.put("LastPostMemberName", forum.getLastPostMemberName());
        }

        rows.add(row);

        return "";
    }

    public String drawSeparator(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        CategoryBean category = (CategoryBean) event.getSource();

        row.put("name", "Separator");
        row.put("CategoryId", String.valueOf(category.getCategoryID()));

        rows.add(row);

        return "";
    }

    public void setDepthTree(int depth) {
        // default
    }

    public String drawCategory(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        forumCountInCurrentCategory = 0;
        if (count!=0) {
            flag = true;
        }
        count++;

        row.put("flag", flag);

        category = (CategoryBean)event.getSource();
        row.put("name", "category");

        row.put("CanViewForums", MyUtil.canViewAnyForumInCategory(category.getCategoryID(), permission));
        row.put("CategoryName", category.getCategoryName());
        row.put("CategoryId", String.valueOf(category.getCategoryID()));
        row.put("ContextPath", request.getContextPath());

        row.put("enableEasyWatching", new Boolean(MVNForumConfig.getEnableEasyWatching()));
        if (MVNForumConfig.getEnableEasyWatching()) {
            // check whether this forum is being watched
            Boolean isWatched = Boolean.FALSE;
            if (onlineUser.isMember()) {
                try {
                    isWatched = new Boolean(WatchUtil.isCategoryWatched(onlineUser.getMemberID(), category));
                } catch (Exception ex) {
                    //do nothing
                }
            }
            row.put("isWatched", isWatched);
            if (isWatched.booleanValue() == false) {
                String addWatchCategoryLink = urlResolver.encodeURL(request, response, "addwatchprocess?WatchType=" + WatchBean.WATCH_TYPE_DEFAULT + "&amp;WatchSelector=" + WatchBean.SELECT_CATEGORY_WATCH + "&amp;category=" + category.getCategoryID());
                row.put("addWatchCategoryLink", addWatchCategoryLink);

                String watchThisCategory = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.watch_this_category");
                row.put("WatchThisCategory", watchThisCategory);
            } else {
                String watchingThisCategory = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.you_are_watching_this_category");
                row.put("WatchingThisCategory", watchingThisCategory);
            }

        }

        StringBuffer filter = new StringBuffer();
        filter.append(MyUtil.filter(category.getCategoryDesc(), false/*html*/, true/*emotion*/, true/*mvnCode*/, true/*newLine*/, true/*URL*/));
        row.put("filter", filter.toString());

        rows.add(row);

        return "";//default
    }

}