/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/categorytree/impl/ListAllForumImpl.java,v 1.11 2007/12/17 09:09:40 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.11 $
 * $Date: 2007/12/17 09:09:40 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong Pham Dinh Duy
 */
package com.mvnforum.categorytree.impl;

import java.io.IOException;
import java.util.Locale;

import com.mvnforum.MVNForumResourceBundle;
import com.mvnforum.MyUtil;
import com.mvnforum.auth.*;
import com.mvnforum.categorytree.CategoryTreeEvent;
import com.mvnforum.db.CategoryBean;
import com.mvnforum.db.ForumBean;

import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.service.MvnCoreServiceFactory;
import net.myvietnam.mvncore.service.URLResolverService;
import net.myvietnam.mvncore.util.I18nUtil;
import net.myvietnam.mvncore.web.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.*;

public class ListAllForumImpl extends FtlCategoryTreeListener {

    private static Log log = LogFactory.getLog(ListAllForumImpl.class);

    private GenericRequest request;
    private GenericResponse response;

    private OnlineUser onlineUser;
    private MVNForumPermission permission;
    private URLResolverService urlResolver = MvnCoreServiceFactory.getMvnCoreService().getURLResolverService();

    private static Template template;

    private int count = 0;
    private boolean flag = false;
    private Locale locale;

    static {
        Configuration conf = new Configuration();
        TemplateLoader loader = new ClassTemplateLoader(ListAllForumImpl.class);
        conf.setTemplateLoader(loader);
        try {
            template = conf.getTemplate("listforums_index.ftl");
        } catch (IOException e) {
            log.error("Cannot load template for List All Forums", e);
        }
    }

    public ListAllForumImpl(GenericRequest request)
        throws AuthenticationException, DatabaseException {

        this.request = request;
        onlineUser = OnlineUserManager.getInstance().getOnlineUser(request);
        permission = onlineUser.getPermission();
        locale = I18nUtil.getLocaleInRequest(request);
        super.init(template);
    }

    public ListAllForumImpl(GenericRequest request,GenericResponse response)
        throws AuthenticationException, DatabaseException {

        this.request = request;
        this.response = response;
        onlineUser = OnlineUserManager.getInstance().getOnlineUser(request);
        permission = onlineUser.getPermission();
        locale = I18nUtil.getLocaleInRequest(request);
        super.init(template);
    }

    public String drawHeader(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        row.put("RowType", "header");
        row.put("urlOfListforums", urlResolver.encodeURL(request, response, "listforums"));

        String title = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.title");
        row.put("title", title);
        rows.add(row);

        return "";
    }

    public String drawFooter(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        row.put("RowType", "footer");

        boolean checkNoCategory = (event.getDepth() == 0);
        row.put("checkNoCategory", checkNoCategory);

        if (checkNoCategory) {
            String no_category = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.no_category");
            row.put("no_category", no_category);
        }
        rows.add(row);

        return "";
    }

    public String drawForum(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        ForumBean forum = (ForumBean) event.getSource();
        String listThreadsLink = urlResolver.encodeURL(request, response, "listthreads?forum=" + forum.getForumID());

        row.put("ForumName", forum.getForumName());
        row.put("ListThreadsLink", listThreadsLink);
        row.put("CanReadPost", permission.canReadPost(forum.getForumID()));
        row.put("NotDisabled", forum.getForumStatus() !=  ForumBean.FORUM_STATUS_DISABLED);
        row.put("RowType", "Forum");

        rows.add(row);

        return "";
     }

    public String drawSeparator(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        CategoryBean category = (CategoryBean) event.getSource();

        row.put("RowType", "Separator");
        row.put("CategoryId", String.valueOf(category.getCategoryID()));

        rows.add(row);

        return "";
    }

    public void setDepthTree(int depth) {
        // default
    }

    public String drawCategory(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();
        boolean check_count = (count != 0);

        row.put("check_count", check_count);

        if (count!=0) {
            flag = true;
        }
        count++;

        row.put("flag", flag);

        CategoryBean category = (CategoryBean)event.getSource();
        row.put("RowType", "Category");
        row.put("CanViewForums", MyUtil.canViewAnyForumInCategory(category.getCategoryID(), permission));

        StringBuffer id1_buffer = new StringBuffer();
        id1_buffer.append("category_").append(category.getCategoryID());
        row.put("id1", id1_buffer.toString());

        row.put("ListForumsLink", urlResolver.encodeURL(request, response, "listforums?category=" + category.getCategoryID()));
        row.put("CategoryName", category.getCategoryName());
        row.put("CategoryId", String.valueOf(category.getCategoryID()));
        row.put("ContextPath", request.getContextPath());

        rows.add(row);

        return "";//default
    }

}
