/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/categorytree/impl/CategoryTreeListenerImpl.java,v 1.28 2008/01/02 10:14:43 tbtrung Exp $
 * $Author: tbtrung $
 * $Revision: 1.28 $
 * $Date: 2008/01/02 10:14:43 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong Pham Dinh Duy
 */
package com.mvnforum.categorytree.impl;

import java.io.IOException;
import java.util.Locale;

import net.myvietnam.mvncore.exception.DatabaseException;
import net.myvietnam.mvncore.service.MvnCoreServiceFactory;
import net.myvietnam.mvncore.service.URLResolverService;
import net.myvietnam.mvncore.util.I18nUtil;
import net.myvietnam.mvncore.web.GenericRequest;
import net.myvietnam.mvncore.web.GenericResponse;

import com.mvnforum.*;
import com.mvnforum.auth.*;
import com.mvnforum.categorytree.CategoryTreeEvent;
import com.mvnforum.db.CategoryBean;
import com.mvnforum.db.ForumBean;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.*;

public class CategoryTreeListenerImpl extends FtlCategoryTreeListener {

    private GenericRequest request;
    private GenericResponse response;

    private OnlineUser onlineUser;
    private MVNForumPermission permission;
    private static URLResolverService urlResolver = MvnCoreServiceFactory.getMvnCoreService().getURLResolverService();

    private static Template template;

    private boolean flag = false;
    private Locale locale;

    private boolean hasReadActiveCurrentForum        = false;
    private boolean hasUnreadActiveCurrentForum      = false;
    private boolean hasReadClosedCurrentForum        = false;
    private boolean hasUnreadClosedCurrentForum      = false;
    private boolean hasReadLockedCurrentForum        = false;
    private boolean hasUnreadLockedCurrentForum      = false;
    private boolean hasReadDisabledCurrentForum      = false;
    private boolean hasUnreadDisabledCurrentForum    = false;

    static {
        // we want to load template only once but process more times
        try {
            Configuration conf = new Configuration();
            TemplateLoader loader = new ClassTemplateLoader(CategoryTreeListenerImpl.class);
            conf.setTemplateLoader(loader);
            template = conf.getTemplate("forummanagement.ftl");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CategoryTreeListenerImpl(GenericRequest request, GenericResponse response)
        throws AuthenticationException, DatabaseException {
        this.request = request;
        this.response = response;
        onlineUser = OnlineUserManager.getInstance().getOnlineUser(request);
        permission = onlineUser.getPermission();
        locale = I18nUtil.getLocaleInRequest(request);
        init(template);
    }

    public String drawHeader(CategoryTreeEvent event) {
        SimpleHash subRoot = new SimpleHash();

        subRoot.put("RowType", "header");

        String name_desc = MVNForumResourceBundle.getString(locale, "mvnforum.common.forum.name_desc");
        subRoot.put("name_desc", name_desc);

        String order = MVNForumResourceBundle.getString(locale, "mvnforum.common.order");
        subRoot.put("order", order);

        String creation_date = MVNForumResourceBundle.getString(locale, "mvnforum.common.forum.create_date");
        subRoot.put("creation_date", creation_date);

        String type = MVNForumResourceBundle.getString(locale, "mvnforum.common.forum.type");
        subRoot.put("type", type);

        String mode_moderation = MVNForumResourceBundle.getString(locale, "mvnforum.common.forum.moderation_mode");
        subRoot.put("mode_moderation", mode_moderation);

        String add = MVNForumResourceBundle.getString(locale, "mvnforum.common.action.add");
        subRoot.put("add", add);

        String group_permission = MVNForumResourceBundle.getString(locale, "mvnforum.common.permission.group_permission");
        subRoot.put("group_permission", group_permission);

        String member_permission = MVNForumResourceBundle.getString(locale, "mvnforum.common.permission.member_permission");
        subRoot.put("member_permission", member_permission);

        String edit = MVNForumResourceBundle.getString(locale, "mvnforum.common.action.edit");
        subRoot.put("edit", edit);

        String delete = MVNForumResourceBundle.getString(locale, "mvnforum.common.action.delete");
        subRoot.put("delete", delete);

        rows.add(subRoot);

        return "";
    }

    public String drawFooter(CategoryTreeEvent event) {

        SimpleHash row = new SimpleHash();

        boolean checkNoCategory = (event.getDepth() == 0);
        row.put("checkNoCategory", checkNoCategory);
        if (checkNoCategory) {
            String no_category = MVNForumResourceBundle.getString(locale, "mvnforum.user.listforums.table.no_category");
            row.put("no_category", no_category);
        }

        row.put("ContextPath", request.getContextPath());
        row.put("hasReadActiveCurrentForum", hasReadActiveCurrentForum);
        row.put("hasUnreadActiveCurrentForum", hasUnreadActiveCurrentForum);
        row.put("hasReadClosedCurrentForum", hasReadClosedCurrentForum);
        row.put("hasUnreadClosedCurrentForum", hasUnreadClosedCurrentForum);
        row.put("hasReadLockedCurrentForum", hasReadLockedCurrentForum);
        row.put("hasUnreadLockedCurrentForum", hasUnreadLockedCurrentForum);
        row.put("hasReadDisabledCurrentForum", hasReadDisabledCurrentForum);
        row.put("hasUnreadDisabledCurrentForum", hasUnreadDisabledCurrentForum);

        if (hasReadActiveCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_active");
            row.put("no_new", no_new);
        }
        if (hasUnreadActiveCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_active");
            row.put("has_new", has_new);
        }
        if (hasReadClosedCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_closed");
            row.put("closed_no_new", no_new);
        }
        if (hasUnreadClosedCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_closed");
            row.put("closed_has_new", has_new);
        }
        if (hasReadLockedCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_locked");
            row.put("locked_no_new", no_new);
        }
        if (hasUnreadLockedCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_locked");
            row.put("locked_has_new", has_new);
        }
        if (hasReadDisabledCurrentForum) {
            String no_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.read_disabled");
            row.put("disabled_no_new", no_new);
        }
        if (hasUnreadDisabledCurrentForum) {
            String has_new = MVNForumResourceBundle.getString(locale, "mvnforum.common.legend.forum.unread_disabled");
            row.put("disabled_has_new", has_new);
        }

        row.put("RowType", "footer");
        rows.add(row);

        return "";
    }

    public String drawCategory(CategoryTreeEvent event) {
        SimpleHash subRoot = new SimpleHash();
        CategoryBean category = (CategoryBean)event.getSource();
        if (event.hasForum()) {
            flag = true;
        }

        String no_forum_in_category = MVNForumResourceBundle.getString(locale, "mvnforum.admin.forummanagement.no_forum");
        subRoot.put("no_forum_in_category", no_forum_in_category);

        subRoot.put("flag", flag);
        subRoot.put("CatName", category.getCategoryName());
        subRoot.put("ContextPath", request.getContextPath());
        subRoot.put("CatOrder", new Integer(category.getCategoryOrder()));

        String filteredCategoryDesc = MyUtil.filter(category.getCategoryDesc(), false/*html*/, true/*emotion*/, true/*mvnCode*/, true/*newLine*/, true/*URL*/);
        subRoot.put("FilteredCatDesc", filteredCategoryDesc);

        String catUpLink = urlResolver.encodeURL(request, response, "updatecategoryorder?category=" + category.getCategoryID() + "&amp;action=up", URLResolverService.ACTION_URL);
        subRoot.put("CatUpLink", catUpLink);

        String catDownLink = urlResolver.encodeURL(request, response, "updatecategoryorder?category=" + category.getCategoryID() + "&amp;action=down", URLResolverService.ACTION_URL);
        subRoot.put("CatDownLink", catDownLink);

        subRoot.put("moveUp", MVNForumResourceBundle.getString(locale, "mvnforum.common.order.move_up"));
        subRoot.put("moveDown", MVNForumResourceBundle.getString(locale, "mvnforum.common.order.move_down"));

        String gmtCatCreationDate = onlineUser.getGMTTimestampFormat(category.getCategoryCreationDate());
        subRoot.put("GMTCatCreationDate", gmtCatCreationDate);

        String add_forum = MVNForumResourceBundle.getString(locale, "mvnforum.admin.addforum.title");
        subRoot.put("add_forum", add_forum);

        subRoot.put("CanAddForum", permission.canAddForum());
        subRoot.put("CanEditCat", permission.canEditCategory());

        boolean CanDeleteCat = !(event.hasForum() || event.hasSubCategory()) && permission.canDeleteCategory();
        subRoot.put("CanDeleteCat", CanDeleteCat);

        StringBuffer deleteCathref = new StringBuffer();
        deleteCathref.append(urlResolver.encodeURL(request, response, "deletecategory?category=" + category.getCategoryID()));
        subRoot.put("deleteCathref", deleteCathref.toString());

        String addForumLink = urlResolver.encodeURL(request, response, "addforum?category=" + category.getCategoryID());
        subRoot.put("AddForumLink", addForumLink);

        String editCatLink = urlResolver.encodeURL(request, response, "editcategory?category=" + category.getCategoryID());
        subRoot.put("EditCatLink", editCatLink);

        String delete = MVNForumResourceBundle.getString(locale, "mvnforum.common.action.delete");
        subRoot.put("delete", delete);

        subRoot.put("RowType", "Category");

        rows.add(subRoot);
        flag = false;

        return "";
    }

    public String drawForum(CategoryTreeEvent event) {

        SimpleHash subRoot = new SimpleHash();

        ForumBean forum = (ForumBean) event.getSource();
        subRoot.put("ContextPath", request.getContextPath());
        subRoot.put("Disabled", (forum.getForumStatus() == ForumBean.FORUM_STATUS_DISABLED));
        subRoot.put("ForumName", forum.getForumName());

        String forumIcon = MyUtil.getForumIconName(onlineUser.getLastLogonTimestamp().getTime(), forum.getForumLastPostDate().getTime(), forum.getForumStatus(), forum.getForumThreadCount());
        subRoot.put("forumIcon", forumIcon);

        if (forumIcon.equals(MyUtil.FORUM_ICON_READ_ACTIVE)) {
            hasReadActiveCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_ACTIVE)) {
            hasUnreadActiveCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_READ_CLOSED)) {
            hasReadClosedCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_CLOSED)) {
            hasUnreadClosedCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_READ_LOCKED)) {
            hasReadLockedCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_LOCKED)) {
            hasUnreadLockedCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_READ_DISABLED)) {
            hasReadDisabledCurrentForum = true;
        } else if (forumIcon.equals(MyUtil.FORUM_ICON_UNREAD_DISABLED)) {
            hasUnreadDisabledCurrentForum = true;
        }

        String filteredForumDesc = MyUtil.filter(forum.getForumDesc(), false/*html*/, true/*emotion*/, true/*mvnCode*/, true/*newLine*/, true/*URL*/);
        subRoot.put("FilteredForumDesc", filteredForumDesc);
        subRoot.put("ForumOrder", new Integer(forum.getForumOrder()));

        String gmtForumCreationDate = onlineUser.getGMTTimestampFormat(forum.getForumCreationDate());
        subRoot.put("GMTForumCreationDate", gmtForumCreationDate);
        subRoot.put("ForumTypeName", LocaleMessageUtil.getForumTypeDescFromInt(onlineUser.getLocale(), forum.getForumType()));
        subRoot.put("ForumModeName", LocaleMessageUtil.getForumModeDescFromInt(onlineUser.getLocale(), forum.getForumModerationMode()));
        subRoot.put("CanEditForum", permission.canEditForum(forum.getForumID()));
        subRoot.put("CanAssignForum", permission.canAssignToForum(forum.getForumID()));
        subRoot.put("CanDeleteForum", permission.canDeleteForum(forum.getForumID()));
        subRoot.put("CanReadPost", permission.canReadPost(forum.getForumID()));

        String forumUpLink = urlResolver.encodeURL(request, response, "updateforumorder?forum=" + forum.getForumID() + "&action=up", URLResolverService.ACTION_URL);
        subRoot.put("ForumUpLink", forumUpLink);

        String forumDownLink = urlResolver.encodeURL(request, response, "updateforumorder?forum=" + forum.getForumID() + "&action=down", URLResolverService.ACTION_URL);
        subRoot.put("ForumDownLink", forumDownLink);

        String groupAssignLink = urlResolver.encodeURL(request, response, "assigngrouptoforum?forum=" + forum.getForumID());
        subRoot.put("GroupAssignLink", groupAssignLink);

        String memberAssignLink = urlResolver.encodeURL(request, response, "assignmembertoforum?forum=" + forum.getForumID());
        subRoot.put("MemberAssignLink", memberAssignLink);

        String editForumLink = urlResolver.encodeURL(request, response, "editforum?forum=" + forum.getForumID());
        subRoot.put("EditForumLink", editForumLink);

        String deleteForumLink = urlResolver.encodeURL(request, response, "deleteforum?forum=" + forum.getForumID());
        subRoot.put("DeleteForumLink", deleteForumLink);

        String delete = MVNForumResourceBundle.getString(locale, "mvnforum.common.action.delete");
        subRoot.put("delete", delete);

        subRoot.put("RowType", "Forum");

        rows.add(subRoot);

        return "";
    }

    public String drawSeparator(CategoryTreeEvent event) {
        return "";
    }

    public void setDepthTree(int depth) {
        //this.depth = depth;
    }
}
