/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/categorytree/DefaultCategoryBuilder.java,v 1.5 2007/12/17 09:09:42 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.5 $
 * $Date: 2007/12/17 09:09:42 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phuong Pham Dinh Duy
 */
package com.mvnforum.categorytree;

import java.util.*;

import net.myvietnam.mvncore.exception.DatabaseException;

import com.mvnforum.db.*;

public class DefaultCategoryBuilder extends CategoryBuilder {

    public DefaultCategoryBuilder() throws DatabaseException {
        //call CategoryBuilder constructor
    }

    public void drawBody() {
        //draw category tree
        if (root != null) {
            recursive(tree, root, 0, "/");
        } else {
            Collection topCategories = getTopCategories();
            for (Iterator iter = topCategories.iterator(); iter.hasNext();) {
                CategoryBean category = (CategoryBean) iter.next();
                recursive(tree, category, 0, "/");
            }
        }

    }

    private void recursive(StringBuffer html, CategoryBean category, int level, String parentPrefix) {

        String prefix = "";
        Collection children = this.getChildrenByCategoryId(category.getCategoryID());
        Collection forumChildren = this.getForumsByCategoryId(category.getCategoryID());

        prefix = parentPrefix + "/" + category.getCategoryID();
        if (rootID == category.getCategoryID()) {
            ID = prefix;
        }

        CategoryTreeEvent event = new CategoryTreeEvent(category);
        event.setHasSubCategory(children.isEmpty() == false);
        event.setDepth(this.depth);
        event.setLevel(level);
        event.setIdsPath(prefix);
        event.setHasForum(forumChildren.isEmpty() == false);
        html.append(listener.drawCategory(event));

        for (Iterator iterator = forumChildren.iterator(); iterator.hasNext(); ) {
            CategoryTreeEvent e = new CategoryTreeEvent(iterator.next());
            e.setDepth(this.depth);
            e.setLevel(level);
            e.setIdsPath(prefix);
            html.append(listener.drawForum(e));
        }

        for (Iterator iterator = children.iterator(); iterator.hasNext(); ) {
            recursive(html, (CategoryBean) iterator.next(), level + 1, prefix);
        }
    }

}
