/*
 * $Header: /cvsroot/mvnforum/myvietnam/src/net/myvietnam/mvncore/util/StringUtil.java,v 1.43 2007/10/24 07:20:03 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.43 $
 * $Date: 2007/10/24 07:20:03 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding MyVietnam and MyVietnam CoreLib
 * MUST remain intact in the scripts and source code.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Minh Nguyen  
 * @author: Mai  Nguyen  
 */
package net.myvietnam.mvncore.util;

import java.util.*;

import net.myvietnam.mvncore.exception.BadInputException;
import net.myvietnam.mvncore.filter.DisableHtmlTagFilter;
import net.myvietnam.mvncore.service.EncoderService;
import net.myvietnam.mvncore.service.MvnCoreServiceFactory;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @todo:  add option for SHORT_STRING_LENGTH
 */
public final class StringUtil {

    private static Log log = LogFactory.getLog(StringUtil.class);

    private static final int SHORT_STRING_LENGTH = 100;

    private StringUtil() {//prevent instantiation
    }

    /**
     * This method trim the input variable, so if it contains only spaces,
     * then it will be empty string, then we have 0 token :-)
     * The returned value is never null. If the input String is null, an
     * empty String array will be returned
     * All tokens are trimed before returning
     */
    public static String[] getStringArray(String inputValue, String delim) {
        if (inputValue == null) inputValue = "";
        inputValue = inputValue.trim();// very important
        java.util.StringTokenizer t = new java.util.StringTokenizer(inputValue, delim);
        String[] ret = new String[t.countTokens()];
        int index = 0;
        while(t.hasMoreTokens()) {
            String token = t.nextToken().trim();
            // check for valid value here if needed
            ret[index] = token;
            index++;
        }
        return ret;
    }

    public static String[] getStringArrays(String to, String cc, String bcc, String delim) {
        String[] toMail = getStringArray(to, delim);
        String[] ccMail = getStringArray(cc, delim);
        String[] bccMail= getStringArray(bcc, delim);
        String[] ret = new String[toMail.length + ccMail.length + bccMail.length];
        int index = 0;
        for (int i = 0 ; i < toMail.length; i++) {
            ret[index] = toMail[i];
            index++;
        }
        for (int i = 0; i < ccMail.length; i++) {
            ret[index] = ccMail[i];
            index++;
        }
        for (int i = 0; i < bccMail.length; i++) {
            ret[index] = bccMail[i];
            index++;
        }
        return ret;
    }

    public static String[] getDiffStringArrays(String to, String cc, String bcc, String delim) {
        String[] toMail = getStringArray(to, delim);
        String[] ccMail = getStringArray(cc, delim);
        String[] bccMail= getStringArray(bcc, delim);
        //String[] ret = new String[t.countTokens()];
        Set set = new HashSet();
        //int index = 0;
        for (int i = 0 ; i < toMail.length; i++) {
            set.add(toMail[i]);
        }
        for (int i = 0; i < ccMail.length; i++) {
            set.add(ccMail[i]);
        }
        for (int i = 0; i < bccMail.length; i++) {
            set.add(bccMail[i]);
        }
        return (String[])set.toArray(new String[0]);
    }

    public static String getEmptyStringIfNull(String str) {
        if (str == null) return "";
        return str;
    }

    /**
     * This method accepts name with char, number or '_' or '.'
     * <p>
     * This method should be used to check all LoginName input from user for security.
     * @todo: use StringBuffer
     */
    public static void checkGoodName(String str) throws BadInputException {
        int length = str.length();
        char c = 0;

        for (int i = 0; i < length; i++) {
            c = str.charAt(i);
            if ((c >= 'a') && (c <= 'z')) {
                // lower char
            } else if ((c >= 'A') && (c <= 'Z')) {
                // upper char
            } else if ((c >= '0') && (c <= '9')/* && (i != 0)*/) {
                // minhnn: as of 31 Jan 2004, i relax the LoginName checking
                // so that the LoginName can start with an numeric char
                // hopefully it does not introduce a security bug
                // because this value will be inserted into sql script

                // numeric char
            } else if (((c == '_') || (c == '.') || (c == '@')) && (i != 0)) {
                // minhnn: as of 12 Jan 2005, i relax the LoginName checking
                // so that it can have '@' because manyone use email as a LoginName

                // _ char

            // If you need to allow non-ASCII chars, please uncomment the below "else if"
            // However, this is not recommended since there will be potential security
            //} else if (c >= 0x80) {
                // by huxn allow NON-ASCII char
            } else {
                // not good char, throw an BadInputException
                //@todo : localize me
                throw new BadInputException("The string '" + DisableHtmlTagFilter.filter(str) + "' is not a good name. Reason: character '" + c + "' is not allowed.");
            }
        }// for
    }

    /**
     * Get the shorter string, the max length is defined as SHORT_STRING_LENGTH
     * @param str String the input string
     * @return String the sorter string, with the max length = SHORT_STRING_LENGTH
     */
    public static String getShorterString(String str) {
        return getShorterString(str, SHORT_STRING_LENGTH);
    }

    /**
     * Get the shorter string, the current implementation check the
     * last occurrence of Character.isWhitespace(currentChar) as the break
     * @param str String the input string
     * @param maxLength int the max length of the shorter string
     * @return String the string after being making shorter
     */
    public static String getShorterString(String str, int maxLength) {

        if (maxLength < 0) throw new IllegalArgumentException("The maxLength < 0 is not allowed.");
        if (str == null) {
            return "";
        }
        if (str.length() <= maxLength) {
            return str;
        }
        String s = str.substring(0, maxLength);
        char currentChar;
        int index;
        for (index = s.length() - 1; index >= 0; index--) {
            currentChar = s.charAt(index);
            if (Character.isWhitespace(currentChar)) {
                break;
            }
        }
        String shortString = s.substring(0, index + 1);
        return shortString + "...";
    }

    /**
     * Get the shorter string, this is the old implementation before 4 Otc, 2004.
     * This implementation does not check the space as the break one.
     * @param str String the input string
     * @param maxLength int the max length of the shorter string
     * @return String the string after being making shorter
     */
    public static String getShorterStringIgnoreSpace(String str, int maxLength) {
        if (maxLength < 0) throw new IllegalArgumentException("The maxLength < 0 is not allowed.");
        if (str == null) return "";
        if (str.length() <= maxLength) return str;
        return str.substring(0, maxLength) + "...";
    }

    /**
     * Replace the occured char to a String
     * @param input String the input string
     * @param from char the char that is used to search
     * @param to String the string that will replace the char
     * @return String the string after being replaced
     */
    public static String replace(String input, char from, String to) {
        if (input == null) {
            return null;
        }

        char[] s = input.toCharArray();
        int length = s.length;
        StringBuffer ret = new StringBuffer(length * 2);

        for (int i = 0; i < length; i++) {
            if (s[i] == from) {
                ret.append(to);
            } else {
                ret.append(s[i]);
            }
        }// for
        return ret.toString();
    }

    /**
     * This method can be replaced by getStringArray
     */
    public static Collection getSeparateString(String strContent, String pattern) {
        int beginIndex = 0;
        Collection coResult = new ArrayList();
        String result;
        int position = strContent.indexOf(pattern, beginIndex); // Get the first position
        while (position != -1) {
            result = strContent.substring(beginIndex, position);
            if (!result.trim().equals("")) {
                coResult.add(result);
            }
            beginIndex = position + pattern.length(); //we add the length of the partern such as ';'
            position = strContent.indexOf(pattern, beginIndex);
        }

        return coResult;
    }

    /**
     * Convert a password to a hidden format, usually the asterisk character is used,
     * such as 'secret' is converted to '******'
     *
     * @param password String the input password that need to convert to hidden format
     * @return String the password after being converted to the hidden format
     */
    public static String getHiddenPassword(String password) {
        password = getEmptyStringIfNull(password);
        int length = password.length();
        if (length == 0) return password;
        StringBuffer hiddenPassword = new StringBuffer(length);
        for (int i = 0; i < length; i++) {
            hiddenPassword.append('*');
        }
        return hiddenPassword.toString();
    }
    
    //fix bug for pluto 1.1
    public static String escapeBackSlash(String str) {
        if (str == null) {
            return null;
        }
        //I didn't use 0x92 because pluto will use 0x9 as # , see PortalURLParserImpl
        return str.replaceAll("\\\\", "0y92");
    }
    
    //fix bug for pluto 1.1
    public static String unEscapeBackSlash(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("0y92", "\\\\");
    }
    
    public static String escapeQuote(String input) {
        input = StringEscapeUtils.escapeJavaScript(input);
        char[] chars = input.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for ( int i = 0 ; i < chars.length; i ++ ) {
//            if (isQuote(chars[i])) {
//                buffer.append('\\').append('"'); // append "\'"
//            } else if (chars[i] == '\n' || chars[i] == '\r') {
//                // do nothing
//            } else if (chars[i] == '\\') {
//                buffer.append('\\').append('\\'); // append "\'"
//            } else
            if ( i + 5 < chars.length && // find '&apos;' ~ single quote
                        chars[i] == '&' &&
                        chars[i + 1] == 'a' &&
                        chars[i + 2] == 'p' &&
                        chars[i + 3] == 'o' &&
                        chars[i + 4] == 's' &&
                        chars[i + 5] == ';') {
                buffer.append('\\').append('\'');
                i += 5;
                // do nothing
            } else if ( i + 4 < chars.length && // find '&#39;' ~ single quote
                    chars[i] == '&' &&
                    chars[i + 1] == '#' &&
                    chars[i + 2] == '3' &&
                    chars[i + 3] == '9' &&
                    chars[i + 4] == ';') {
                buffer.append('\\').append('\'');
                i += 4;
            } else {
                buffer.append(chars[i]);
            }
        }

        String result = DisableHtmlTagFilter.filter(buffer.toString());
        return result;
    }
    
    public static String displayMediaContent(String url, int width, int height) {
        
        EncoderService encoderService = MvnCoreServiceFactory.getMvnCoreService().getEncoderService();
        
        if ("".equals(url) || url == null) {
            return "";
        }
        
        url = encoderService.filterUrl(url);
        String result = "";
        String size = "";
        if (width > 0) {
            size += " width='" + width + "'";
        }
        if (height > 0) {
            size += " height='" + height + "'";
        }
        
        String lowerURL = url.toLowerCase();
        
        if (lowerURL.endsWith(".swf")) {
            result = "<embed src='" + url + "' quality='high' scale='noborder' wmode='transparent'" 
            + " bgcolor='#000000'" + size + " type='application/x-shockwave-flash'"
            + " pluginspage='http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash'></embed>";
        } else if (lowerURL.endsWith(".jpeg") || lowerURL.endsWith(".jpg") || lowerURL.endsWith(".png") || lowerURL.endsWith(".gif")) {
            result = "<img src='" + url + "'" + size + " border='0' alt=''>";
        } else if (lowerURL.endsWith(".mov")) {
            result = "<OBJECT classid='clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B'" + size + " codebase='http://www.apple.com/qtactivex/qtplugin.cab'><param name='src' value='" + url + "'><param name='autoplay' value='true'><param name='controller' value='false'><param name='loop' value='true'><EMBED src='" + url + "' width='320' height='255' autoplay='true' controller='false' loop='true' pluginspage='http://www.apple.com/quicktime/download/'></EMBED></OBJECT>";
        } else if (lowerURL.endsWith(".mpg") || lowerURL.endsWith(".wmv") || lowerURL.endsWith(".avi")) {
            result = "<embed src='" + url + "'" + size + " EnableContextMenu='0' AutoStart='1' loop='1' ShowStatusBar='0' ShowControls='0'></embed>";
        } else {
            result = "";
        }
        
        return result;
    }

    // for test only
    public static void main(String[] args) throws Exception {
        //String[] s = getStringArray("  fasg;,   zdgsag, ,,", ",");
//        String[] s = getStringArray("  fasg  ", ",");
//        System.out.println("length = " + s.length);
//        for (int i = 0; i < s.length; i++) {
//            System.out.println("" + i + " : " + s[i]);
//        }

        String s1 = "   abc das\n\n\n\n\ndasd    asd   adad   as   das   as   da    adas        da     sd    ad  as  sa  das  das   d a            .";
        System.out.println("r = [" + StringUtil.getShorterString(s1, 22) + "]");
    }    

    public static int parseIntSizeValue(String propertyValue, int defaultValue) {

        try {
            String temp = propertyValue.trim();
            if (temp.endsWith("B") || temp.endsWith("b")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            switch (temp.charAt(temp.length()-1)) {
                case 'K': case 'k':
                    //examples (ending 'B' was cut before): "1K", "1KB", "1k", "1kB", "1 K", "1 KB", "1 k", "1 kB"
                    return 1024 * Integer.parseInt(temp.substring(0, temp.length() - 1).trim());
                case 'M': case 'm':
                    //examples (ending 'B' was cut before): "1M", "1MB", "1m", "1mB", "1 M", "1 MB", "1 m", "1 mB"
                    return 1024 * 1024 * Integer.parseInt(temp.substring(0, temp.length() - 1).trim());
                default:
                    //examples (ending 'B' was cut before): "1", "1B", "1 B"
                    return Integer.parseInt(temp.trim());
            }
        } catch (Exception e) {
            log.warn("Error while parsing the value " + propertyValue, e);
            return defaultValue;
        }

    }

}
