/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/user/MailWebHandler.java,v 1.27 2008/01/15 09:22:00 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.27 $
 * $Date: 2008/01/15 09:22:00 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Hau Nguyen
 */
package com.mvnforum.user;

import java.io.UnsupportedEncodingException;
import java.util.Locale;

import javax.mail.MessagingException;

import net.myvietnam.mvncore.exception.*;
import net.myvietnam.mvncore.security.SecurityUtil;
import net.myvietnam.mvncore.util.*;
import net.myvietnam.mvncore.web.GenericRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.mvnforum.MVNForumConfig;
import com.mvnforum.MVNForumResourceBundle;
import com.mvnforum.auth.*;
import com.mvnforum.db.MemberCache;

public class MailWebHandler {

    private static Log log = LogFactory.getLog(MailWebHandler.class);

    private OnlineUserManager onlineUserManager = OnlineUserManager.getInstance();

    public void prepareSendMail(GenericRequest request)
        throws BadInputException, ObjectNotFoundException, DatabaseException, AuthenticationException {

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureIsAuthenticated();

        //boolean preview = GenericParamUtil.getParameterBoolean(request, "preview");

        // from
        int fromID = onlineUser.getMemberID();
        String fromEmail = MemberCache.getInstance().getMember(fromID).getMemberEmail();
        request.setAttribute("FromEmail", fromEmail);

        // subject
        String subject = GenericParamUtil.getParameterFilter(request, "Subject");
        request.setAttribute("Subject", subject);

        // message
        String message = GenericParamUtil.getParameterFilter(request, "Message");
        request.setAttribute("Message", message);

        // to
        String toMember = "";
        boolean emailToAdmin = GenericParamUtil.getParameterBoolean(request, "ToAdmin");
        if (emailToAdmin == false) {
            toMember = GenericParamUtil.getParameterFilter(request, "ToMember", true);
            try {
                MemberCache.getInstance().getMemberIDFromMemberName(toMember);
            } catch(ObjectNotFoundException e) {
                Locale locale = I18nUtil.getLocaleInRequest(request);
                String localizedMessage = MVNForumResourceBundle.getString(locale, "mvncore.exception.ObjectNotFoundException.membername_not_exists", new Object[] {toMember});
                throw new ObjectNotFoundException(localizedMessage);
            }
        }
        request.setAttribute("ToAdmin", emailToAdmin ? "true" : "");
        request.setAttribute("ToMember", toMember);

    }

    public void sendEmailProcess(GenericRequest request)
        throws AuthenticationException, DatabaseException, BadInputException, MessagingException, ObjectNotFoundException {

        SecurityUtil.checkHttpPostMethod(request);

        OnlineUser onlineUser = onlineUserManager.getOnlineUser(request);
        MVNForumPermission permission = onlineUser.getPermission();
        permission.ensureIsAuthenticated();

        int fromID = onlineUser.getMemberID();
        String from = MemberCache.getInstance().getMember(fromID).getMemberEmail();

        String subject = GenericParamUtil.getParameter(request, "Subject", true);
        String message = GenericParamUtil.getParameter(request, "Message", true);

        String to = null;
        boolean emailToAdmin = GenericParamUtil.getParameterBoolean(request, "ToAdmin");
        if (emailToAdmin == false) {
            String toMember = GenericParamUtil.getParameterFilter(request, "ToMember", true);
            int toID = MemberCache.getInstance().getMemberIDFromMemberName(toMember);
            to = MemberCache.getInstance().getMember(toID).getMemberEmail();
        } else {
            to = MVNForumConfig.getWebMasterEmail();
        }
        if (to.length() == 0) {
            Locale locale = I18nUtil.getLocaleInRequest(request);
            String localizedMessage = MVNForumResourceBundle.getString(locale, "mvncore.exception.BadInputException.please_enter_to_or_cc_or_bcc");
            throw new BadInputException(localizedMessage);
        }

        MailMessageStruct mailMessageStruct = new MailMessageStruct();
        mailMessageStruct.setFrom(from);
        mailMessageStruct.setTo(to);
        mailMessageStruct.setSubject(subject);
        mailMessageStruct.setMessage(message);

        try {
            MailUtil.sendMail(mailMessageStruct);
        } catch (UnsupportedEncodingException e) {
            log.error("Cannot support encoding", e);
        }

    }

}
