/*
 * $Header: /cvsroot/mvnforum/mvnforum/src/com/mvnforum/service/impl/SearchServiceImplDisk.java,v 1.13 2007/11/09 10:38:27 minhnn Exp $
 * $Author: minhnn $
 * $Revision: 1.13 $
 * $Date: 2007/11/09 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright (C) 2002-2007 by MyVietnam.net
 *
 * All copyright notices regarding mvnForum MUST remain
 * intact in the scripts and in the outputted HTML.
 * The "powered by" text/logo with a link back to
 * http://www.mvnForum.com and http://www.MyVietnam.net in
 * the footer of the pages MUST remain visible when the pages
 * are viewed on the internet or intranet.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Support can be obtained from support forums at:
 * http://www.mvnForum.com/mvnforum/index
 *
 * Correspondence and Marketing Questions can be sent to:
 * info at MyVietnam net
 *
 * @author: Phong Ta Quoc
 */
package com.mvnforum.service.impl;

import java.io.IOException;

import net.myvietnam.mvncore.util.AssertionUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

import com.mvnforum.MVNForumConfig;
import com.mvnforum.MVNForumGlobal;
import com.mvnforum.service.SearchService;

public class SearchServiceImplDisk implements SearchService {

    private static Log log = LogFactory.getLog(SearchServiceImplDisk.class);

    private boolean failed = false;
    private static int count;

    public SearchServiceImplDisk() {
        count++;
        AssertionUtil.doAssert(count == 1, "Assertion: Must have only one instance.");
       load();
    }

    public void load() {
        log.info("Using Search Service " + this.getClass().getName());
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Directory getSearchPostIndexDir(boolean create) throws IOException {
        return FSDirectory.getDirectory(MVNForumConfig.getSearchPostIndexDirName(), create);
    }

    public Directory getSearchPostIndexDir() throws IOException {
        return getSearchPostIndexDir(false);
    }

    public Directory getSearchMemberIndexDir(boolean create) throws IOException {
        return FSDirectory.getDirectory(MVNForumConfig.getSearchMemberIndexDirName(), create);
    }

    public Directory getSearchMemberIndexDir() throws IOException {
        return getSearchMemberIndexDir(false);
    }

    public Directory getSearchAttachmentIndexDir(boolean create) throws IOException {
        return FSDirectory.getDirectory(MVNForumConfig.getSearchAttachmentIndexDirName(), create);
    }

    public Directory getSearchAttachmentIndexDir() throws IOException {
        return getSearchAttachmentIndexDir(false);
    }

    public Directory getSearchAlbumItemIndexDir() throws IOException {
        return getSearchAlbumItemIndexDir(false);
    }

    public Directory getSearchAlbumItemIndexDir(boolean create) throws IOException {
        return FSDirectory.getDirectory(MVNForumConfig.getSearchAlbumItemIndexDirName(), create);
    }


    public void deleteContent(Directory directory) throws IOException {
        //dont need to implement ???
    }

    public boolean savePostOnDisk() {
        return true;
    }

    public boolean saveAlbumItemOnDisk() {
        return true;
    }


    public boolean saveMemberOnDisk() {
        return true;
    }

    public boolean saveAttachmentOnDisk() {
        return true;
    }

    public int getPostSearchImplType() {
        return MVNForumGlobal.SEARCH_INDEX_TYPE_DISK;
    }

    public int getMemberSearchImplType() {
        return MVNForumGlobal.SEARCH_INDEX_TYPE_DISK;
    }

    public int getAttachmentSearchImplType() {
        return MVNForumGlobal.SEARCH_INDEX_TYPE_DISK;
    }

    public int getAlbumItemSearchImplType() {
        return MVNForumGlobal.SEARCH_INDEX_TYPE_DISK;
    }

    public void clearData() {
    }
}
