/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.NewsAddress;
import org.apache.james.core.MailHeaders;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.util.InternetPrintWriter;
import org.apache.james.util.RFC822DateFormat;

public class MimeMessageWrapper
extends MimeMessage {
    MimeMessageSource source = null;
    MailHeaders headers = null;
    MimeMessage message = null;
    boolean modified = false;
    RFC822DateFormat mailDateFormat = new RFC822DateFormat();

    public MimeMessageWrapper(MimeMessageSource source) {
        super(Session.getDefaultInstance((Properties)System.getProperties(), null));
        this.source = source;
    }

    public String getSourceId() {
        return this.source.getSourceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadHeaders() throws MessagingException {
        if (this.headers != null) {
            return;
        }
        try {
            InputStream in = this.source.getInputStream();
            try {
                this.headers = new MailHeaders(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new MessagingException("Unable to parse headers from stream: " + ioe.getMessage(), (Exception)ioe);
        }
    }

    private synchronized void loadMessage() throws MessagingException {
        if (this.message != null) {
            return;
        }
        InputStream in = null;
        try {
            in = this.source.getInputStream();
            this.headers = new MailHeaders(in);
            ByteArrayInputStream headersIn = new ByteArrayInputStream(this.headers.toByteArray());
            in = new SequenceInputStream(headersIn, in);
            this.message = new MimeMessage(this.session, in);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new MessagingException("Unable to parse stream: " + ioe.getMessage(), (Exception)ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Address[] getAddressHeader(String name) throws MessagingException {
        String addr = this.getHeader(name, ",");
        if (addr == null) {
            return null;
        }
        return InternetAddress.parse((String)addr);
    }

    /*
     * WARNING - void declaration
     */
    private String getHeaderName(Message.RecipientType recipienttype) throws MessagingException {
        void var2_2;
        String s;
        if (recipienttype == Message.RecipientType.TO) {
            s = "To";
        } else if (recipienttype == Message.RecipientType.CC) {
            s = "Cc";
        } else if (recipienttype == Message.RecipientType.BCC) {
            s = "Bcc";
        } else if (recipienttype == MimeMessage.RecipientType.NEWSGROUPS) {
            s = "Newsgroups";
        } else {
            throw new MessagingException("Invalid Recipient Type");
        }
        return var2_2;
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os) throws IOException, MessagingException {
        if (this.message == null || !this.isModified()) {
            InputStream in = this.source.getInputStream();
            try {
                MimeMessageWrapper.copyStream(in, os);
            }
            finally {
                in.close();
            }
        } else {
            this.writeTo(os, os);
        }
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        this.writeTo(os, os, ignoreList);
    }

    public void writeTo(OutputStream headerOs, OutputStream bodyOs) throws IOException, MessagingException {
        this.writeTo(headerOs, bodyOs, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream headerOs, OutputStream bodyOs, String[] ignoreList) throws IOException, MessagingException {
        if (this.message == null || !this.isModified()) {
            InputStream in = this.source.getInputStream();
            try {
                InternetHeaders headers = new InternetHeaders(in);
                InternetPrintWriter pos = new InternetPrintWriter(new BufferedWriter(new OutputStreamWriter(headerOs), 512), true);
                Enumeration e = headers.getNonMatchingHeaderLines(ignoreList);
                while (e.hasMoreElements()) {
                    String header = (String)e.nextElement();
                    ((PrintWriter)pos).println(header);
                }
                ((PrintWriter)pos).println();
                pos.flush();
                MimeMessageWrapper.copyStream(in, bodyOs);
            }
            finally {
                in.close();
            }
        } else {
            MimeMessageWrapper.writeTo(this.message, headerOs, bodyOs, ignoreList);
        }
    }

    public static void writeTo(MimeMessage message, OutputStream headerOs, OutputStream bodyOs) throws IOException, MessagingException {
        MimeMessageWrapper.writeTo(message, headerOs, bodyOs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(MimeMessage message, OutputStream headerOs, OutputStream bodyOs, String[] ignoreList) throws IOException, MessagingException {
        if (message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)message;
            wrapper.writeTo(headerOs, bodyOs, ignoreList);
        } else {
            if (message.getMessageID() == null) {
                message.saveChanges();
            }
            Enumeration headers = message.getNonMatchingHeaderLines(ignoreList);
            InternetPrintWriter hos = new InternetPrintWriter(new BufferedWriter(new OutputStreamWriter(headerOs), 512), true);
            while (headers.hasMoreElements()) {
                ((PrintWriter)hos).println((String)headers.nextElement());
            }
            ((PrintWriter)hos).println();
            hos.flush();
            InputStream bis = null;
            OutputStream bos = null;
            try {
                bos = MimeUtility.encode((OutputStream)bodyOs, (String)message.getEncoding());
                bis = message.getInputStream();
            }
            catch (UnsupportedDataTypeException udte) {
                try {
                    bis = message.getRawInputStream();
                    bos = bodyOs;
                }
                catch (MessagingException _) {
                    throw udte;
                }
            }
            catch (MessagingException me) {
                try {
                    bis = message.getRawInputStream();
                    bos = bodyOs;
                }
                catch (MessagingException _) {
                    throw me;
                }
            }
            try {
                MimeMessageWrapper.copyStream(bis, bos);
            }
            finally {
                bis.close();
            }
        }
    }

    public Address[] getFrom() throws MessagingException {
        Address[] from;
        if (this.headers == null) {
            this.loadHeaders();
        }
        if ((from = this.getAddressHeader("From")) == null) {
            from = this.getAddressHeader("Sender");
        }
        return from;
    }

    public Address[] getRecipients(Message.RecipientType type) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        if (type == MimeMessage.RecipientType.NEWSGROUPS) {
            String s = this.headers.getHeader("Newsgroups", ",");
            if (s == null) {
                return null;
            }
            return NewsAddress.parse((String)s);
        }
        return this.getAddressHeader(this.getHeaderName(type));
    }

    public Address[] getAllRecipients() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        Address[] toAddresses = this.getRecipients(MimeMessage.RecipientType.TO);
        Address[] ccAddresses = this.getRecipients(MimeMessage.RecipientType.CC);
        Address[] bccAddresses = this.getRecipients(MimeMessage.RecipientType.BCC);
        Address[] newsAddresses = this.getRecipients((Message.RecipientType)MimeMessage.RecipientType.NEWSGROUPS);
        if (ccAddresses == null && bccAddresses == null && newsAddresses == null) {
            return toAddresses;
        }
        int i = (toAddresses == null ? 0 : toAddresses.length) + (ccAddresses == null ? 0 : ccAddresses.length) + (bccAddresses == null ? 0 : bccAddresses.length) + (newsAddresses == null ? 0 : newsAddresses.length);
        Address[] allAddresses = new Address[i];
        int j = 0;
        if (toAddresses != null) {
            System.arraycopy(toAddresses, 0, allAddresses, j, toAddresses.length);
            j += toAddresses.length;
        }
        if (ccAddresses != null) {
            System.arraycopy(ccAddresses, 0, allAddresses, j, ccAddresses.length);
            j += ccAddresses.length;
        }
        if (bccAddresses != null) {
            System.arraycopy(bccAddresses, 0, allAddresses, j, bccAddresses.length);
            j += bccAddresses.length;
        }
        if (newsAddresses != null) {
            System.arraycopy(newsAddresses, 0, allAddresses, j, newsAddresses.length);
            j += newsAddresses.length;
        }
        return allAddresses;
    }

    public Address[] getReplyTo() throws MessagingException {
        Address[] replyTo;
        if (this.headers == null) {
            this.loadHeaders();
        }
        if ((replyTo = this.getAddressHeader("Reply-To")) == null) {
            replyTo = this.getFrom();
        }
        return replyTo;
    }

    public String getSubject() throws MessagingException {
        String subject;
        if (this.headers == null) {
            this.loadHeaders();
        }
        if ((subject = this.getHeader("Subject", null)) == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText((String)subject);
        }
        catch (UnsupportedEncodingException _ex) {
            return subject;
        }
    }

    public Date getSentDate() throws MessagingException {
        String header;
        if (this.headers == null) {
            this.loadHeaders();
        }
        if ((header = this.getHeader("Date", null)) != null) {
            try {
                return this.mailDateFormat.parse(header);
            }
            catch (ParseException _ex) {
                return null;
            }
        }
        return null;
    }

    public Date getReceivedDate() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return null;
    }

    public int getSize() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() throws MessagingException {
        InputStream in = null;
        try {
            in = this.getContentStream();
        }
        catch (Exception e) {
            return -1;
        }
        if (in == null) {
            return -1;
        }
        try {
            LineNumberReader counter = new LineNumberReader(new InputStreamReader(in, this.getEncoding()));
            char[] block = new char[4096];
            while (counter.read(block) > -1) {
            }
            int n = counter.getLineNumber();
            return n;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public long getMessageSize() throws MessagingException {
        try {
            return this.source.getMessageSize();
        }
        catch (IOException ioe) {
            throw new MessagingException("Error retrieving message size", (Exception)ioe);
        }
    }

    public String getContentType() throws MessagingException {
        String value;
        if (this.headers == null) {
            this.loadHeaders();
        }
        if ((value = this.getHeader("Content-Type", null)) == null) {
            return "text/plain";
        }
        return value;
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.isMimeType(mimeType);
    }

    public String getDisposition() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getDisposition();
    }

    public String getEncoding() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getEncoding();
    }

    public String getContentID() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.getHeader("Content-Id", null);
    }

    public String getContentMD5() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.getHeader("Content-MD5", null);
    }

    public String getDescription() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getDescription();
    }

    public String[] getContentLanguage() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getContentLanguage();
    }

    public String getMessageID() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.getHeader("Message-ID", null);
    }

    public String getFileName() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getFileName();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        if (this.message == null) {
            this.loadMessage();
            return this.message.getInputStream();
        }
        return this.message.getInputStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getDataHandler();
    }

    public Object getContent() throws IOException, MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getContent();
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name, delimiter);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(names);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public Flags getFlags() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getFlags();
    }

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.isSet(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContentTo(OutputStream outs) throws IOException, MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        InputStream in = this.getContentStream();
        try {
            MimeMessageWrapper.copyStream(in, outs);
        }
        finally {
            in.close();
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] block = new byte[1024];
        int read = 0;
        while ((read = in.read(block)) > -1) {
            out.write(block, 0, read);
        }
        out.flush();
    }

    public void setFrom(Address address) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setFrom(address);
    }

    public void setFrom() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setFrom();
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.addFrom(addresses);
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setRecipients(type, addresses);
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.addRecipients(type, addresses);
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setReplyTo(addresses);
    }

    public void setSubject(String subject) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.headers.setHeader("Subject", subject);
        this.message.setSubject(subject);
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        try {
            this.headers.setHeader("Subject", new String(subject.getBytes(charset)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.message.setSubject(subject, charset);
    }

    public void setSentDate(Date d) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.headers.setHeader("Date", this.mailDateFormat.format(d));
        this.message.setSentDate(d);
    }

    public void setDisposition(String disposition) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setDisposition(disposition);
    }

    public void setContentID(String cid) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setContentID(cid);
    }

    public void setContentMD5(String md5) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setContentMD5(md5);
    }

    public void setDescription(String description) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setDescription(description);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setDescription(description, charset);
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setContentLanguage(languages);
    }

    public void setFileName(String filename) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setFileName(filename);
    }

    public void setDataHandler(DataHandler dh) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setDataHandler(dh);
    }

    public void setContent(Object o, String type) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setContent(o, type);
    }

    public void setText(String text) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setText(text);
    }

    public void setText(String text, String charset) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setText(text, charset);
    }

    public void setContent(Multipart mp) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setContent(mp);
    }

    public Message reply(boolean replyToAll) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        return this.message.reply(replyToAll);
    }

    public void setHeader(String name, String value) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.headers.setHeader(name, value);
        this.message.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.headers.addHeader(name, value);
        this.message.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.headers.removeHeader(name);
        this.message.removeHeader(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.headers.addHeaderLine(line);
        this.message.addHeaderLine(line);
    }

    public void setFlags(Flags flag, boolean set) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setFlags(flag, set);
    }

    public void saveChanges() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.saveChanges();
    }

    public InputStream getRawInputStream() throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        return this.message.getRawInputStream();
    }

    public void addRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.addRecipients(type, addresses);
    }

    public void setRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        if (this.message == null) {
            this.loadMessage();
        }
        this.modified = true;
        this.message.setRecipients(type, addresses);
    }
}

