/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.threadpool;

import org.apache.commons.threadpool.CommonsLoggingThreadPoolMonitor;
import org.apache.commons.threadpool.MTQueue;
import org.apache.commons.threadpool.ThreadPool;
import org.apache.commons.threadpool.ThreadPoolMonitor;

public class DefaultThreadPool
implements Runnable,
ThreadPool {
    private MTQueue queue = new MTQueue();
    private boolean stopped = false;
    private final ThreadPoolMonitor monitor;

    public DefaultThreadPool(ThreadPoolMonitor monitor, int numberOfThreads, int threadPriority) {
        this.monitor = monitor;
        for (int i = 0; i < numberOfThreads; ++i) {
            this.startThread(threadPriority);
        }
    }

    public DefaultThreadPool(ThreadPoolMonitor monitor, int numberOfThreads) {
        this.monitor = monitor;
        for (int i = 0; i < numberOfThreads; ++i) {
            this.startThread();
        }
    }

    public DefaultThreadPool() {
        this.monitor = new CommonsLoggingThreadPoolMonitor();
        this.startThread();
    }

    public DefaultThreadPool(int numberOfThreads) {
        this(new CommonsLoggingThreadPoolMonitor(), numberOfThreads);
    }

    public DefaultThreadPool(int numberOfThreads, int threadPriority) {
        this(new CommonsLoggingThreadPoolMonitor(), numberOfThreads, threadPriority);
    }

    public Thread startThread() {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    public Thread startThread(int priority) {
        Thread thread = new Thread(this);
        thread.setPriority(priority);
        thread.start();
        return thread;
    }

    public void stop() {
        this.stopped = true;
    }

    public int getRunnableCount() {
        return this.queue.size();
    }

    public void invokeLater(Runnable task) {
        this.queue.add(task);
    }

    public void run() {
        while (!this.stopped) {
            Runnable task = (Runnable)this.queue.remove();
            if (task == null) continue;
            try {
                task.run();
            }
            catch (Throwable t) {
                this.monitor.handleThrowable(this.getClass(), task, t);
            }
        }
    }
}

