/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo.processor;

import java.util.Vector;
import org.jzonic.jlo.LogEvent;
import org.jzonic.jlo.LogGenerator;
import org.jzonic.jlo.LogRecord;
import org.jzonic.jlo.processor.LogProcessor;

public class AsynchronousLogProcessor
extends Thread
implements LogProcessor {
    private static Vector events = new Vector();
    private static long counter = 0L;
    private static Thread threadCleanerUpper = null;
    private boolean running = true;
    int milliSecondSleepTime = 500;

    public AsynchronousLogProcessor() {
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        while (this.running) {
            int total = events.size();
            int i = 0;
            while (i < total) {
                LogEvent le = (LogEvent)events.firstElement();
                if (le.getFormatter() != null) {
                    String msg = le.getFormatter().formatMessage(le.getLogRecord());
                    le.getHandler().publish(msg);
                } else {
                    le.getHandler().publish(le.getLogRecord());
                }
                events.remove(le);
                ++i;
            }
            try {
                Thread.sleep(this.milliSecondSleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void processEvent(LogGenerator lg, LogRecord lr) {
        LogEvent le = new LogEvent(lg.getHandler(), lg.getFormatter(), lr);
        events.add(le);
    }

    public void flush() {
        int total = events.size();
        int i = 0;
        while (i < total) {
            LogEvent le = (LogEvent)events.firstElement();
            if (le.getFormatter() != null) {
                String msg = le.getFormatter().formatMessage(le.getLogRecord());
                le.getHandler().publish(msg);
            } else {
                le.getHandler().publish(le.getLogRecord());
            }
            events.remove(le);
            ++i;
        }
    }

    public String getProcessorName() {
        return "AsynchronousLogProcessor";
    }
}

