/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.util.StringTokenizer;

public class Target {
    public static final Target trace = new Target("trace", 1);
    public static final Target info = new Target("info", 2);
    public static final Target debug = new Target("debug", 4);
    public static final Target warn = new Target("warn", 8);
    public static final Target error = new Target("error", 16);
    public static final Target fatal = new Target("fatal", 32);
    public static final Target all = new Target("all", 255);
    private Target target;
    private int value;
    private String targetName;

    protected Target() {
        this.value = all.intValue();
        this.targetName = "all";
    }

    protected Target(String name, int targets) {
        this.value = targets;
        this.targetName = name;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object ox) {
        if (!(ox instanceof Target)) {
            return false;
        }
        Target mytarget = (Target)ox;
        return mytarget.intValue() == this.value && mytarget.getName().equals(this.targetName);
    }

    public int intValue() {
        return this.value;
    }

    public String getName() {
        return this.targetName;
    }

    public static int parse(String line) {
        line = line.toLowerCase();
        int value = 0;
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        while (tokenizer.hasMoreElements()) {
            int targetValue;
            String current = (String)tokenizer.nextElement();
            if (current.equals("all")) {
                value = all.intValue();
                continue;
            }
            if (current.startsWith("!")) {
                targetValue = Target.getTargetByName(current);
                if (targetValue == -1 || (value & targetValue) != targetValue) continue;
                value -= targetValue;
                continue;
            }
            targetValue = Target.getTargetByName(current);
            if (targetValue == -1 || (value & targetValue) != 0) continue;
            value += targetValue;
        }
        return value;
    }

    private static int getTargetByName(String name) {
        if (name.startsWith("!")) {
            name = name.substring(1);
        }
        if (name.equals("trace")) {
            return trace.intValue();
        }
        if (name.equals("info")) {
            return info.intValue();
        }
        if (name.equals("debug")) {
            return debug.intValue();
        }
        if (name.equals("warn")) {
            return warn.intValue();
        }
        if (name.equals("error")) {
            return error.intValue();
        }
        if (name.equals("fatal")) {
            return fatal.intValue();
        }
        return -1;
    }

    public String toString() {
        String retValue = "Target: name=" + this.targetName + " value=" + this.value;
        return retValue;
    }
}

