/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jzonic.jlo.Target;

public class LogRecord {
    private String msg;
    private long logdate;
    private String loggername;
    private String sourceClass = null;
    private String sourceMethod = null;
    private Throwable thrown;
    private Target target;

    public LogRecord(String msg) {
        this(msg, null);
    }

    public LogRecord(String msg, Target target) {
        this.msg = msg;
        this.target = target;
        this.logdate = System.currentTimeMillis();
    }

    public Target getTarget() {
        return this.target;
    }

    public String getLoggerName() {
        return this.loggername;
    }

    public String getMessage() {
        return this.msg;
    }

    public long getMillis() {
        return this.logdate;
    }

    public String getSourceClassName() {
        return this.sourceClass;
    }

    public String getSourceMethodName() {
        return this.sourceMethod;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void setLoggerName(String name) {
        this.loggername = name;
    }

    public void setMessage(String message) {
        this.msg = message;
    }

    public void setMillis(long millis) {
        this.logdate = millis;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClass = sourceClassName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethod = sourceMethodName;
    }

    public void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }

    public String getStackTrace() {
        if (this.thrown != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.thrown.printStackTrace(pw);
            pw.close();
            return sw.getBuffer().toString();
        }
        return "";
    }
}

