/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.util.HashMap;
import org.jzonic.jlo.Channel;
import org.jzonic.jlo.LogGenerator;
import org.jzonic.jlo.Logger;

public class LogConfiguration {
    private String configurationName;
    private HashMap logger = new HashMap();
    private HashMap generator = new HashMap();
    private HashMap channels = new HashMap();

    public LogConfiguration(String configurationName) {
        this.configurationName = configurationName;
    }

    public Channel getChannel(String name) {
        Channel channel = (Channel)this.channels.get(name);
        return channel;
    }

    private String findChannelName(String name) {
        boolean searching = true;
        String myName = name;
        while (searching) {
            if (!this.channels.containsKey(myName)) {
                int pos = myName.lastIndexOf(".");
                if (pos != -1) {
                    myName = myName.substring(0, pos);
                    continue;
                }
                searching = false;
                myName = null;
                continue;
            }
            searching = false;
        }
        return myName;
    }

    public Logger getLogger(String name) {
        String myName = this.findLoggerName(name);
        Logger myLogger = (Logger)this.logger.get(myName);
        return myLogger;
    }

    private String findLoggerName(String name) {
        boolean searching = true;
        String myName = name;
        while (searching) {
            if (!this.logger.containsKey(myName)) {
                int pos = myName.lastIndexOf(".");
                if (pos != -1) {
                    myName = myName.substring(0, pos);
                    continue;
                }
                searching = false;
                myName = null;
                continue;
            }
            searching = false;
        }
        return myName;
    }

    public void addLogger(Logger l) {
        if (l != null && l.getLoggerName() != null) {
            this.logger.put(l.getLoggerName(), l);
        }
    }

    public int getLoggerCount() {
        return this.logger.size();
    }

    public void addLogGenerator(LogGenerator lg) {
        if (lg != null && lg.getName() != null) {
            this.generator.put(lg.getName(), lg);
        }
    }

    public LogGenerator getLogGenerator(String name) {
        return (LogGenerator)this.generator.get(name);
    }

    public int getLogGeneratorCount() {
        return this.generator.size();
    }

    public void addChannel(Channel channel) {
        if (channel != null && channel.getChannelName() != null) {
            this.channels.put(channel.getChannelName(), channel);
        }
    }

    public int getChannelCount() {
        return this.channels.size();
    }

    public String getName() {
        return this.configurationName;
    }
}

