/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MatchResult;

public class FreeMarkerToHtml
implements TemplateTransformModel {
    private Perl5Util cMatcher = null;

    public Writer getWriter(final Writer out, Map args) {
        if (this.cMatcher == null) {
            this.cMatcher = new Perl5Util();
        }
        final StringBuffer buf = new StringBuffer();
        return new Writer(){

            public void write(char[] cbuf, int off, int len) {
                buf.append(cbuf, off, len);
            }

            public void flush() throws IOException {
                out.flush();
            }

            public void close() throws IOException {
                StringWriter sw = new StringWriter();
                FreeMarkerToHtml.this.doFreeMarkerTransformation(buf.toString(), sw);
                out.write(sw.toString());
            }
        };
    }

    private void doFreeMarkerTransformation(String textBuffer, Writer out) throws IOException {
        textBuffer = this.cMatcher.substitute("s/</&lt;/g", textBuffer);
        textBuffer = this.cMatcher.substitute("s/>/&gt;/g", textBuffer);
        out.write("<pre>");
        this.doBlockComment(textBuffer, out);
        out.write("</pre>");
    }

    private void doBlockComment(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/&lt;comment\\b(?:.*?)&lt;\\/comment\\s*&gt;/s", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doFreeMarkerTags(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#008000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doFreeMarkerTags(aInput, out);
    }

    private void doFreeMarkerTags(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/(&lt;(?:list|if|else|elseif|switch|case|break|default|assign|include|function|call|compress|comment|noparse|foreach|transform))\\b(.*?)(&gt;)/s", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doFreeMarkerEndTags(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#0000ff\">");
            out.write(cResult.group(1));
            out.write("</font>");
            this.doDoubleQuotes(cResult.group(2), out);
            out.write("<font color=\"#0000ff\">");
            out.write(cResult.group(3));
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doFreeMarkerEndTags(aInput, out);
    }

    private void doFreeMarkerEndTags(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/(&lt;\\/(?:list|if|switch|function|compress|comment|noparse|foreach|transform))\\s*(&gt;)/s", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doFreeMarkerVariableInstruction(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#0000ff\">");
            out.write(cResult.group(0));
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doFreeMarkerVariableInstruction(aInput, out);
    }

    private void doFreeMarkerVariableInstruction(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/([\\$\\#]\\{)(.*?)(\\})/s", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            out.write(aInput.substring(0, cResult.beginOffset(0)));
            out.write("<font color=\"#0000ff\">");
            out.write(cResult.group(1));
            out.write("</font>");
            this.doDoubleQuotes(cResult.group(2), out);
            out.write("<font color=\"#0000ff\">");
            out.write(cResult.group(3));
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        out.write(aInput);
    }

    private void doDoubleQuotes(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\"(?:\\\\.|[^\"])*\"/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            String aMatch = cResult.toString();
            this.doDigits(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#808080\">");
            out.write(aMatch);
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doDigits(aInput, out);
    }

    private void doDigits(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\b\\d+\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doOperator(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#ff0000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doOperator(aInput, out);
    }

    private void doOperator(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/(?:[\\+\\[\\]\\{\\}\\=\\.\\(\\)\\;\\!]|&amp;)+/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doSpecialWords(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<b>");
            out.write(cResult.toString());
            out.write("</b>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doSpecialWords(aInput, out);
    }

    private void doSpecialWords(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\b(?:as|in|type|gt|lt|gte|lte)\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doOtherWords(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#ff8000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doOtherWords(aInput, out);
    }

    private void doOtherWords(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\w+/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            out.write(aInput.substring(0, cResult.beginOffset(0)));
            out.write("<font color=\"#804040\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        out.write(aInput);
    }
}

