/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Dot;
import freemarker.template.EmptyMap;
import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.Identifier;
import freemarker.template.InvalidReferenceException;
import freemarker.template.Macro;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TextBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class UnifiedCall
extends TemplateElement {
    private Expression nameExp;
    private Map namedArgs;
    private List positionalArgs;
    private List bodyParameterNames;
    boolean notransform;

    UnifiedCall(Expression nameExp, Map namedArgs, TemplateElement nestedBlock, List bodyParameterNames) {
        this.nameExp = nameExp;
        this.namedArgs = namedArgs;
        this.nestedBlock = nestedBlock;
        this.bodyParameterNames = bodyParameterNames;
    }

    UnifiedCall(Expression nameExp, List positionalArgs, TemplateElement nestedBlock, List bodyParameterNames) {
        this.nameExp = nameExp;
        this.positionalArgs = positionalArgs;
        if (nestedBlock == TextBlock.EMPTY_BLOCK) {
            nestedBlock = null;
        }
        this.nestedBlock = nestedBlock;
        this.notransform = !positionalArgs.isEmpty();
        this.bodyParameterNames = bodyParameterNames;
    }

    void accept(Environment env) throws TemplateException, IOException {
        TemplateModel tm = this.nameExp.getAsTemplateModel(env);
        if (!this.notransform && tm instanceof TemplateTransformModel) {
            Map args;
            if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                args = new HashMap();
                Iterator it = this.namedArgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    Expression valueExp = (Expression)entry.getValue();
                    TemplateModel value = valueExp.getAsTemplateModel(env);
                    args.put(key, value);
                }
            } else {
                args = EmptyMap.instance;
            }
            env.visit(this.nestedBlock, (TemplateTransformModel)tm, args);
            return;
        }
        if (tm instanceof Macro) {
            Macro macro = (Macro)tm;
            Macro.Context mc = macro.new Macro.Context();
            mc.bodyParameterNames = this.bodyParameterNames;
            if (this.namedArgs != null) {
                Iterator it = this.namedArgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String varName = (String)entry.getKey();
                    if (!macro.hasArgNamed(varName)) {
                        String msg = this.getStartLocation() + "\nMacro " + macro.getMacroName() + " has no such argument: " + varName;
                        throw new TemplateException(msg, env);
                    }
                    Expression arg = (Expression)entry.getValue();
                    mc.setLocalVar(varName, arg.getAsTemplateModel(env));
                }
            } else if (this.positionalArgs != null) {
                String[] argumentNames = macro.getArgumentNames();
                for (int i = 0; i < this.positionalArgs.size(); ++i) {
                    Expression argExp = (Expression)this.positionalArgs.get(i);
                    TemplateModel argModel = argExp.getAsTemplateModel(env);
                    String argName = argumentNames[i];
                    mc.setLocalVar(argName, argModel);
                }
            }
            mc.body = this.nestedBlock;
            mc.bodyNamespace = env.getCurrentNamespace();
            mc.prevMacroContext = env.getCurrentMacroContext();
            mc.prevLocalContextStack = env.getCurrentLocalContextStack();
            env.visit(mc);
            return;
        }
        if (tm == null) {
            throw new InvalidReferenceException(this.getStartLocation() + " " + this.nameExp + " not found.", env);
        }
        if (this.notransform) {
            throw new TemplateException(this.getStartLocation() + ": " + this.nameExp + " is not a Macro.", env);
        }
        throw new TemplateException(this.getStartLocation() + ": " + this.nameExp + " is not a Macro or Transform.", env);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<@");
        buf.append(this.nameExp.getCanonicalForm());
        if (this.positionalArgs != null) {
            for (int i = 0; i < this.positionalArgs.size(); ++i) {
                Expression arg = (Expression)this.positionalArgs.get(i);
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(' ');
                buf.append(arg.getCanonicalForm());
            }
        } else {
            ArrayList keys = new ArrayList(this.namedArgs.keySet());
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                Expression arg = (Expression)this.namedArgs.get(keys.get(i));
                buf.append(' ');
                buf.append(keys.get(i));
                buf.append('=');
                buf.append(arg.getCanonicalForm());
            }
        }
        if (this.nestedBlock == null) {
            buf.append("/>");
        } else {
            buf.append('>');
            buf.append(this.nestedBlock.getCanonicalForm());
            buf.append("</@");
            if (this.nameExp instanceof Identifier || this.nameExp instanceof Dot && ((Dot)this.nameExp).onlyHasIdentifiers()) {
                buf.append(this.nameExp);
            }
            buf.append('>');
        }
        return buf.toString();
    }

    public String getDescription() {
        return "user-directive " + this.nameExp;
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }
}

