/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.util.StringTokenizer;

final class StringLiteral
extends Expression
implements TemplateScalarModel {
    private final String value;

    StringLiteral(String value) {
        this.value = value;
    }

    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleScalar(this.value);
    }

    public String getAsString() {
        return this.value;
    }

    String getStringValue(Environment env) {
        return this.value;
    }

    public String getCanonicalForm() {
        return "\"" + StringLiteral.escapeString(this.value) + "\"";
    }

    boolean isLiteral() {
        return true;
    }

    Expression _deepClone(String name, Expression subst) {
        return new StringLiteral(this.value);
    }

    private static String escapeString(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        StringTokenizer st = new StringTokenizer(s, "\"", true);
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\"")) {
                buf.append('\\');
            }
            buf.append(tok);
        }
        return buf.toString();
    }
}

