/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class NumberLiteral
extends Expression
implements TemplateNumberModel {
    private final Number value;

    public NumberLiteral(Number value) {
        this.value = value;
    }

    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleNumber(this.value);
    }

    public String getStringValue(Environment env) {
        return env.formatNumber(this.value);
    }

    public Number getAsNumber() {
        return this.value;
    }

    String getName() {
        return "the number: '" + this.value + "'";
    }

    public String getCanonicalForm() {
        return this.value.toString();
    }

    boolean isLiteral() {
        return true;
    }

    Expression _deepClone(String name, Expression subst) {
        return new NumberLiteral(this.value);
    }
}

