/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.BuiltIn;
import freemarker.template.Environment;
import freemarker.template.InvalidReferenceException;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.ClassUtil;
import java.util.List;

class NewBI
extends BuiltIn {
    NewBI() {
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel tm = this.target.getAsTemplateModel(env);
        String classname = null;
        try {
            classname = ((TemplateScalarModel)tm).getAsString();
        }
        catch (ClassCastException cce) {
            NewBI.invalidTypeException(tm, this.target, env, "string");
        }
        catch (NullPointerException npe) {
            throw new InvalidReferenceException(this.getStartLocation() + "\nCould not resolve expression: " + this.target, env);
        }
        return new ConstructorFunction(classname, env);
    }

    class ConstructorFunction
    implements TemplateMethodModelEx {
        private final Class cl;
        private final Environment env;

        public ConstructorFunction(String classname, Environment env) throws TemplateException {
            this.env = env;
            try {
                this.cl = ClassUtil.forName(classname);
            }
            catch (Exception e) {
                throw new TemplateException(e, env);
            }
        }

        public TemplateModel exec(List arguments) throws TemplateModelException {
            ObjectWrapper envWrapper = this.env.getObjectWrapper();
            BeansWrapper beansWrapper = envWrapper instanceof BeansWrapper ? (BeansWrapper)envWrapper : BeansWrapper.getDefaultInstance();
            return beansWrapper.wrap(beansWrapper.newInstance(this.cl, arguments));
        }
    }
}

