/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ArithmeticEngine;
import freemarker.template.Environment;
import freemarker.template.EvaluationUtil;
import freemarker.template.Expression;
import freemarker.template.Interpret;
import freemarker.template.InvalidReferenceException;
import freemarker.template.Macro;
import freemarker.template.NewBI;
import freemarker.template.NonNumericalException;
import freemarker.template.ParentheticalExpression;
import freemarker.template.ParseException;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.StringArraySequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelListSequence;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.utility.StringUtil;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

abstract class BuiltIn
extends Expression
implements Cloneable {
    Expression target;
    String key;
    static final HashMap builtins = new HashMap();

    BuiltIn() {
    }

    static BuiltIn newBuiltIn(Expression target, String key) throws ParseException {
        BuiltIn bi = (BuiltIn)builtins.get(key);
        if (bi == null) {
            StringBuffer buf = new StringBuffer("Expecting one of: ");
            Iterator it = builtins.keySet().iterator();
            while (it.hasNext()) {
                if (it.hasNext()) {
                    buf.append(" ");
                } else {
                    buf.append(" or ");
                }
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(",\n");
            }
            throw new ParseException(buf.toString(), target);
        }
        try {
            bi = (BuiltIn)bi.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        bi.target = target;
        bi.key = key;
        return bi;
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "?" + this.key;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name, Expression subst) {
        try {
            BuiltIn clone = (BuiltIn)this.clone();
            clone.target = this.target.deepClone(name, subst);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    static {
        builtins.put("byte", new byteBI());
        builtins.put("cap_first", new cap_firstBI());
        builtins.put("capitalize", new capitalizeBI());
        builtins.put("chop_linebreak", new chop_linebreakBI());
        builtins.put("date", new dateBI(2));
        builtins.put("datetime", new dateBI(3));
        builtins.put("default", new defaultBI());
        builtins.put("double", new doubleBI());
        builtins.put("ends_with", new ends_withBI());
        builtins.put("exists", new existsBI());
        builtins.put("first", new firstBI());
        builtins.put("float", new floatBI());
        builtins.put("has_content", new has_contentBI());
        builtins.put("html", new htmlBI());
        builtins.put("if_exists", new if_existsBI());
        builtins.put("index_of", new index_ofBI());
        builtins.put("int", new intBI());
        builtins.put("interpret", new Interpret());
        builtins.put("is_string", new is_stringBI());
        builtins.put("is_number", new is_numberBI());
        builtins.put("is_boolean", new is_booleanBI());
        builtins.put("is_date", new is_dateBI());
        builtins.put("is_method", new is_methodBI());
        builtins.put("is_macro", new is_macroBI());
        builtins.put("is_transform", new is_transformBI());
        builtins.put("is_hash", new is_hashBI());
        builtins.put("is_hash_ex", new is_hash_exBI());
        builtins.put("is_sequence", new is_sequenceBI());
        builtins.put("is_collection", new is_collectionBI());
        builtins.put("is_enumerable", new is_enumerableBI());
        builtins.put("is_indexable", new is_indexableBI());
        builtins.put("is_directive", new is_directiveBI());
        builtins.put("j_string", new j_stringBI());
        builtins.put("js_string", new js_stringBI());
        builtins.put("keys", new keysBI());
        builtins.put("last", new lastBI());
        builtins.put("last_index_of", new last_index_ofBI());
        builtins.put("length", new lengthBI());
        builtins.put("long", new longBI());
        builtins.put("lower_case", new lower_caseBI());
        builtins.put("namespace", new namespaceBI());
        builtins.put("new", new NewBI());
        builtins.put("number", new numberBI());
        builtins.put("reverse", new reverseBI());
        builtins.put("rtf", new rtfBI());
        builtins.put("replace", new replaceBI());
        builtins.put("short", new shortBI());
        builtins.put("size", new sizeBI());
        builtins.put("sort", new sortBI());
        builtins.put("sort_by", new sort_byBI());
        builtins.put("split", new splitBI());
        builtins.put("starts_with", new starts_withBI());
        builtins.put("string", new stringBI());
        builtins.put("time", new dateBI(1));
        builtins.put("trim", new trimBI());
        builtins.put("uncap_first", new uncap_firstBI());
        builtins.put("upper_case", new upper_caseBI());
        builtins.put("values", new valuesBI());
        builtins.put("web_safe", builtins.get("html"));
        builtins.put("word_list", new word_listBI());
        builtins.put("xml", new xmlBI());
    }

    static class splitBI
    extends BuiltIn {
        splitBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw splitBI.invalidTypeException(model, this.target, env, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                Object obj;
                if (args.size() != 1) {
                    new TemplateModelException("?split(...) expects exactly 1 argument.");
                }
                if (!((obj = args.get(0)) instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?split(...) expects a string argument");
                }
                return new StringArraySequence(StringUtil.split(this.s, ((TemplateScalarModel)obj).getAsString()));
            }
        }
    }

    static class replaceBI
    extends BuiltIn {
        replaceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw replaceBI.invalidTypeException(model, this.target, env, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                if (args.size() != 2) {
                    throw new TemplateModelException("?replace(...) needs exactly 2 arguments.");
                }
                Object obj1 = args.get(0);
                Object obj2 = args.get(1);
                if (!(obj1 instanceof TemplateScalarModel) || !(obj2 instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("Parameters to ?replace(...) must be strings.");
                }
                return new SimpleScalar(StringUtil.replace(this.s, ((TemplateScalarModel)obj1).getAsString(), ((TemplateScalarModel)obj2).getAsString()));
            }
        }
    }

    static class ends_withBI
    extends BuiltIn {
        ends_withBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw ends_withBI.invalidTypeException(model, this.target, env, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                Object obj;
                if (args.size() != 1) {
                    new TemplateModelException("?ends_with(...) expects exactly 1 argument.");
                }
                if (!((obj = args.get(0)) instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?ends_with(...) expects a string argument");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                return this.s.endsWith(sub) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class starts_withBI
    extends BuiltIn {
        starts_withBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw starts_withBI.invalidTypeException(model, this.target, env, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                Object obj;
                if (args.size() != 1) {
                    new TemplateModelException("?starts_with(...) expects exactly 1 argument.");
                }
                if (!((obj = args.get(0)) instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?starts_with(...) expects a string argument");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                return this.s.startsWith(sub) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class last_index_ofBI
    extends BuiltIn {
        last_index_ofBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw last_index_ofBI.invalidTypeException(model, this.target, env, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                int ln = args.size();
                if (ln == 0) {
                    new TemplateModelException("?last_index_of(...) expects at least one argument.");
                }
                if (ln > 2) {
                    throw new TemplateModelException("?last_index_of(...) expects at most two arguments.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?last_index_of(...) expects a string as its first argument.");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                if (ln > 1) {
                    obj = args.get(1);
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException("?last_index_of(...) expects a number as its second argument.");
                    }
                    int fidx = ((TemplateNumberModel)obj).getAsNumber().intValue();
                    return new SimpleNumber(this.s.lastIndexOf(sub, fidx));
                }
                return new SimpleNumber(this.s.lastIndexOf(sub));
            }
        }
    }

    static class index_ofBI
    extends BuiltIn {
        index_ofBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)model).getAsString());
            }
            throw index_ofBI.invalidTypeException(model, this.target, env, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                int fidx;
                int ln = args.size();
                if (ln == 0) {
                    new TemplateModelException("?index_of(...) expects at least one argument.");
                }
                if (ln > 2) {
                    throw new TemplateModelException("?index_of(...) expects at most two arguments.");
                }
                Object obj = args.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?index_of(...) expects a string as its first argument.");
                }
                String sub = ((TemplateScalarModel)obj).getAsString();
                if (ln > 1) {
                    obj = args.get(1);
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException("?index_of(...) expects a number as its second argument.");
                    }
                    fidx = ((TemplateNumberModel)obj).getAsNumber().intValue();
                } else {
                    fidx = 0;
                }
                return new SimpleNumber(this.s.indexOf(sub, fidx));
            }
        }
    }

    static class defaultBI
    extends BuiltIn {
        private static final TemplateMethodModelEx FIRST_NON_NULL_METHOD = new TemplateMethodModelEx(){

            public TemplateModel exec(List args) throws TemplateModelException {
                if (args.isEmpty()) {
                    throw new TemplateModelException("?default(arg) expects at least one argument.");
                }
                TemplateModel result = null;
                for (int i = 0; i < args.size() && (result = (TemplateModel)args.get(i)) == null; ++i) {
                }
                return result;
            }
        };

        defaultBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return model == null ? FIRST_NON_NULL_METHOD : new ConstantMethod(model);
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return FIRST_NON_NULL_METHOD;
                }
                throw ire;
            }
        }

        private static class ConstantMethod
        implements TemplateMethodModelEx {
            private final TemplateModel constant;

            ConstantMethod(TemplateModel constant) {
                this.constant = constant;
            }

            public TemplateModel exec(List args) throws TemplateModelException {
                return this.constant;
            }
        }
    }

    static class namespaceBI
    extends BuiltIn {
        namespaceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            if (!(tm instanceof Macro)) {
                namespaceBI.invalidTypeException(tm, this.target, env, "macro");
            }
            return env.getMacroNamespace((Macro)tm);
        }
    }

    static class is_directiveBI
    extends BuiltIn {
        is_directiveBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_directiveBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateTransformModel || tm instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_enumerableBI
    extends BuiltIn {
        is_enumerableBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_enumerableBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateSequenceModel || tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_indexableBI
    extends BuiltIn {
        is_indexableBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_indexableBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_collectionBI
    extends BuiltIn {
        is_collectionBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_collectionBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_sequenceBI
    extends BuiltIn {
        is_sequenceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_sequenceBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hash_exBI
    extends BuiltIn {
        is_hash_exBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_hash_exBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateHashModelEx ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hashBI
    extends BuiltIn {
        is_hashBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_hashBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateHashModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_transformBI
    extends BuiltIn {
        is_transformBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_transformBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateTransformModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_macroBI
    extends BuiltIn {
        is_macroBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_macroBI.assertNonNull(tm, this.target, env);
            return tm instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_methodBI
    extends BuiltIn {
        is_methodBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_methodBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateMethodModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_dateBI
    extends BuiltIn {
        is_dateBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_dateBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateDateModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_booleanBI
    extends BuiltIn {
        is_booleanBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_booleanBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateBooleanModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_numberBI
    extends BuiltIn {
        is_numberBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_numberBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateNumberModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_stringBI
    extends BuiltIn {
        is_stringBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel tm = this.target.getAsTemplateModel(env);
            is_stringBI.assertNonNull(tm, this.target, env);
            return tm instanceof TemplateScalarModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class if_existsBI
    extends BuiltIn {
        if_existsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return model == null ? TemplateModel.NOTHING : model;
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateModel.NOTHING;
                }
                throw ire;
            }
        }
    }

    static class has_contentBI
    extends BuiltIn {
        has_contentBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return Expression.isEmpty(model) ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateBooleanModel.FALSE;
                }
                throw ire;
            }
        }

        boolean isTrue(Environment env) throws TemplateException {
            return this._getAsTemplateModel(env) == TemplateBooleanModel.TRUE;
        }
    }

    static class existsBI
    extends BuiltIn {
        existsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            try {
                TemplateModel model = this.target.getAsTemplateModel(env);
                return model == null ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
            }
            catch (InvalidReferenceException ire) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateBooleanModel.FALSE;
                }
                throw ire;
            }
        }

        boolean isTrue(Environment env) throws TemplateException {
            return this._getAsTemplateModel(env) == TemplateBooleanModel.TRUE;
        }
    }

    static class sizeBI
    extends BuiltIn {
        sizeBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateSequenceModel) {
                int size = ((TemplateSequenceModel)model).size();
                return new SimpleNumber(size);
            }
            if (model instanceof TemplateHashModelEx) {
                int size = ((TemplateHashModelEx)model).size();
                return new SimpleNumber(size);
            }
            throw sizeBI.invalidTypeException(model, this.target, env, "extended hash or sequence");
        }
    }

    static class valuesBI
    extends BuiltIn {
        valuesBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateHashModelEx) {
                TemplateCollectionModel values = ((TemplateHashModelEx)model).values();
                valuesBI.assertNonNull(values, this, env);
                return values;
            }
            throw valuesBI.invalidTypeException(model, this.target, env, "extended hash");
        }
    }

    static class keysBI
    extends BuiltIn {
        keysBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateHashModelEx) {
                TemplateCollectionModel keys = ((TemplateHashModelEx)model).keys();
                keysBI.assertNonNull(keys, this, env);
                return keys;
            }
            throw keysBI.invalidTypeException(model, this.target, env, "extended hash");
        }
    }

    static class rtfBI
    extends StringBuiltIn {
        rtfBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.RTFEnc(s));
        }
    }

    static class xmlBI
    extends StringBuiltIn {
        xmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.XMLEnc(s));
        }
    }

    static class htmlBI
    extends StringBuiltIn {
        htmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.HTMLEnc(s));
        }
    }

    static class trimBI
    extends StringBuiltIn {
        trimBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.trim());
        }
    }

    static class stringBI
    extends BuiltIn {
        stringBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateNumberModel) {
                return new NumberFormatter(EvaluationUtil.getNumber((TemplateNumberModel)model, this.target, env), env);
            }
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dm = (TemplateDateModel)model;
                int dateType = dm.getDateType();
                return new DateFormatter(EvaluationUtil.getDate(dm, this.target, env), dateType, env);
            }
            if (model instanceof SimpleScalar) {
                return model;
            }
            if (model instanceof TemplateBooleanModel) {
                return new BooleanFormatter((TemplateBooleanModel)model, env);
            }
            if (model instanceof TemplateScalarModel) {
                return new SimpleScalar(((TemplateScalarModel)model).getAsString());
            }
            throw stringBI.invalidTypeException(model, this.target, env, "number, date, or string");
        }

        private static class BooleanFormatter
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final TemplateBooleanModel bool;
            private final Environment env;

            BooleanFormatter(TemplateBooleanModel bool, Environment env) {
                this.bool = bool;
                this.env = env;
            }

            public String getAsString() throws TemplateModelException {
                if (this.bool instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)((Object)this.bool)).getAsString();
                }
                return this.env.getBooleanFormat(this.bool.getAsBoolean());
            }

            public TemplateModel exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 2) {
                    throw new TemplateModelException("boolean?string(...) requires exactly 2 arguments.");
                }
                return new SimpleScalar((String)arguments.get(this.bool.getAsBoolean() ? 0 : 1));
            }
        }

        private static class DateFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Date date;
            private final int dateType;
            private final Environment env;
            private final DateFormat defaultFormat;
            private String cachedValue;

            DateFormatter(Date date, int dateType, Environment env) throws TemplateModelException {
                this.date = date;
                this.dateType = dateType;
                this.env = env;
                this.defaultFormat = env.getDateFormatObject(dateType);
            }

            public String getAsString() throws TemplateModelException {
                if (this.dateType == 0) {
                    throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
                }
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.date);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                return new SimpleScalar(this.env.getDateFormatObject(this.dateType, key).format(this.date));
            }

            public TemplateModel exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 1) {
                    throw new TemplateModelException("date?string(...) requires exactly 1 argument.");
                }
                return this.get((String)arguments.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }

        private static class NumberFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Number number;
            private final Environment env;
            private final NumberFormat defaultFormat;
            private String cachedValue;

            NumberFormatter(Number number, Environment env) {
                this.number = number;
                this.env = env;
                this.defaultFormat = env.getNumberFormatObject(env.getNumberFormat());
            }

            public String getAsString() {
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.number);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                return new SimpleScalar(this.env.getNumberFormatObject(key).format(this.number));
            }

            public TemplateModel exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 1) {
                    throw new TemplateModelException("number?string(...) requires exactly 1 argument.");
                }
                return this.get((String)arguments.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }
    }

    static class dateBI
    extends BuiltIn {
        private final int dateType;

        dateBI(int dateType) {
            this.dateType = dateType;
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dmodel = (TemplateDateModel)model;
                int dtype = dmodel.getDateType();
                if (this.dateType == dtype) {
                    return model;
                }
                if (dtype == 0 || dtype == 3) {
                    return new SimpleDate(dmodel.getAsDate(), this.dateType);
                }
                throw new TemplateException("Cannot convert " + TemplateDateModel.TYPE_NAMES.get(dtype) + " into " + TemplateDateModel.TYPE_NAMES.get(this.dateType), env);
            }
            String s = this.target.getStringValue(env);
            return new DateParser(s, env);
        }

        private class DateParser
        implements TemplateDateModel,
        TemplateMethodModel,
        TemplateHashModel {
            private final String text;
            private final Environment env;
            private final DateFormat defaultFormat;
            private Date cachedValue;

            DateParser(String text, Environment env) throws TemplateModelException {
                this.text = text;
                this.env = env;
                this.defaultFormat = env.getDateFormatObject(dateBI.this.dateType);
            }

            public Date getAsDate() throws TemplateModelException {
                if (this.cachedValue == null) {
                    this.cachedValue = this.parse(this.defaultFormat);
                }
                return this.cachedValue;
            }

            public int getDateType() {
                return dateBI.this.dateType;
            }

            public TemplateModel get(String pattern) throws TemplateModelException {
                return new SimpleDate(this.parse(this.env.getDateFormatObject(dateBI.this.dateType, pattern)), dateBI.this.dateType);
            }

            public TemplateModel exec(List arguments) throws TemplateModelException {
                if (arguments.size() != 1) {
                    throw new TemplateModelException("string?" + dateBI.this.key + "(...) requires exactly 1 argument.");
                }
                return this.get((String)arguments.get(0));
            }

            public boolean isEmpty() {
                return false;
            }

            private Date parse(DateFormat df) throws TemplateModelException {
                try {
                    return df.parse(this.text);
                }
                catch (java.text.ParseException e) {
                    String mess = "Error: " + dateBI.this.getStartLocation() + "\nExpecting a date here, found: " + this.text;
                    throw new TemplateModelException(mess);
                }
            }
        }
    }

    static class numberBI
    extends BuiltIn {
        numberBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateNumberModel) {
                return model;
            }
            String s = this.target.getStringValue(env);
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s));
            }
            catch (NumberFormatException nfe) {
                String mess = "Error: " + this.getStartLocation() + "\nExpecting a number here, found: " + s;
                throw new NonNumericalException(mess, env);
            }
        }
    }

    static class word_listBI
    extends StringBuiltIn {
        word_listBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            SimpleSequence result = new SimpleSequence();
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
            return result;
        }
    }

    static class lower_caseBI
    extends StringBuiltIn {
        lower_caseBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.toLowerCase(env.getLocale()));
        }
    }

    static class upper_caseBI
    extends StringBuiltIn {
        upper_caseBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.toUpperCase(env.getLocale()));
        }
    }

    static class uncap_firstBI
    extends StringBuiltIn {
        uncap_firstBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            int i;
            int ln = s.length();
            for (i = 0; i < ln && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i < ln) {
                StringBuffer b = new StringBuffer(s);
                b.setCharAt(i, Character.toLowerCase(s.charAt(i)));
                s = b.toString();
            }
            return new SimpleScalar(s);
        }
    }

    static class cap_firstBI
    extends StringBuiltIn {
        cap_firstBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            int i;
            int ln = s.length();
            for (i = 0; i < ln && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i < ln) {
                StringBuffer b = new StringBuffer(s);
                b.setCharAt(i, Character.toUpperCase(s.charAt(i)));
                s = b.toString();
            }
            return new SimpleScalar(s);
        }
    }

    static class js_stringBI
    extends StringBuiltIn {
        js_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.javaScriptStringEnc(s));
        }
    }

    static class j_stringBI
    extends StringBuiltIn {
        j_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.javaStringEnc(s));
        }
    }

    static class chop_linebreakBI
    extends StringBuiltIn {
        chop_linebreakBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.chomp(s));
        }
    }

    static class capitalizeBI
    extends StringBuiltIn {
        capitalizeBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.capitalize(s));
        }
    }

    static class lengthBI
    extends BuiltIn {
        lengthBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            return new SimpleNumber(this.target.getStringValue(env).length());
        }
    }

    static abstract class StringBuiltIn
    extends BuiltIn {
        StringBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            return this.calculateResult(this.target.getStringValue(env), env);
        }

        abstract TemplateModel calculateResult(String var1, Environment var2);
    }

    static class doubleBI
    extends NumberBuiltIn {
        doubleBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Double) {
                return model;
            }
            return new SimpleNumber(num.doubleValue());
        }
    }

    static class floatBI
    extends NumberBuiltIn {
        floatBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Float) {
                return model;
            }
            return new SimpleNumber(num.floatValue());
        }
    }

    static class longBI
    extends NumberBuiltIn {
        longBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Long) {
                return model;
            }
            return new SimpleNumber(num.longValue());
        }
    }

    static class intBI
    extends NumberBuiltIn {
        intBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Integer) {
                return model;
            }
            return new SimpleNumber(num.intValue());
        }
    }

    static class shortBI
    extends NumberBuiltIn {
        shortBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Short) {
                return model;
            }
            return new SimpleNumber(new Short(num.shortValue()));
        }
    }

    static class byteBI
    extends NumberBuiltIn {
        byteBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Byte) {
                return model;
            }
            return new SimpleNumber(new Byte(num.byteValue()));
        }
    }

    static abstract class NumberBuiltIn
    extends BuiltIn {
        NumberBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            return this.calculateResult(EvaluationUtil.getNumber(model, this.target, env), model);
        }

        abstract TemplateModel calculateResult(Number var1, TemplateModel var2);
    }

    static class sort_byBI
    extends sortBI {
        sort_byBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) throws TemplateModelException {
            return new BIMethod(seq);
        }

        static class BIMethod
        implements TemplateMethodModelEx {
            TemplateSequenceModel seq;

            BIMethod(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public TemplateModel exec(List params) throws TemplateModelException {
                if (params.size() != 1) {
                    throw new TemplateModelException("?sort_by(key) needs exactly 1 argument.");
                }
                Object obj = params.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("The argument to sort_by(key) must be a string");
                }
                String key = ((TemplateScalarModel)obj).getAsString();
                if (key == null) {
                    throw new TemplateModelException("The argument to sort_by(key) is null");
                }
                return sortBI.sort(this.seq, key);
            }
        }
    }

    static class sortBI
    extends SequenceBuiltIn {
        static final int KEY_TYPE_STRING = 1;
        static final int KEY_TYPE_NUMBER = 2;

        sortBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) throws TemplateModelException {
            return sortBI.sort(seq, null);
        }

        static String startErrorMessage(String key) {
            return (key == null ? "?sort" : "?sort_by(...)") + " failed: ";
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static TemplateSequenceModel sort(TemplateSequenceModel seq, String key) throws TemplateModelException {
            int i;
            void var7_5;
            int keyType;
            int ln = seq.size();
            ArrayList<Object> res = new ArrayList<Object>(ln);
            if (ln == 0) return new TemplateModelListSequence(res);
            TemplateModel item = seq.get(0);
            if (key != null) {
                if (!(item instanceof TemplateHashModel)) {
                    throw new TemplateModelException(sortBI.startErrorMessage(key) + "You can't use ?sort_by when the " + "sequence items are not hashes.");
                }
                if ((item = ((TemplateHashModel)item).get(key)) == null) {
                    throw new TemplateModelException(sortBI.startErrorMessage(key) + "The key " + StringUtil.jQuote(key) + " was not found in the sequence item.");
                }
            }
            if (item instanceof TemplateScalarModel) {
                keyType = 1;
            } else {
                if (!(item instanceof TemplateNumberModel)) throw new TemplateModelException(sortBI.startErrorMessage(key) + "Values used for sorting must be numbers or strings.");
                keyType = 2;
            }
            if (key == null) {
                if (var7_5 == true) {
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        if (!(item instanceof TemplateScalarModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(key) + "All values in the sequence must be " + "strings, because the first value " + "was a string. " + "The value at index " + i + " is not string.");
                        }
                        res.add(new KVP(((TemplateScalarModel)item).getAsString(), item));
                    }
                } else {
                    if (var7_5 != 2) throw new RuntimeException("Bug: Bad key type");
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        if (!(item instanceof TemplateNumberModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(key) + "All values in the sequence must be " + "numbers, because the first value " + "was a number. " + "The value at index " + i + " is not number.");
                        }
                        res.add(new KVP(((TemplateNumberModel)item).getAsNumber(), item));
                    }
                }
            } else {
                for (i = 0; i < ln; ++i) {
                    item = seq.get(i);
                    if (!(item instanceof TemplateHashModel)) {
                        throw new TemplateModelException(sortBI.startErrorMessage(key) + "All values in the sequence must be " + "hashes, because you use a key to " + "access the value used for the sorting. " + "The value at index " + i + " is not a hash.");
                    }
                    TemplateModel obj = ((TemplateHashModel)item).get(key);
                    if (obj == null) {
                        throw new TemplateModelException(sortBI.startErrorMessage(key) + "The key " + StringUtil.jQuote(key) + " was not found in the value at " + "index " + i);
                    }
                    if (var7_5 == true) {
                        if (!(obj instanceof TemplateScalarModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(key) + "All key values in the sequence must be " + "strings, because the first key " + "value was a string. The key value at " + "index " + i + " is not a string.");
                        }
                        res.add(new KVP(((TemplateScalarModel)obj).getAsString(), item));
                        continue;
                    }
                    if (var7_5 != 2) throw new RuntimeException("Bug: Bad key type");
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException(sortBI.startErrorMessage(key) + "All key values in the sequence must be " + "numbers, because the first key " + "value was a number. The key value at " + "index " + i + " is not a number.");
                    }
                    res.add(new KVP(((TemplateNumberModel)obj).getAsNumber(), item));
                }
            }
            if (var7_5 == true) {
                LexicalKVPComparator lexicalKVPComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
            } else {
                if (var7_5 != 2) throw new RuntimeException("Bug: Bad key type");
                NumericalKVPComparator numericalKVPComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
            }
            try {
                void var8_10;
                Collections.sort(res, var8_10);
            }
            catch (ClassCastException exc) {
                throw new TemplateModelException(sortBI.startErrorMessage(key) + "Unexpected error while sorting:" + exc, exc);
            }
            for (i = 0; i < ln; ++i) {
                res.set(i, ((KVP)res.get(i)).value);
            }
            return new TemplateModelListSequence(res);
        }

        private static class LexicalKVPComparator
        implements Comparator {
            private Collator collator;

            LexicalKVPComparator(Collator collator) {
                this.collator = collator;
            }

            public int compare(Object arg0, Object arg1) {
                return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
            }
        }

        private static class NumericalKVPComparator
        implements Comparator {
            private ArithmeticEngine ae;

            private NumericalKVPComparator(ArithmeticEngine ae) {
                this.ae = ae;
            }

            public int compare(Object arg0, Object arg1) {
                try {
                    return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
                }
                catch (TemplateException e) {
                    throw new ClassCastException("Failed to compare numbers: " + e);
                }
            }
        }

        private static class KVP {
            private Object key;
            private Object value;

            private KVP(Object key, Object value) {
                this.key = key;
                this.value = value;
            }
        }
    }

    static class reverseBI
    extends SequenceBuiltIn {
        reverseBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) {
            if (tsm instanceof ReverseSequence) {
                return ((ReverseSequence)tsm).seq;
            }
            return new ReverseSequence(tsm);
        }

        private static class ReverseSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel seq;

            ReverseSequence(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public int size() throws TemplateModelException {
                return this.seq.size();
            }

            public TemplateModel get(int index) throws TemplateModelException {
                return this.seq.get(this.seq.size() - 1 - index);
            }
        }
    }

    static class lastBI
    extends SequenceBuiltIn {
        lastBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(tsm.size() - 1);
        }
    }

    static class firstBI
    extends SequenceBuiltIn {
        firstBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(0);
        }
    }

    static abstract class SequenceBuiltIn
    extends BuiltIn {
        SequenceBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (!(model instanceof TemplateSequenceModel)) {
                throw SequenceBuiltIn.invalidTypeException(model, this.target, env, "sequence");
            }
            return this.calculateResult((TemplateSequenceModel)model);
        }

        abstract TemplateModel calculateResult(TemplateSequenceModel var1) throws TemplateModelException;
    }
}

