/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Assignment;
import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.ParseException;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateObject;
import java.io.IOException;
import java.util.ArrayList;

final class AssignmentInstruction
extends TemplateElement {
    private int scope;
    private Expression namespaceExp;

    AssignmentInstruction(int scope) {
        this.scope = scope;
        this.nestedElements = new ArrayList(1);
    }

    void addAssignment(Assignment ass) {
        this.nestedElements.add(ass);
    }

    void setNamespaceExp(Expression namespaceExp) {
        this.namespaceExp = namespaceExp;
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ((Assignment)this.nestedElements.get(i)).setNamespaceExp(namespaceExp);
        }
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Assignment ass = (Assignment)this.nestedElements.get(i);
            env.visit(ass);
        }
    }

    public String getCanonicalForm() {
        String tag = "<#local ";
        if (this.scope == 3) {
            tag = "<#global ";
        } else if (this.scope == 1) {
            tag = "<#assign ";
        }
        StringBuffer buf = new StringBuffer(tag);
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Assignment ass = (Assignment)this.nestedElements.get(i);
            buf.append(ass.getCanonicalForm());
            if (i >= this.nestedElements.size() - 1) continue;
            buf.append(" ");
        }
        if (this.namespaceExp != null) {
            buf.append(" in ");
            buf.append(this.namespaceExp.getCanonicalForm());
        }
        buf.append("/>");
        return buf.toString();
    }

    public String getDescription() {
        String tag = "local ";
        if (this.scope == 3) {
            tag = "global ";
        } else if (this.scope == 1) {
            tag = "assign ";
        }
        tag = tag + "assignment";
        if (this.nestedElements.size() > 1) {
            tag = tag + "s";
        }
        return tag;
    }

    public TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        if (this.nestedElements.size() == 1) {
            Assignment ass = (Assignment)this.nestedElements.get(0);
            ass.setLocation(this.getTemplate(), (TemplateObject)this, (TemplateObject)this);
            return ass;
        }
        return this;
    }
}

