/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.module.jmx;

import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.ManageableCaptchaService;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class JMXRegistrationHelper {
    public static void registerToMBeanServer(ManageableCaptchaService service, String name) throws CaptchaServiceException {
        if (name == null) {
            throw new CaptchaServiceException("Service registration name can't be null");
        }
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        if (mbeanServers.size() == 0) {
            throw new CaptchaServiceException("No current MBean Server, skiping the registering process");
        }
        MBeanServer mbeanServer = mbeanServers.get(0);
        try {
            ObjectName objectName = new ObjectName(name);
            mbeanServer.registerMBean(service, objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new CaptchaServiceException(e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new CaptchaServiceException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new CaptchaServiceException("An unexpected exception has been raised : CaptchaService needs maintenance !", e);
        }
        catch (NotCompliantMBeanException e) {
            throw new CaptchaServiceException("Exception trying to register the service to the MBean server", e);
        }
    }

    public static void unregisterFromMBeanServer(String name) {
        if (name != null) {
            ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
            MBeanServer mbeanServer = mbeanServers.get(0);
            try {
                ObjectName objectName = new ObjectName(name);
                mbeanServer.unregisterMBean(objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new CaptchaServiceException("Exception trying to create the object name under witch the service is registered", e);
            }
            catch (InstanceNotFoundException e) {
                throw new CaptchaServiceException("Exception trying to unregister the ImageCaptchaFilter from the MBean server", e);
            }
            catch (MBeanRegistrationException e) {
                throw new CaptchaServiceException("Exception trying to unregister the ImageCaptchaFilter fromthe MBean server", e);
            }
        } else {
            throw new CaptchaServiceException("Service registration name can't be null");
        }
    }
}

