/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.core.MailImpl;
import org.apache.mailet.MailAddress;
import org.masukomi.aspirin.core.Bouncer;
import org.masukomi.aspirin.core.Configuration;
import org.masukomi.aspirin.core.QuedItem;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class RemoteDelivery
implements Runnable {
    private static Log log = LogFactory.getLog((Class)(class$org$masukomi$aspirin$core$RemoteDelivery == null ? (class$org$masukomi$aspirin$core$RemoteDelivery = RemoteDelivery.class$("org.masukomi.aspirin.core.RemoteDelivery")) : class$org$masukomi$aspirin$core$RemoteDelivery));
    protected QuedItem qi;
    private static final String SMTPScheme = "smtp://";
    static /* synthetic */ Class class$org$masukomi$aspirin$core$RemoteDelivery;

    public RemoteDelivery(QuedItem qi) {
        this.qi = qi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deliver(QuedItem qi, Session session) {
        MailAddress rcpt = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"entering RemoteDelivery.deliver(QuedItem qi, Session session)");
            }
            MailImpl mail = (MailImpl)qi.getMail();
            MimeMessage message = mail.getMessage();
            Collection recipients = mail.getRecipients();
            InternetAddress[] addr = new InternetAddress[recipients.size()];
            int j = 0;
            Iterator i = recipients.iterator();
            while (i.hasNext()) {
                MailAddress currentRcpt = (MailAddress)i.next();
                addr[j] = currentRcpt.toInternetAddress();
                ++j;
            }
            if (addr.length <= 0) {
                if (!log.isDebugEnabled()) return true;
                log.debug((Object)"No recipients specified... returning");
                return true;
            }
            Collection targetServers = null;
            Iterator it = recipients.iterator();
            while (it.hasNext() && qi.recepientHasBeenHandled(rcpt = (MailAddress)recipients.iterator().next())) {
            }
            if (rcpt == null) {
                log.error((Object)"unable to find recipient that handn't already been handled");
                return false;
            }
            String host = rcpt.getHost();
            try {
                targetServers = this.getMXRecordsForHost(host);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (targetServers == null || targetServers.size() == 0) {
                log.warn((Object)("No mail server found for: " + host));
                StringBuffer exceptionBuffer = new StringBuffer(128).append("I found no MX record entries for the hostname ").append(host).append(".  I cannot determine where to send this message.");
                return this.failMessage(qi, rcpt, new MessagingException(exceptionBuffer.toString()), true);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(targetServers.size() + " servers found for " + host));
            }
            MessagingException lastError = null;
            Iterator i2 = targetServers.iterator();
            while (true) {
                if (!i2.hasNext()) {
                    if (lastError == null) return false;
                    throw lastError;
                }
                try {
                    StringBuffer logMessageBuffer;
                    URLName outgoingMailServer;
                    block36: {
                        Object var21_32;
                        outgoingMailServer = (URLName)i2.next();
                        logMessageBuffer = new StringBuffer(256).append("Attempting delivery of ").append(mail.getName()).append(" to host ").append(outgoingMailServer.toString()).append(" to addresses ").append(Arrays.asList(addr));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)logMessageBuffer.toString());
                        }
                        Properties props = session.getProperties();
                        if (mail.getSender() == null) {
                            props.put("mail.smtp.from", "<>");
                        } else {
                            String sender = mail.getSender().toString();
                            props.put("mail.smtp.from", sender);
                        }
                        Transport transport = null;
                        try {
                            transport = session.getTransport(outgoingMailServer);
                            try {
                                transport.connect();
                            }
                            catch (MessagingException me) {
                                log.error((Object)me);
                                if (this.failMessage(qi, rcpt, me, false)) {
                                    boolean bl = true;
                                    var21_32 = null;
                                    if (transport == null) return bl;
                                    transport.close();
                                    return bl;
                                }
                                var21_32 = null;
                                if (transport == null) continue;
                                transport.close();
                                transport = null;
                                continue;
                            }
                            transport.sendMessage((Message)message, (Address[])addr);
                            var21_32 = null;
                            if (transport == null) break block36;
                        }
                        catch (Throwable throwable) {
                            var21_32 = null;
                            if (transport == null) throw throwable;
                            transport.close();
                            transport = null;
                            throw throwable;
                        }
                        transport.close();
                        transport = null;
                    }
                    logMessageBuffer = new StringBuffer(256).append("Mail (").append(mail.getName()).append(") sent successfully to ").append(outgoingMailServer);
                    log.debug((Object)logMessageBuffer.toString());
                    qi.succeededForRecipient(rcpt);
                    return true;
                }
                catch (MessagingException me) {
                    log.error((Object)me);
                    StringBuffer exceptionBuffer = new StringBuffer(256).append("Exception delivering message (").append(mail.getName()).append(") - ").append(me.getMessage());
                    log.warn((Object)exceptionBuffer.toString());
                    if (me.getNextException() == null) throw me;
                    if (!(me.getNextException() instanceof IOException)) throw me;
                    lastError = me;
                    continue;
                }
                break;
            }
        }
        catch (SendFailedException sfe) {
            int i;
            Address[] address;
            log.error((Object)sfe);
            boolean deleteMessage = false;
            Collection recipients = qi.getMail().getRecipients();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Recipients: " + recipients));
            }
            if (sfe.getInvalidAddresses() != null && (address = sfe.getInvalidAddresses()).length > 0) {
                recipients.clear();
                for (i = 0; i < address.length; ++i) {
                    try {
                        recipients.add(new MailAddress(address[i].toString()));
                        continue;
                    }
                    catch (ParseException pe) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Can't parse invalid address: " + pe.getMessage()));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid recipients: " + recipients));
                }
                deleteMessage = this.failMessage(qi, rcpt, (MessagingException)((Object)sfe), true);
            }
            if (sfe.getValidUnsentAddresses() == null) return deleteMessage;
            address = sfe.getValidUnsentAddresses();
            if (address.length <= 0) return deleteMessage;
            recipients.clear();
            for (i = 0; i < address.length; ++i) {
                try {
                    recipients.add(new MailAddress(address[i].toString()));
                    continue;
                }
                catch (ParseException pe) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can't parse unsent address: " + pe.getMessage()));
                    }
                    pe.printStackTrace();
                }
            }
            if (!log.isDebugEnabled()) return this.failMessage(qi, rcpt, (MessagingException)((Object)((Object)((Object)sfe))), false);
            log.debug((Object)("Unsent recipients: " + recipients));
            return this.failMessage(qi, rcpt, (MessagingException)((Object)((Object)((Object)sfe))), false);
        }
        catch (MessagingException ex) {
            boolean bl;
            log.error((Object)ex);
            if ('5' == ex.getMessage().charAt(0)) {
                bl = true;
                return this.failMessage(qi, rcpt, ex, bl);
            }
            bl = false;
            return this.failMessage(qi, rcpt, ex, bl);
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
        return false;
    }

    private boolean failMessage(QuedItem qi, MailAddress recepient, MessagingException ex, boolean permanent) {
        log.debug((Object)"entering failMessage(QuedItem qi, MessagingException ex, boolean permanent)");
        MailImpl mail = (MailImpl)qi.getMail();
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        if (permanent) {
            out.print("Permanent");
        } else {
            out.print("Temporary");
        }
        StringBuffer logBuffer = new StringBuffer(64).append(" exception delivering mail (").append(mail.getName()).append(": ");
        out.print(logBuffer.toString());
        ex.printStackTrace(out);
        if (log.isWarnEnabled()) {
            log.warn((Object)sout.toString());
        }
        if (!permanent) {
            if (!mail.getState().equals("error")) {
                mail.setState("error");
                mail.setErrorMessage("0");
                mail.setLastUpdated(new Date());
            }
            if (qi.retryable(recepient)) {
                logBuffer = new StringBuffer(128).append("Storing message ").append(mail.getName()).append(" into que after ").append(qi.getNumAttempts()).append(" attempts");
                if (log.isDebugEnabled()) {
                    log.debug((Object)logBuffer.toString());
                }
                qi.retry(recepient);
                mail.setErrorMessage(qi.getNumAttempts() + "");
                mail.setLastUpdated(new Date());
                return false;
            }
            logBuffer = new StringBuffer(128).append("Bouncing message ").append(mail.getName()).append(" after ").append(qi.getNumAttempts()).append(" attempts");
            if (log.isDebugEnabled()) {
                log.debug((Object)logBuffer.toString());
            }
            qi.failForRecipient(recepient);
        } else {
            qi.failForRecipient(recepient);
        }
        try {
            Bouncer.bounce(mail, ex.toString(), Configuration.getInstance().getPostmaster());
        }
        catch (MessagingException me) {
            log.debug((Object)"failed to bounce");
            log.error((Object)me);
        }
        return true;
    }

    public void run() {
        try {
            Session session = Session.getInstance((Properties)System.getProperties(), null);
            this.deliver(this.qi, session);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public Collection getMXRecordsForHost(String hostName) {
        Vector<URLName> recordsColl = null;
        try {
            Record[] records = new Lookup(hostName, 15).run();
            recordsColl = new Vector<URLName>(records.length);
            for (int i = 0; i < records.length; ++i) {
                MXRecord mx = (MXRecord)records[i];
                String targetString = mx.getTarget().toString();
                URLName uName = new URLName(SMTPScheme + targetString.substring(0, targetString.length() - 1));
                recordsColl.add(uName);
            }
        }
        catch (TextParseException e) {
            log.warn((Object)e);
        }
        return recordsColl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

