/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtil {
    private static final char[] ESCAPES = StringUtil.createEscapes();

    public static String HTMLEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String XMLEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"' && c != '\'') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                    break;
                }
                case '\'': {
                    b.append("&apos;");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                            break;
                        }
                        case '\'': {
                            b.append("&apos;");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String XMLEncNA(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String XMLEncNQG(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '&') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '&') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String RTFEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '{' && c != '}') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '{': {
                    b.append("\\{");
                    break;
                }
                case '}': {
                    b.append("\\}");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '\\' || c == '{' || c == '}') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '\\': {
                            b.append("\\\\");
                            break;
                        }
                        case '{': {
                            b.append("\\{");
                            break;
                        }
                        case '}': {
                            b.append("\\}");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    private static char[] createEscapes() {
        char[] escapes = new char[93];
        for (int i = 0; i < 32; ++i) {
            escapes[i] = (char)i;
        }
        escapes[92] = 92;
        escapes[39] = 39;
        escapes[34] = 34;
        escapes[60] = 108;
        escapes[62] = 103;
        escapes[38] = 97;
        escapes[8] = 98;
        escapes[9] = 116;
        escapes[10] = 110;
        escapes[12] = 102;
        escapes[13] = 114;
        return escapes;
    }

    public static String FTLStringLiteralEnc(String s) {
        StringBuffer buf = new StringBuffer(s);
        int l = s.length();
        int el = ESCAPES.length;
        block4: for (int i = 0; i < l; ++i) {
            char c = buf.charAt(i);
            if (c >= el) continue;
            char escape = ESCAPES[c];
            switch (c) {
                case '\u0000': {
                    continue block4;
                }
                case '\u0001': {
                    continue block4;
                }
                default: {
                    buf.setCharAt(i++, '\\');
                    buf.insert(i, escape);
                    ++l;
                }
            }
        }
        return buf.length() == s.length() ? s : buf.toString();
    }

    public static String FTLStringLiteralDec(String s) throws ParseException {
        int idx = s.indexOf(92);
        if (idx == -1) {
            return s;
        }
        int lidx = s.length() - 1;
        int bidx = 0;
        StringBuffer buf = new StringBuffer(lidx);
        do {
            buf.append(s.substring(bidx, idx));
            if (idx >= lidx) {
                throw new ParseException("The last character of string literal is backslash", 0, 0);
            }
            char c = s.charAt(idx + 1);
            switch (c) {
                case '\"': {
                    buf.append('\"');
                    bidx = idx + 2;
                    break;
                }
                case '\'': {
                    buf.append('\'');
                    bidx = idx + 2;
                    break;
                }
                case '\\': {
                    buf.append('\\');
                    bidx = idx + 2;
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    bidx = idx + 2;
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    bidx = idx + 2;
                    break;
                }
                case 't': {
                    buf.append('\t');
                    bidx = idx + 2;
                    break;
                }
                case 'f': {
                    buf.append('\f');
                    bidx = idx + 2;
                    break;
                }
                case 'b': {
                    buf.append('\b');
                    bidx = idx + 2;
                    break;
                }
                case 'g': {
                    buf.append('>');
                    bidx = idx + 2;
                    break;
                }
                case 'l': {
                    buf.append('<');
                    bidx = idx + 2;
                    break;
                }
                case 'a': {
                    buf.append('&');
                    bidx = idx + 2;
                    break;
                }
                case 'x': {
                    int z;
                    int x = idx += 2;
                    int y = 0;
                    int n = z = lidx > idx + 3 ? idx + 3 : lidx;
                    while (idx <= z) {
                        char b = s.charAt(idx);
                        if (b >= '0' && b <= '9') {
                            y <<= 4;
                            y += b - 48;
                        } else if (b >= 'a' && b <= 'f') {
                            y <<= 4;
                            y += b - 97 + 10;
                        } else {
                            if (b < 'A' || b > 'F') break;
                            y <<= 4;
                            y += b - 65 + 10;
                        }
                        ++idx;
                    }
                    if (x >= idx) {
                        throw new ParseException("Invalid \\x escape in a string literal", 0, 0);
                    }
                    buf.append((char)y);
                    bidx = idx;
                    break;
                }
                default: {
                    throw new ParseException("Invalid escape sequence (\\" + c + ") in a string literal", 0, 0);
                }
            }
        } while ((idx = s.indexOf(92, bidx)) != -1);
        buf.append(s.substring(bidx));
        return buf.toString();
    }

    public static Locale deduceLocale(String input) {
        Locale locale = Locale.getDefault();
        if (input.charAt(0) == '\"') {
            input = input.substring(1, input.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(input, ",_ ");
        String lang = "";
        String country = "";
        if (st.hasMoreTokens()) {
            lang = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            country = st.nextToken();
        }
        locale = !st.hasMoreTokens() ? new Locale(lang, country) : new Locale(lang, country, st.nextToken());
        return locale;
    }

    public static String capitalize(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t\r\n", true);
        StringBuffer buf = new StringBuffer(s.length());
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            buf.append(tok.substring(0, 1).toUpperCase());
            buf.append(tok.substring(1).toLowerCase());
        }
        return buf.toString();
    }

    public static boolean getYesNo(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.equalsIgnoreCase("n") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Illegal boolean value: " + s);
    }

    public static String[] split(String s, char c) {
        int ln = s.length();
        int i = 0;
        int cnt = 1;
        while ((i = s.indexOf(c, i)) != -1) {
            ++cnt;
            ++i;
        }
        String[] res = new String[cnt];
        i = 0;
        int b = 0;
        while (b <= ln) {
            int e = s.indexOf(c, b);
            if (e == -1) {
                e = ln;
            }
            res[i++] = s.substring(b, e);
            b = e + 1;
        }
        return res;
    }

    public static String[] split(String s, String sep) {
        int ln = s.length();
        int sln = sep.length();
        if (sln == 0) {
            throw new IllegalArgumentException("The separator string has 0 length");
        }
        int i = 0;
        int cnt = 1;
        while ((i = s.indexOf(sep, i)) != -1) {
            ++cnt;
            i += sln;
        }
        String[] res = new String[cnt];
        i = 0;
        int b = 0;
        while (b <= ln) {
            int e = s.indexOf(sep, b);
            if (e == -1) {
                e = ln;
            }
            res[i++] = s.substring(b, e);
            b = e + sln;
        }
        return res;
    }

    public static String replace(String text, String oldsub, String newsub) {
        int e = text.indexOf(oldsub);
        if (e == -1) {
            return text;
        }
        int b = 0;
        int tln = text.length();
        int oln = oldsub.length();
        StringBuffer buf = new StringBuffer(tln + 16);
        do {
            buf.append(text.substring(b, e));
            buf.append(newsub);
        } while ((e = text.indexOf(oldsub, b = e + oln)) != -1);
        buf.append(text.substring(b));
        return buf.toString();
    }

    public static String chomp(String s) {
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("\r") || s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String jQuote(String s) {
        int ln = s.length();
        int next = 0;
        StringBuffer b = new StringBuffer(ln + 3);
        b.append("\"");
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c >= ' ') continue;
            b.append(s.substring(next, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                default: {
                    b.append("\\u0000");
                    int x = b.length();
                    String s2 = Integer.toHexString(c);
                    b.replace(x - s2.length(), x, s2);
                }
            }
            next = i + 1;
        }
        if (next < ln) {
            b.append(s.substring(next));
        }
        b.append("\"");
        return b.toString();
    }

    public static String javaStringEnc(String s) {
        int ln = s.length();
        int next = 0;
        StringBuffer b = new StringBuffer(ln + 3);
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c >= ' ') continue;
            b.append(s.substring(next, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                default: {
                    b.append("\\u0000");
                    int x = b.length();
                    String s2 = Integer.toHexString(c);
                    b.replace(x - s2.length(), x, s2);
                }
            }
            next = i + 1;
        }
        if (next < ln) {
            b.append(s.substring(next));
        }
        return b.toString();
    }

    public static String javaScriptStringEnc(String s) {
        int ln = s.length();
        int next = 0;
        StringBuffer b = new StringBuffer(ln + 3);
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'' && c >= ' ') continue;
            b.append(s.substring(next, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\'': {
                    b.append("\\'");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                default: {
                    b.append("\\x");
                    int x = c / 16;
                    b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                    x = c & 0xF;
                    b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                }
            }
            next = i + 1;
        }
        if (next < ln) {
            b.append(s.substring(next));
        }
        return b.toString();
    }
}

