/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MatchResult;

public class JavaToHtml
implements TemplateTransformModel {
    private Perl5Util cMatcher = null;

    public Writer getWriter(final Writer out, Map args) {
        if (this.cMatcher == null) {
            this.cMatcher = new Perl5Util();
        }
        final StringBuffer buf = new StringBuffer();
        return new Writer(){

            public void write(char[] cbuf, int off, int len) {
                buf.append(cbuf, off, len);
            }

            public void flush() throws IOException {
                out.flush();
            }

            public void close() throws IOException {
                StringReader sr = new StringReader(buf.toString());
                StringWriter sw = new StringWriter();
                JavaToHtml.this.transform(sr, sw);
                out.write(sw.toString());
            }
        };
    }

    private void doJavaTransformation(String textBuffer, Writer out) throws IOException {
        textBuffer = this.cMatcher.substitute("s/&/&amp;/g", textBuffer);
        textBuffer = this.cMatcher.substitute("s/</&lt;/g", textBuffer);
        textBuffer = this.cMatcher.substitute("s/>/&gt;/g", textBuffer);
        out.write("<pre>");
        this.doBlockComment(textBuffer, out);
        out.write("</pre>");
    }

    private void doBlockComment(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\/\\*(?:.*?)\\*\\//s", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doDoubleQuotes(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#008000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doDoubleQuotes(aInput, out);
    }

    private void doDoubleQuotes(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\"(?:\\\\.|[^\"])*\"/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            String aMatch = cResult.toString();
            this.doSingleQuotes(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#808080\">");
            out.write(aMatch);
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doSingleQuotes(aInput, out);
    }

    private void doSingleQuotes(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/'(?:\\\\.|[^'])*'/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doLineComment(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#808080\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doLineComment(aInput, out);
    }

    private void doLineComment(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\/\\/.*?$/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doPrimitiveTypes(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#008000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doPrimitiveTypes(aInput, out);
    }

    private void doPrimitiveTypes(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\b(?:boolean|byte|char|double|float|int|long|short|void)\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doKeywords(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#ff8000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doKeywords(aInput, out);
    }

    private void doKeywords(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\b(?:abstract|break|case|catch|class|continue|default|do|else|extends|false|final|finally|for|goto|if|implements|import|instanceof|interface|native|new|null|package|private|protected|public|return|static|strictfp|super|switch|synchronized|this|throw|throws|transient|true|try|volatile|while)\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doJavaPackages(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#0000ff\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doJavaPackages(aInput, out);
    }

    private void doJavaPackages(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\b(?:AbstractCollection|AbstractList|AbstractMap|AbstractSequentialList|AbstractSet|ArrayList|Arrays|BitSet|Boolean|BufferedInputStream|BufferedOutputStream|BufferedReader|BufferedWriter|Byte|ByteArrayInputStream|ByteArrayOutputStream|Calendar|Character|Class|CharArrayReader|CharArrayWriter|ClassLoader|Cloneable|Collection|Collections|Comparable|Comparator|Compiler|DataInput|DataInputStream|DataOutput|DataOutputStream|Date|Dictionary|Double|Enumeration|EventListener|EventObject|Externalizable|File|FileDescriptor|FileFilter|FilenameFilter|FileInputStream|FileOutputStream|FilePermission|FileReader|FileWriter|FilterInputStream|FilterOutputStream|FilterReader|FilterWriter|Float|GregorianCalendar|HashMap|HashSet|Hashtable|InheritableThreadLocal|InputStream|InputStreamReader|Integer|Iterator|LineNumberInputStream|LineNumberReader|LinkedList|List|ListIterator|ListResourceBundle|Locale|Long|Map|Math|Number|Object|ObjectInput|ObjectInputStream|ObjectInputValidation|ObjectOutput|ObjectOutputStream|ObjectStreamClass|ObjectStreamConstants|ObjectStreamField|Observable|Observer|OutputStream|OutputStreamWriter|Package|PipedInputStream|PipedOutputStream|PipedReader|PipedWriter|PrintStream|PrintWriter|Process|Properties|PropertyPermission|PropertyResourceBundle|PushbackInputStream|PushbackReader|Random|RandomAccessFile|Reader|ResourceBundle|Runnable|Runtime|RuntimePermission|SecurityManager|SequenceInputStream|Serializable|SerializablePermission|Set|Short|SimpleTimeZone|SortedMap|SortedSet|Stack|StreamTokenizer|StrictMath|String|StringBuffer|StringBufferInputStream|StringReader|StringTokenizer|StringWriter|System|Thread|ThreadGroup|ThreadLocal|Timer|TimerTask|TimeZone|TreeMap|TreeSet|Vector|Void|WeakHashMap|Writer)\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doDigits(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#804040\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doDigits(aInput, out);
    }

    private void doDigits(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\b\\d+\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doOperator(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<font color=\"#ff0000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doOperator(aInput, out);
    }

    private void doOperator(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/(?:\\w+\\s*\\(|[\\+\\*\\^\\$\\-\\{\\}\\[\\]\\=\\.\\(\\)\\,\\:\\/\\;]|&(lt|gt|amp);)+/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            this.doExceptions(aInput.substring(0, cResult.beginOffset(0)), out);
            out.write("<b>");
            out.write(cResult.toString());
            out.write("</b>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        this.doExceptions(aInput, out);
    }

    private void doExceptions(String aInput, Writer out) throws IOException {
        while (this.cMatcher.match("m/\\w*(Error|Exception|Throwable)\\b/m", aInput)) {
            MatchResult cResult = this.cMatcher.getMatch();
            out.write(aInput.substring(0, cResult.beginOffset(0)));
            out.write("<font color=\"#ff0000\">");
            out.write(cResult.toString());
            out.write("</font>");
            aInput = aInput.substring(cResult.endOffset(0));
        }
        out.write(aInput);
    }

    public void transform(Reader source, Writer output) throws IOException {
        StringBuffer cText = new StringBuffer();
        char[] cBuffer = new char[1024];
        int nSize = source.read(cBuffer);
        while (nSize >= 0) {
            cText.append(cBuffer, 0, nSize);
            nSize = source.read(cBuffer);
        }
        this.doJavaTransformation(cText.toString(), output);
    }
}

